/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.WebElement;
import org.eclipse.orion.server.core.resources.Base64Counter;
import org.json.JSONArray;
import org.json.JSONException;
import org.osgi.service.prefs.BackingStoreException;

public class SiteConfiguration
extends WebElement {
    public static final String SITE_CONFIGURATIONS_NODE_NAME = "SiteConfigurations";
    private static final Base64Counter siteConfigCounter = new Base64Counter();

    public SiteConfiguration(IEclipsePreferences store) {
        super(store);
    }

    public static SiteConfiguration fromId(String id) {
        SiteConfiguration siteConfiguration = new SiteConfiguration((IEclipsePreferences)scope.getNode(SITE_CONFIGURATIONS_NODE_NAME).node(id));
        siteConfiguration.setId(id);
        return siteConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nextSiteConfigurationId() {
        Base64Counter base64Counter = siteConfigCounter;
        synchronized (base64Counter) {
            String candidate;
            do {
                candidate = siteConfigCounter.toString();
                siteConfigCounter.increment();
            } while (SiteConfiguration.siteConfigExists(candidate));
            return candidate;
        }
    }

    public static boolean siteConfigExists(String id) {
        try {
            return scope.getNode(SITE_CONFIGURATIONS_NODE_NAME).nodeExists(id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    void delete() throws CoreException {
        try {
            IEclipsePreferences parent = (IEclipsePreferences)this.store.parent();
            this.store.removeNode();
            parent.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", "Error saving state"));
        }
    }

    public String getHostHint() {
        return this.store.get("HostHint", null);
    }

    public String getWorkspace() {
        return this.store.get("Workspace", null);
    }

    public JSONArray getMappingsJSON() {
        try {
            return new JSONArray(this.store.get("Mappings", "[]"));
        }
        catch (JSONException jSONException) {
            return new JSONArray();
        }
    }

    public void setHostHint(String hostHint) {
        this.store.put("HostHint", hostHint);
    }

    public void setWorkspace(String workspace) {
        this.store.put("Workspace", workspace);
    }

    public void setMappings(JSONArray mappings) {
        this.store.put("Mappings", mappings.toString());
    }
}

