/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.lang.ref.SoftReference;
import org.eclipse.jgit.storage.dfs.DfsPackKey;
import org.eclipse.jgit.storage.dfs.DfsReader;
import org.eclipse.jgit.storage.dfs.DfsReaderOptions;

final class DeltaBaseCache {
    private static final int TABLE_BITS = 10;
    private static final int MASK_BITS = 22;
    private int maxByteCount;
    private final Slot[] table;
    private Slot lruHead;
    private Slot lruTail;
    private int curByteCount;

    private static int hash(long position) {
        return (int)position << 22 >>> 22;
    }

    DeltaBaseCache(DfsReader reader) {
        DfsReaderOptions options = reader.getOptions();
        this.maxByteCount = options.getDeltaBaseCacheLimit();
        this.table = new Slot[1024];
    }

    Entry get(DfsPackKey key, long position) {
        Slot e = this.table[DeltaBaseCache.hash(position)];
        while (e != null) {
            Entry buf;
            if (e.offset == position && key.equals(e.pack) && (buf = e.data.get()) != null) {
                this.moveToHead(e);
                return buf;
            }
            e = e.tableNext;
        }
        return null;
    }

    void put(DfsPackKey key, long offset, int objectType, byte[] data) {
        if (data.length > this.maxByteCount) {
            return;
        }
        this.curByteCount += data.length;
        this.releaseMemory();
        int tableIdx = DeltaBaseCache.hash(offset);
        Slot e = new Slot(key, offset, data.length);
        e.data = new SoftReference<Entry>(new Entry(data, objectType));
        e.tableNext = this.table[tableIdx];
        this.table[tableIdx] = e;
        this.moveToHead(e);
    }

    private void releaseMemory() {
        while (this.curByteCount > this.maxByteCount && this.lruTail != null) {
            Slot currOldest = this.lruTail;
            Slot nextOldest = currOldest.lruPrev;
            this.curByteCount -= currOldest.size;
            this.unlink(currOldest);
            this.removeFromTable(currOldest);
            if (nextOldest == null) {
                this.lruHead = null;
            } else {
                nextOldest.lruNext = null;
            }
            this.lruTail = nextOldest;
        }
    }

    private void removeFromTable(Slot e) {
        int tableIdx = DeltaBaseCache.hash(e.offset);
        Slot p = this.table[tableIdx];
        if (p == e) {
            this.table[tableIdx] = e.tableNext;
            return;
        }
        while (p != null) {
            if (p.tableNext == e) {
                p.tableNext = e.tableNext;
                return;
            }
            p = p.tableNext;
        }
    }

    private void moveToHead(Slot e) {
        this.unlink(e);
        e.lruPrev = null;
        e.lruNext = this.lruHead;
        if (this.lruHead != null) {
            this.lruHead.lruPrev = e;
        } else {
            this.lruTail = e;
        }
        this.lruHead = e;
    }

    private void unlink(Slot e) {
        Slot prev = e.lruPrev;
        Slot next = e.lruNext;
        if (prev != null) {
            prev.lruNext = next;
        }
        if (next != null) {
            next.lruPrev = prev;
        }
    }

    static class Entry {
        final byte[] data;
        final int type;

        Entry(byte[] aData, int aType) {
            this.data = aData;
            this.type = aType;
        }
    }

    private static class Slot {
        final DfsPackKey pack;
        final long offset;
        final int size;
        Slot tableNext;
        Slot lruPrev;
        Slot lruNext;
        SoftReference<Entry> data;

        Slot(DfsPackKey key, long offset, int size) {
            this.pack = key;
            this.offset = offset;
            this.size = size;
        }
    }
}

