/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.BaseToIndexConverter;
import org.eclipse.orion.server.git.BaseToRemoteConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Remote;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteBranch
extends GitObject {
    public static final String TYPE = "RemoteTrackingBranch";
    private Remote remote;
    private String name;

    public RemoteBranch(URI cloneLocation, Repository db, Remote remote, String name) {
        super(cloneLocation, db);
        this.remote = remote;
        this.name = name;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        Set configNames = this.getConfig().getSubsections("remote");
        for (String configName : configNames) {
            if (!configName.equals(this.remote.getName())) continue;
            String fullName = "refs/remotes/" + this.remote.getName() + "/" + this.name;
            Ref ref = this.db.getRefDatabase().getRef(fullName);
            if (ref == null || ref.isSymbolic()) continue;
            JSONObject result = super.toJSON();
            result.put("Name", (Object)Repository.shortenRefName((String)fullName));
            result.put("FullName", (Object)fullName);
            result.put("Id", (Object)ref.getObjectId().name());
            result.put("CommitLocation", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, ref.getObjectId().name(), BaseToCommitConverter.REMOVE_FIRST_2));
            result.put("HeadLocation", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, "HEAD", BaseToCommitConverter.REMOVE_FIRST_2));
            result.put("IndexLocation", (Object)BaseToIndexConverter.getIndexLocation(this.cloneLocation, BaseToIndexConverter.CLONE));
            return result;
        }
        return null;
    }

    @Override
    public URI getLocation() throws URISyntaxException {
        if (this.cloneLocation == null) {
            return null;
        }
        return BaseToRemoteConverter.REMOVE_FIRST_2.baseToRemoteLocation(this.cloneLocation, this.remote.getName(), this.name);
    }

    public String toString() {
        return "RemoteBranch [remote=" + this.remote + ", name=" + this.name + "]";
    }

    @Override
    protected String getType() {
        return TYPE;
    }
}

