/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.orion.server.git.objects.GitObject;
import org.json.JSONException;
import org.json.JSONObject;

public class Tag
extends GitObject {
    public static final String RESOURCE = "tag";
    public static final String TYPE = "Tag";
    public static final Comparator<Tag> COMPARATOR = new Comparator<Tag>(){

        @Override
        public int compare(Tag o1, Tag o2) {
            return o1.getTime() < o2.getTime() ? 1 : (o1.getTime() > o2.getTime() ? -1 : o2.getName(false).compareTo(o1.getName(false)));
        }
    };
    private RevTag tag;
    private Ref ref;
    private URI tagLocation;
    private URI commitLocation;

    public Tag(URI cloneLocation, Repository db, Ref ref) throws IOException, CoreException {
        super(cloneLocation, db);
        RevObject any;
        RevWalk rw = new RevWalk(db);
        try {
            any = rw.parseAny((AnyObjectId)db.resolve(ref.getName()));
        }
        finally {
            rw.dispose();
        }
        if (any instanceof RevTag) {
            this.tag = (RevTag)any;
        } else {
            this.ref = ref;
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject result = super.toJSON();
        result.put("Name", (Object)this.getName(false));
        result.put("CommitLocation", (Object)this.getCommitLocation());
        result.put("LocalTimeStamp", (long)this.getTime() * 1000L);
        result.put("TagType", (Object)TagType.valueOf(this));
        result.put("FullName", (Object)this.getName(true));
        return result;
    }

    public JSONObject toJSON(JSONObject log) throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject tagJSON = this.toJSON();
        tagJSON.put("Commit", (Object)log);
        return tagJSON;
    }

    private String getName(boolean fullName) {
        if (this.tag != null) {
            return fullName ? "refs/tags/" + this.tag.getTagName() : this.tag.getTagName();
        }
        if (this.ref != null) {
            return fullName ? this.ref.getName() : Repository.shortenRefName((String)this.ref.getName());
        }
        return null;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        if (this.tagLocation == null) {
            Path p = new Path(this.cloneLocation.getPath());
            p = p.uptoSegment(1).append(RESOURCE).append(this.getName(false)).addTrailingSeparator().append(p.removeFirstSegments(2));
            this.tagLocation = new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), p.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
        }
        return this.tagLocation;
    }

    private URI getCommitLocation() throws URISyntaxException {
        if (this.commitLocation == null) {
            Path p = new Path(this.cloneLocation.getPath());
            p = p.uptoSegment(1).append("commit").append(this.parseCommit().getName()).addTrailingSeparator().append(p.removeFirstSegments(2));
            this.commitLocation = new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), p.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
        }
        return this.commitLocation;
    }

    private int getTime() {
        RevCommit c = this.parseCommit();
        if (c != null) {
            return c.getCommitTime();
        }
        return 0;
    }

    private ObjectId getObjectId() {
        if (this.tag != null) {
            return this.tag.toObjectId();
        }
        if (this.ref != null) {
            return this.ref.getObjectId();
        }
        return null;
    }

    private RevCommit parseCommit() {
        ObjectId oid = this.getObjectId();
        if (oid == null) {
            return null;
        }
        RevWalk walk = new RevWalk(this.db);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)oid);
            return revCommit;
        }
        catch (IOException iOException) {
        }
        finally {
            walk.release();
        }
        return null;
    }

    public String getRevCommitName() {
        return this.parseCommit().getName();
    }

    @Override
    protected String getType() {
        return TYPE;
    }

    private static enum TagType {
        LIGHTWEIGHT,
        ANNOTATED;


        public static TagType valueOf(String string) {
            return Enum.valueOf(TagType.class, string);
        }
    }
}

