/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.json.JSONObject;

public class GitUtils {
    public static File getGitDir(IPath path) throws CoreException {
        Collection<File> values = GitUtils.getGitDirs(path, Traverse.GO_UP).values();
        return values.isEmpty() ? null : values.toArray(new File[0])[0];
    }

    public static File getGitDir(File file) {
        if (file.exists()) {
            while (file != null) {
                if (RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED)) {
                    return file;
                }
                if (RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) {
                    return new File(file, ".git");
                }
                file = file.getParentFile();
            }
        }
        return null;
    }

    public static Map<IPath, File> getGitDirs(IPath path, Traverse traverse) throws CoreException {
        IPath p = path.removeFirstSegments(1);
        IFileStore fileStore = NewFileServlet.getFileStore((IPath)p);
        if (fileStore == null) {
            return null;
        }
        File file = fileStore.toLocalFile(0, null);
        HashMap<IPath, File> result = new HashMap<IPath, File>();
        switch (traverse) {
            case CURRENT: {
                if (RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED)) {
                    result.put((IPath)new Path(""), file);
                    break;
                }
                if (!RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) break;
                result.put((IPath)new Path(""), new File(file, ".git"));
                break;
            }
            case GO_UP: {
                GitUtils.getGitDirsInParents(file, result);
                break;
            }
            case GO_DOWN: {
                GitUtils.getGitDirsInChildren(path, result);
            }
        }
        return result;
    }

    private static void getGitDirsInParents(File file, Map<IPath, File> gitDirs) {
        int levelUp = 0;
        while (file != null) {
            if (file.exists()) {
                if (RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED)) {
                    gitDirs.put(GitUtils.getPathForLevelUp(levelUp), file);
                    return;
                }
                if (RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) {
                    gitDirs.put(GitUtils.getPathForLevelUp(levelUp), new File(file, ".git"));
                    return;
                }
            }
            file = file.getParentFile();
            ++levelUp;
        }
    }

    private static IPath getPathForLevelUp(int levelUp) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < levelUp) {
            sb.append("../");
            ++i;
        }
        return new Path(sb.toString());
    }

    private static void getGitDirsInChildren(IPath path, Map<IPath, File> gitDirs) throws CoreException {
        WebProject webProject;
        IFileStore store;
        File file;
        if (WebProject.exists((String)path.segment(0)) && (file = (store = (webProject = WebProject.fromId((String)path.segment(0))).getProjectStore().getFileStore(path.removeFirstSegments(1))).toLocalFile(0, null)).exists() && file.isDirectory()) {
            File[] folders;
            if (RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED)) {
                gitDirs.put(path.addTrailingSeparator(), file);
                return;
            }
            if (RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) {
                gitDirs.put(path.addTrailingSeparator(), new File(file, ".git"));
                return;
            }
            File[] fileArray = folders = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().equals(".git");
                }
            });
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                GitUtils.getGitDirsInChildren(path.append(folder.getName()), gitDirs);
                ++n2;
            }
            return;
        }
    }

    public static String getRelativePath(IPath filePath, IPath pathToGitRoot) {
        StringBuilder sb = new StringBuilder();
        String file = null;
        if (!filePath.hasTrailingSeparator()) {
            file = filePath.lastSegment();
            filePath = filePath.removeLastSegments(1);
        }
        int i = 0;
        while (i < pathToGitRoot.segments().length) {
            if (pathToGitRoot.segments()[i].equals("..")) {
                sb.append(filePath.segment(filePath.segments().length - pathToGitRoot.segments().length + i)).append("/");
            }
            ++i;
        }
        if (file != null) {
            sb.append(file);
        }
        return sb.toString();
    }

    static GitCredentialsProvider createGitCredentialsProvider(JSONObject json) {
        String username = json.optString("GitSshUsername", null);
        char[] password = json.optString("GitSshPassword", "").toCharArray();
        String knownHosts = json.optString("GitSshKnownHost", null);
        byte[] privateKey = json.optString("GitSshPrivateKey", "").getBytes();
        byte[] publicKey = json.optString("GitSshPublicKey", "").getBytes();
        byte[] passphrase = json.optString("GitSshPassphrase", "").getBytes();
        GitCredentialsProvider cp = new GitCredentialsProvider(null, username, password, knownHosts);
        cp.setPrivateKey(privateKey);
        cp.setPublicKey(publicKey);
        cp.setPassphrase(passphrase);
        return cp;
    }

    public static enum Traverse {
        GO_UP,
        GO_DOWN,
        CURRENT;

    }
}

