/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.basic;

import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.basic.BasicAuthenticationServlet;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class BasicAuthenticationService
implements IAuthenticationService {
    protected static IOrionCredentialsService userAdmin;
    private IOrionUserProfileService userProfileService;
    private boolean registered;

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(resp);
        }
        return user;
    }

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String authHead = req.getHeader("Authorization");
        if (authHead != null && authHead.toUpperCase(Locale.ENGLISH).startsWith(this.getAuthType())) {
            String password;
            String base64 = authHead.substring(6);
            String authString = new String(Base64.decode((byte[])base64.getBytes()));
            if (authString.indexOf(58) < 0) {
                return null;
            }
            String login = authString.substring(0, authString.indexOf(58));
            User user = this.getUserForCredentials(login, password = authString.substring(authString.indexOf(58) + 1));
            if (user != null) {
                return user.getUid();
            }
        }
        return null;
    }

    public String getAuthType() {
        return "BASIC";
    }

    private void setNotAuthenticated(HttpServletResponse resp) throws IOException {
        resp.setHeader("WWW-Authenticate", this.getAuthType());
        resp.sendError(401);
        long start = System.currentTimeMillis();
        long SLEEP_TIME = 1000L;
        while (true) {
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException interruptedException) {
                if (System.currentTimeMillis() - start < SLEEP_TIME) continue;
            }
            break;
        }
    }

    private User getUserForCredentials(String login, String password) {
        if (userAdmin == null) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.basic", "User admin server is not available"));
            return null;
        }
        User user = userAdmin.getUser("login", login);
        if (user != null && user.hasCredential("password", (Object)password)) {
            return user;
        }
        return null;
    }

    public void configure(Properties properties) {
    }

    public void bindUserAdmin(IOrionCredentialsService userAdmin) {
        BasicAuthenticationService.userAdmin = userAdmin;
    }

    public void unbindUserAdmin(IOrionCredentialsService userAdmin) {
        if (userAdmin.equals(BasicAuthenticationService.userAdmin)) {
            BasicAuthenticationService.userAdmin = null;
        }
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean getRegistered() {
        return this.registered;
    }

    public void setHttpService(HttpService httpService) {
        try {
            httpService.registerServlet("/basiclogin", (Servlet)new BasicAuthenticationServlet(this), null, null);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.basic", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.basic", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService httpService) {
        httpService.unregister("/basiclogin");
    }

    public void bindUserProfileService(IOrionUserProfileService _userProfileService) {
        this.userProfileService = _userProfileService;
    }

    public void unbindUserProfileService(IOrionUserProfileService userProfileService) {
        userProfileService = null;
    }

    public IOrionUserProfileService getUserProfileService() {
        return this.userProfileService;
    }
}

