/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.ServletTestingSupport;
import org.eclipse.orion.internal.server.servlets.workspace.WebElementResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.WebProjectResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceResourceHandler
extends WebElementResourceHandler<WebWorkspace> {
    static final int CREATE_COPY = 1;
    static final int CREATE_MOVE = 2;
    static final int CREATE_NO_OVERWRITE = 4;
    private final ServletResourceHandler<IStatus> statusHandler;

    static URI computeProjectContentLocation(URI parentLocation, WebProject project) {
        URI contentLocation = project.getContentLocation();
        if (!contentLocation.isAbsolute() || "file".equals(contentLocation.getScheme())) {
            String contentPathString;
            Path contentPath = new Path(contentLocation.getPath());
            if (contentPath.isAbsolute()) {
                contentPath = new Path(project.getId());
            }
            if (!(contentPathString = contentPath.makeAbsolute().toString()).endsWith("/")) {
                contentPathString = String.valueOf(contentPathString) + "/";
            }
            contentLocation = URIUtil.append((URI)parentLocation, (String)("../file" + contentPathString));
        }
        if (!contentLocation.getPath().endsWith("/")) {
            try {
                contentLocation = new URI(contentLocation.getScheme(), contentLocation.getUserInfo(), contentLocation.getHost(), contentLocation.getPort(), String.valueOf(contentLocation.getPath()) + "/", contentLocation.getQuery(), contentLocation.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return contentLocation;
    }

    public static JSONObject toJSON(WebWorkspace workspace, URI baseLocation) {
        JSONObject result = WebElementResourceHandler.toJSON(workspace);
        JSONArray projects = workspace.getProjectsJSON();
        URI workspaceLocation = URIUtil.append((URI)baseLocation, (String)workspace.getId());
        URI projectBaseLocation = URIUtil.append((URI)workspaceLocation, (String)"project");
        if (projects == null) {
            projects = new JSONArray();
        }
        int i = 0;
        while (i < projects.length()) {
            try {
                JSONObject project = (JSONObject)projects.get(i);
                project.put("Location", (Object)URIUtil.append((URI)projectBaseLocation, (String)project.getString("Id")));
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        try {
            result.put("Location", (Object)workspaceLocation);
            result.put("ChildrenLocation", (Object)workspaceLocation);
            result.put("Projects", (Object)projects);
            result.put("Directory", (Object)"true");
        }
        catch (JSONException jSONException) {}
        JSONArray children = new JSONArray();
        int i2 = 0;
        while (i2 < projects.length()) {
            try {
                WebProject project = WebProject.fromId(projects.getJSONObject(i2).getString("Id"));
                JSONObject child = new JSONObject();
                child.put("Name", (Object)project.getName());
                child.put("Directory", true);
                URI contentLocation = WorkspaceResourceHandler.computeProjectContentLocation(baseLocation, project);
                child.put("Location", (Object)contentLocation);
                try {
                    child.put("LocalTimeStamp", project.getProjectStore().fetchInfo().getLastModified());
                }
                catch (CoreException coreException) {}
                try {
                    child.put("ChildrenLocation", (Object)new URI(contentLocation.getScheme(), contentLocation.getUserInfo(), contentLocation.getHost(), contentLocation.getPort(), contentLocation.getPath(), "depth=1", contentLocation.getFragment()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                child.put("Id", (Object)project.getId());
                children.put((Object)child);
            }
            catch (JSONException jSONException) {}
            ++i2;
        }
        try {
            result.put("Children", (Object)children);
        }
        catch (JSONException jSONException) {}
        return result;
    }

    public WorkspaceResourceHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    private void addProjectRights(HttpServletRequest request, HttpServletResponse response, String location) throws ServletException {
        if (location == null) {
            return;
        }
        try {
            String locationPath = URI.create(location).getPath();
            AuthorizationService.addUserRight(request.getRemoteUser(), locationPath);
            locationPath = locationPath.endsWith("/") ? String.valueOf(locationPath) + "*" : String.valueOf(locationPath) + "/*";
            AuthorizationService.addUserRight(request.getRemoteUser(), locationPath);
        }
        catch (CoreException e) {
            this.statusHandler.handleRequest(request, response, e.getStatus());
        }
    }

    private void removeProjectRights(HttpServletRequest request, HttpServletResponse response, String location) throws ServletException {
        if (location == null) {
            return;
        }
        try {
            String locationPath = URI.create(location).getPath();
            AuthorizationService.removeUserRight(request.getRemoteUser(), locationPath);
            locationPath = locationPath.endsWith("/") ? String.valueOf(locationPath) + "*" : String.valueOf(locationPath) + "/*";
            AuthorizationService.removeUserRight(request.getRemoteUser(), locationPath);
        }
        catch (CoreException e) {
            this.statusHandler.handleRequest(request, response, e.getStatus());
        }
    }

    public static void computeProjectLocation(WebProject project, String location, String user, boolean init) throws URISyntaxException, CoreException {
        URI contentURI;
        if (location == null) {
            contentURI = WorkspaceResourceHandler.generateProjectLocation(project, user);
        } else {
            try {
                contentURI = new URI(location);
                EFS.getFileSystem((String)contentURI.getScheme());
            }
            catch (Exception exception) {
                contentURI = new File(location).toURI();
            }
            if (init) {
                IFileStore child = EFS.getStore((URI)contentURI);
                child.mkdir(0, null);
            }
        }
        project.setContentLocation(contentURI);
        Activator.getDefault().registerProjectLocation(project);
    }

    private static URI generateProjectLocation(WebProject project, String user) throws CoreException, URISyntaxException {
        URI location;
        IFileStore projectStore;
        URI platformLocationURI = Activator.getDefault().getRootLocationURI();
        IFileStore root = EFS.getStore((URI)platformLocationURI);
        String layout = PreferenceHelper.getString((String)"orion.file.layout", (String)"flat").toLowerCase();
        if ("usertree".equals(layout) && user != null) {
            String userPrefix = user.substring(0, Math.min(2, user.length()));
            projectStore = root.getChild(userPrefix).getChild(user).getChild(project.getId());
            location = projectStore.toURI();
        } else {
            projectStore = root.getChild(project.getId());
            location = new URI(null, projectStore.getName(), null);
        }
        projectStore.mkdir(0, null);
        return location;
    }

    private int getCreateOptions(HttpServletRequest request) {
        int result = 0;
        String optionString = request.getHeader("X-Create-Options");
        if (optionString != null) {
            String[] stringArray = optionString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                if ("copy".equalsIgnoreCase(option)) {
                    result |= 1;
                } else if ("move".equalsIgnoreCase(option)) {
                    result |= 2;
                } else if ("no-overwrite".equalsIgnoreCase(option)) {
                    result |= 4;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean getInit(JSONObject toAdd) {
        return toAdd.optBoolean("CreateIfDoesntExist");
    }

    private boolean handleAddOrRemoveProject(HttpServletRequest request, HttpServletResponse response, WebWorkspace workspace) throws IOException, JSONException, ServletException {
        JSONObject data = OrionServlet.readJSONRequest(request);
        if (!data.isNull("Remove")) {
            return this.handleRemoveProject(request, response, workspace);
        }
        int options = this.getCreateOptions(request);
        if ((options & 3) != 0) {
            return this.handleCopyMoveProject(request, response, workspace, data);
        }
        return this.handleAddProject(request, response, workspace, data);
    }

    private boolean handleAddProject(HttpServletRequest request, HttpServletResponse response, WebWorkspace workspace, JSONObject data) throws IOException, ServletException {
        JSONObject toAdd = data;
        String id = toAdd.optString("Id", null);
        if (id == null) {
            id = WebProject.nextProjectId();
        }
        WebProject project = WebProject.fromId(id);
        String name = toAdd.optString("Name", null);
        if (name == null) {
            name = request.getHeader("Slug");
        }
        if (!this.validateProjectName(name, request, response)) {
            return true;
        }
        project.setName(name);
        String content = toAdd.optString("ContentLocation", null);
        if (!this.isAllowedLinkDestination(content, request.getRemoteUser())) {
            String msg = NLS.bind((String)"Cannot link to server path {0}. Use the orion.file.allowedPaths property to specify server locations where content can be linked.", (Object)content);
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 403, msg, null));
        }
        try {
            WorkspaceResourceHandler.computeProjectLocation(project, content, request.getRemoteUser(), this.getInit(toAdd));
        }
        catch (CoreException e) {
            String msg = NLS.bind((String)"Server content location could not be written: {0}", (Object)Activator.getDefault().getRootLocationURI());
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        catch (URISyntaxException e) {
            String msg = NLS.bind((String)"Invalid project location: {0}", (Object)content);
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, msg, (Throwable)e));
        }
        workspace.addProject(project);
        try {
            project.save();
            workspace.save();
        }
        catch (CoreException e) {
            String msg = "Error persisting project state";
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        URI baseLocation = WorkspaceResourceHandler.getURI(request);
        JSONObject result = WebProjectResourceHandler.toJSON(project, baseLocation);
        OrionServlet.writeJSONResponse(request, response, result);
        response.setHeader("Location", result.optString("Location"));
        response.setStatus(201);
        this.addProjectRights(request, response, result.optString("ContentLocation"));
        return true;
    }

    private boolean handleCopyMoveProject(HttpServletRequest request, HttpServletResponse response, WebWorkspace workspace, JSONObject data) throws ServletException, IOException {
        String sourceLocation = data.optString("Location");
        String sourceId = this.projectForLocation(request, response, sourceLocation);
        if (sourceId == null) {
            return true;
        }
        boolean sourceExists = WebProject.exists(sourceId);
        if (!sourceExists) {
            this.handleError(request, response, 400, NLS.bind((String)"Source does not exist: {0}", (Object)sourceId));
            return true;
        }
        int options = this.getCreateOptions(request);
        if (!this.validateOptions(request, response, options)) {
            return true;
        }
        String destinationName = request.getHeader("Slug");
        try {
            if (data != null && data.has("Name")) {
                destinationName = data.getString("Name");
            }
        }
        catch (JSONException jSONException) {}
        if (!this.validateProjectName(destinationName, request, response)) {
            return true;
        }
        WebProject sourceProject = WebProject.fromId(sourceId);
        if ((options & 2) != 0) {
            return this.handleMoveProject(request, response, sourceProject, sourceLocation, destinationName);
        }
        if ((options & 1) != 0) {
            return this.handleCopyProject(request, response, workspace, sourceProject, destinationName);
        }
        return false;
    }

    private boolean handleCopyProject(HttpServletRequest request, HttpServletResponse response, WebWorkspace workspace, WebProject sourceProject, String destinationName) throws IOException, ServletException {
        String destinationId = WebProject.nextProjectId();
        JSONObject projectInfo = new JSONObject();
        try {
            projectInfo.put("Id", (Object)destinationId);
            projectInfo.put("Name", (Object)destinationName);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.handleAddProject(request, response, workspace, projectInfo);
        WebProject destinationProject = WebProject.fromId(destinationId);
        String sourceName = sourceProject.getName();
        try {
            this.copyProjectContents(sourceProject, destinationProject);
        }
        catch (CoreException coreException) {
            this.handleError(request, response, 500, NLS.bind((String)"Error copying project {0} to {1}", (Object)sourceName, (Object)destinationName));
            return true;
        }
        URI baseLocation = WorkspaceResourceHandler.getURI(request);
        JSONObject result = WebProjectResourceHandler.toJSON(destinationProject, baseLocation);
        OrionServlet.writeJSONResponse(request, response, result);
        response.setHeader("Location", result.optString("Location", ""));
        response.setStatus(201);
        return true;
    }

    private boolean handleMoveProject(HttpServletRequest request, HttpServletResponse response, WebProject sourceProject, String sourceLocation, String destinationName) throws ServletException, IOException {
        String sourceName = sourceProject.getName();
        sourceProject.setName(destinationName);
        try {
            sourceProject.save();
        }
        catch (CoreException e) {
            String msg = NLS.bind((String)"Error persisting project state: {0}", (Object)sourceName);
            return this.handleError(request, response, 500, msg, e);
        }
        URI baseLocation = WorkspaceResourceHandler.getURI(request);
        JSONObject result = WebProjectResourceHandler.toJSON(sourceProject, baseLocation);
        OrionServlet.writeJSONResponse(request, response, result);
        response.setHeader("Location", sourceLocation);
        response.setStatus(200);
        return true;
    }

    private void copyProjectContents(WebProject sourceProject, WebProject destinationProject) throws CoreException {
        sourceProject.getProjectStore().copy(destinationProject.getProjectStore(), 2, null);
    }

    private boolean handleError(HttpServletRequest request, HttpServletResponse response, int httpCode, String message) throws ServletException {
        return this.handleError(request, response, httpCode, message, null);
    }

    private boolean handleError(HttpServletRequest request, HttpServletResponse response, int httpCode, String message, Throwable cause) throws ServletException {
        return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, httpCode, message, cause));
    }

    private boolean handleGetWorkspaceMetadata(HttpServletRequest request, HttpServletResponse response, WebWorkspace workspace) throws IOException {
        URI baseLocation = WorkspaceResourceHandler.getURI(request);
        baseLocation = baseLocation.resolve("");
        OrionServlet.writeJSONResponse(request, response, WorkspaceResourceHandler.toJSON(workspace, baseLocation));
        return true;
    }

    private boolean handlePutWorkspaceMetadata(HttpServletRequest request, HttpServletResponse response, WebWorkspace workspace) {
        return false;
    }

    private boolean handleRemoveProject(HttpServletRequest request, HttpServletResponse response, WebWorkspace workspace) throws IOException, JSONException, ServletException {
        Path path = new Path(request.getPathInfo());
        if (path.segmentCount() != 3) {
            return false;
        }
        String projectId = path.segment(2);
        if (!WebProject.exists(projectId)) {
            return true;
        }
        WebProject project = WebProject.fromId(projectId);
        URI baseLocation = WorkspaceResourceHandler.getURI(request).resolve("../../" + path.segment(0));
        JSONObject result = WebProjectResourceHandler.toJSON(project, baseLocation);
        this.removeProjectRights(request, response, result.getString("ContentLocation"));
        workspace.removeProject(project);
        try {
            WorkspaceResourceHandler.removeProject(project, request.getRemoteUser());
        }
        catch (CoreException e) {
            String msg = NLS.bind((String)"Server content location could not be written: {0}", (Object)Activator.getDefault().getRootLocationURI());
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        try {
            project.save();
            workspace.save();
        }
        catch (CoreException e) {
            String msg = "Error persisting project state";
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return true;
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, WebWorkspace workspace) throws ServletException {
        if (workspace == null) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Workspace not specified"));
        }
        try {
            switch (WorkspaceResourceHandler.getMethod(request)) {
                case GET: {
                    return this.handleGetWorkspaceMetadata(request, response, workspace);
                }
                case PUT: {
                    return this.handlePutWorkspaceMetadata(request, response, workspace);
                }
                case POST: {
                    return this.handleAddOrRemoveProject(request, response, workspace);
                }
                case DELETE: {
                    return this.handleRemoveProject(request, response, workspace);
                }
            }
        }
        catch (IOException e) {
            String msg = NLS.bind((String)"Error handling request against workspace {0}", (Object)workspace.getId());
            this.statusHandler.handleRequest(request, response, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg, (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        return false;
    }

    private boolean isAllowedLinkDestination(String content, String user) {
        String userArea;
        if (content == null) {
            return true;
        }
        String prefixes = PreferenceHelper.getString((String)"orion.file.allowedPaths");
        if (prefixes == null) {
            prefixes = ServletTestingSupport.allowedPrefixes;
        }
        if (prefixes != null) {
            StringTokenizer t = new StringTokenizer(prefixes, ",");
            while (t.hasMoreTokens()) {
                String prefix = t.nextToken();
                if (!content.startsWith(prefix)) continue;
                return true;
            }
        }
        if ((userArea = System.getProperty("org.eclipse.orion.server.core.userArea")) == null) {
            return false;
        }
        IPath path = new Path(userArea).append(user);
        URI contentURI = null;
        try {
            URI candidate = new URI(content);
            String scheme = candidate.getScheme();
            if (scheme != null && EFS.getFileSystem((String)scheme) != null) {
                contentURI = candidate;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (CoreException coreException) {}
        if (contentURI == null) {
            contentURI = new File(content).toURI();
        }
        return contentURI.toString().startsWith(path.toFile().toURI().toString());
    }

    private String projectForLocation(HttpServletRequest request, HttpServletResponse response, String sourceLocation) throws ServletException {
        try {
            String id;
            URI sourceURI;
            String path;
            if (sourceLocation != null && (path = (sourceURI = new URI(sourceLocation)).getPath()) != null && (id = new Path(path).lastSegment()) != null) {
                return id;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        this.handleError(request, response, 400, NLS.bind((String)"Invalid source location for copy/move request: {0}", (Object)sourceLocation));
        return null;
    }

    public static void removeProject(WebProject project, String authority) throws CoreException {
        URI platformLocationURI;
        IFileStore child;
        URI contentURI = project.getContentLocation();
        if (project.getId().equals(contentURI.toString()) && (child = EFS.getStore((URI)(platformLocationURI = Activator.getDefault().getRootLocationURI())).getChild(project.getId())).fetchInfo().exists()) {
            child.delete(0, null);
        }
        project.remove();
    }

    private boolean validateOptions(HttpServletRequest request, HttpServletResponse response, int options) throws ServletException {
        int copyMove = 3;
        if ((options & copyMove) == copyMove) {
            this.handleError(request, response, 400, "Syntax error in request");
            return false;
        }
        return true;
    }

    private boolean validateProjectName(String name, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (name == null || name.trim().length() == 0) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Project name cannot be empty", null));
            return false;
        }
        if (name.contains("/")) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, NLS.bind((String)"Invalid project name: {0}", (Object)name), null));
            return false;
        }
        return true;
    }
}

