/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Clone;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.eclipse.osgi.util.NLS;

public class InitJob
extends GitJob {
    private final Clone clone;
    private final String user;

    public InitJob(Clone clone, String userRunningTask, String user, String cloneLocation) {
        super(NLS.bind((String)"Initializing repository {0}", (Object)clone.getName()), userRunningTask, NLS.bind((String)"Initializing repository {0}...", (Object)clone.getName()), false, false);
        this.clone = clone;
        this.user = user;
        this.setFinalLocation(URI.create(cloneLocation));
        this.setFinalMessage("Init complete.");
    }

    public IStatus performJob() {
        try {
            InitCommand command = new InitCommand();
            File directory = new File(this.clone.getContentLocation());
            command.setDirectory(directory);
            Repository repository = command.call().getRepository();
            Git git = new Git(repository);
            GitCloneHandlerV1.doConfigureClone(git, this.user);
            git.commit().setMessage("Initial commit").call();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (GitAPIException e) {
            return this.getGitAPIExceptionStatus(e, "Error initializing git repository");
        }
        catch (JGitInternalException e) {
            return this.getJGitInternalExceptionStatus(e, "Error initializing git repository");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error initializing git repository", (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

