/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.core.users.UserUtilities;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.orion.server.git.objects.Tag;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Commit")
public class Commit
extends GitObject {
    public static final String RESOURCE = "commit";
    public static final String TYPE = "Commit";
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private RevCommit revCommit;
    private String pattern;
    private TreeFilter filter;
    private boolean isRoot;
    private Map<ObjectId, JSONArray> commitToBranchMap;

    public Commit(URI cloneLocation, Repository db, RevCommit revCommit, String pattern) {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("ContentLocation"), new Property("DiffLocation"), new Property("Name"), new Property("AuthorName"), new Property("AuthorEmail"), new Property("AuthorImage"), new Property("CommitterName"), new Property("CommitterEmail"), new Property("Time"), new Property("Message"), new Property("Tags"), new Property("Branches"), new Property("Parents"), new Property("Diffs")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.isRoot = true;
        this.revCommit = revCommit;
        this.pattern = pattern;
        if (pattern != null && !pattern.isEmpty()) {
            this.filter = AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(pattern)), (TreeFilter)TreeFilter.ANY_DIFF);
            this.isRoot = false;
        }
    }

    public void setCommitToBranchMap(Map<ObjectId, JSONArray> map) {
        this.commitToBranchMap = map;
    }

    public Map<ObjectId, JSONArray> getCommitToBranchMap() throws GitAPIException, JSONException, URISyntaxException, IOException, CoreException {
        if (this.commitToBranchMap == null) {
            this.commitToBranchMap = Log.getCommitToBranchMap(this.cloneLocation, this.db);
        }
        return this.commitToBranchMap;
    }

    public ObjectStream toObjectStream() throws IOException {
        TreeWalk w = TreeWalk.forPath((Repository)this.db, (String)this.pattern, (RevTree)this.revCommit.getTree());
        if (w == null) {
            return null;
        }
        ObjectId blobId = w.getObjectId(0);
        return this.db.open((AnyObjectId)blobId, 3).openStream();
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="ContentLocation")
    private URI getContentLocation() throws URISyntaxException {
        if (!this.isRoot) {
            return BaseToCommitConverter.getCommitLocation(this.cloneLocation, this.revCommit.getName(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2.setQuery("parts=body"));
        }
        return null;
    }

    @PropertyDescription(name="DiffLocation")
    private URI getDiffLocation() throws URISyntaxException {
        return this.createDiffLocation(this.revCommit.getName(), null, this.pattern);
    }

    @PropertyDescription(name="Name")
    private String getName() {
        return this.revCommit.getName();
    }

    @PropertyDescription(name="AuthorName")
    private String getAuthorName() {
        PersonIdent author = this.revCommit.getAuthorIdent();
        return author.getName();
    }

    @PropertyDescription(name="AuthorEmail")
    private String getAuthorEmail() {
        PersonIdent author = this.revCommit.getAuthorIdent();
        return author.getEmailAddress();
    }

    @PropertyDescription(name="AuthorImage")
    private String getAuthorImage() {
        PersonIdent author = this.revCommit.getAuthorIdent();
        return UserUtilities.getImageLink((String)author.getEmailAddress());
    }

    @PropertyDescription(name="CommitterName")
    private String getCommitterName() {
        PersonIdent committer = this.revCommit.getCommitterIdent();
        return committer.getName();
    }

    @PropertyDescription(name="CommitterEmail")
    private String getCommitterEmail() {
        PersonIdent committer = this.revCommit.getCommitterIdent();
        return committer.getEmailAddress();
    }

    @PropertyDescription(name="Time")
    private long getCommitTime() {
        return (long)this.revCommit.getCommitTime() * 1000L;
    }

    @PropertyDescription(name="Message")
    private String getCommitMessiage() {
        return this.revCommit.getFullMessage();
    }

    @PropertyDescription(name="Tags")
    private JSONArray getTags() throws MissingObjectException, JSONException, URISyntaxException, CoreException, IOException {
        return this.toJSON(this.getTagsForCommit());
    }

    @PropertyDescription(name="Branches")
    private JSONArray getBranches() throws JSONException, GitAPIException, URISyntaxException, IOException, CoreException {
        return this.getCommitToBranchMap().get(this.revCommit.getId());
    }

    @PropertyDescription(name="Parents")
    private JSONArray getParents() throws JSONException, URISyntaxException, IOException, CoreException {
        return this.parentsToJSON(this.revCommit.getParents());
    }

    @PropertyDescription(name="Diffs")
    private JSONArray getDiffs() throws JSONException, URISyntaxException, MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.revCommit.getParentCount() > 0) {
            JSONArray diffs = new JSONArray();
            TreeWalk tw = new TreeWalk(this.db);
            RevWalk rw = new RevWalk(this.db);
            RevCommit parent = rw.parseCommit((AnyObjectId)this.revCommit.getParent(0));
            tw.reset(new AnyObjectId[]{parent.getTree(), this.revCommit.getTree()});
            tw.setRecursive(true);
            if (this.filter != null) {
                tw.setFilter(this.filter);
            } else {
                tw.setFilter(TreeFilter.ANY_DIFF);
            }
            List l = DiffEntry.scan((TreeWalk)tw);
            for (DiffEntry entr : l) {
                JSONObject diff = new JSONObject();
                diff.put("Type", (Object)"Diff");
                diff.put("NewPath", (Object)entr.getNewPath());
                diff.put("OldPath", (Object)entr.getOldPath());
                diff.put("ChangeType", (Object)entr.getChangeType().toString());
                String path = entr.getChangeType() != DiffEntry.ChangeType.DELETE ? entr.getNewPath() : entr.getOldPath();
                diff.put("DiffLocation", (Object)this.createDiffLocation(this.revCommit.getName(), this.revCommit.getParent(0).getName(), path));
                diff.put("ContentLocation", (Object)this.createContentLocation(entr, path));
                diffs.put((Object)diff);
            }
            tw.release();
            return diffs;
        }
        return null;
    }

    private JSONArray toJSON(Map<String, Ref> revTags) throws JSONException, URISyntaxException, CoreException, IOException {
        JSONArray children = new JSONArray();
        for (Map.Entry<String, Ref> revTag : revTags.entrySet()) {
            Tag tag = new Tag(this.cloneLocation, this.db, revTag.getValue());
            children.put((Object)tag.toJSON());
        }
        return children;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return BaseToCommitConverter.getCommitLocation(this.cloneLocation, this.revCommit.getName(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2);
    }

    private Map<String, Ref> getTagsForCommit() throws MissingObjectException, IOException {
        HashMap<String, Ref> tags = new HashMap<String, Ref>();
        for (Map.Entry tag : this.db.getTags().entrySet()) {
            Ref ref = this.db.peel((Ref)tag.getValue());
            ObjectId refId = ref.getPeeledObjectId();
            if (refId == null) {
                refId = ref.getObjectId();
            }
            if (!AnyObjectId.equals((AnyObjectId)refId, (AnyObjectId)this.revCommit)) continue;
            tags.put((String)tag.getKey(), (Ref)tag.getValue());
        }
        return tags;
    }

    private URI createDiffLocation(String toRefId, String fromRefId, String path) throws URISyntaxException {
        String diffPath = "/gitapi/diff/";
        if (fromRefId != null) {
            diffPath = String.valueOf(diffPath) + fromRefId + "..";
        }
        diffPath = String.valueOf(diffPath) + toRefId + "/";
        if (path == null) {
            diffPath = String.valueOf(diffPath) + new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        } else if (this.isRoot) {
            diffPath = String.valueOf(diffPath) + new Path(this.cloneLocation.getPath()).removeFirstSegments(2).append(path);
        } else {
            Path p = new Path(this.cloneLocation.getPath());
            diffPath = String.valueOf(diffPath) + p.removeLastSegments(p.segmentCount() - 4).removeFirstSegments(2).append(path);
        }
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getAuthority(), diffPath, null, null);
    }

    private URI createContentLocation(DiffEntry entr, String path) throws URISyntaxException {
        Path p = new Path(this.cloneLocation.getPath());
        IPath result = path == null ? p.removeFirstSegments(2) : (this.isRoot ? p.removeFirstSegments(2).append(path) : p.removeLastSegments(p.segmentCount() - 4).removeFirstSegments(2).append(path));
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), result.makeAbsolute().toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
    }

    private JSONArray parentsToJSON(RevCommit[] revCommits) throws JSONException, IOException, URISyntaxException {
        JSONArray parents = new JSONArray();
        RevCommit[] revCommitArray = revCommits;
        int n = revCommits.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit revCommit = revCommitArray[n2];
            JSONObject parent = new JSONObject();
            parent.put("Name", (Object)revCommit.getName());
            parent.put("Location", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, revCommit.getName(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2));
            parents.put((Object)parent);
            ++n2;
        }
        return parents;
    }
}

