/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.UserAdminActivator;

public class UserEmailUtil {
    private static UserEmailUtil util = null;
    private static final String EMAIL_CONFIRMATION_FILE = "/emails/EmailConfirmation.txt";
    private static final String EMAIL_CONFIRMATION_RESET_PASS_FILE = "/emails/EmailConfirmationPasswordReset.txt";
    private static final String EMAIL_PASSWORD_RESET = "/emails/PasswordReset.txt";
    private static final String EMAIL_URL_LINK = "<URL>";
    private static final String EMAIL_USER_LINK = "<USER>";
    private static final String EMAIL_PASSWORD_LINK = "<PASSWORD>";
    private Properties properties = System.getProperties();
    private EmailContent confirmationEmail;
    private EmailContent confirmationResetPassEmail;
    private EmailContent passwordResetEmail;

    public UserEmailUtil() {
        this.properties.put("mail.smtp.starttls.enable", "true");
        if (PreferenceHelper.getString((String)"mail.smtp.host", null) != null) {
            this.properties.put("mail.smtp.host", PreferenceHelper.getString((String)"mail.smtp.host", null));
        }
        if (PreferenceHelper.getString((String)"mail.smtp.port", null) != null) {
            this.properties.put("mail.smtp.port", PreferenceHelper.getString((String)"mail.smtp.port", null));
        }
        if (PreferenceHelper.getString((String)"mail.smtp.user", null) != null) {
            this.properties.put("mail.smtp.user", PreferenceHelper.getString((String)"mail.smtp.user", null));
        }
        if (PreferenceHelper.getString((String)"mail.smtp.password", null) != null) {
            this.properties.put("mail.smtp.password", PreferenceHelper.getString((String)"mail.smtp.password", null));
        }
        this.properties.put("mail.smtp.auth", PreferenceHelper.getString((String)"mail.smtp.auth", (String)"false"));
    }

    public static UserEmailUtil getUtil() {
        if (util == null) {
            util = new UserEmailUtil();
        }
        return util;
    }

    public boolean isEmailConfigured() {
        return PreferenceHelper.getString((String)"mail.from", null) != null;
    }

    private void sendEmail(String subject, String messageText, String emailAddress) throws URISyntaxException, IOException, MessagingException {
        Session session = Session.getInstance((Properties)this.properties, null);
        InternetAddress from = new InternetAddress(PreferenceHelper.getString((String)"mail.from", (String)"OrionAdmin"));
        InternetAddress to = new InternetAddress(emailAddress);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)from);
        message.addRecipient(Message.RecipientType.TO, (Address)to);
        message.setSubject(subject);
        message.setText(messageText);
        Transport transport = session.getTransport("smtp");
        transport.connect(this.properties.getProperty("mail.smtp.host", null), this.properties.getProperty("mail.smtp.user", null), this.properties.getProperty("mail.smtp.password", null));
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public void sendEmailConfirmation(URI baseURI, User user) throws URISyntaxException, IOException, MessagingException {
        if (this.confirmationEmail == null) {
            this.confirmationEmail = new EmailContent(EMAIL_CONFIRMATION_FILE);
        }
        String confirmURL = baseURI.toURL().toString();
        confirmURL = String.valueOf(confirmURL) + "/" + user.getUid();
        confirmURL = String.valueOf(confirmURL) + "?confirmationId=" + user.getConfirmationId();
        this.sendEmail(this.confirmationEmail.getTitle(), this.confirmationEmail.getContent().replaceAll(EMAIL_USER_LINK, user.getLogin()).replaceAll(EMAIL_URL_LINK, confirmURL), user.getEmail());
    }

    public void sendResetPasswordConfirmation(URI baseURI, User user) throws URISyntaxException, IOException, MessagingException {
        if (this.confirmationResetPassEmail == null) {
            this.confirmationResetPassEmail = new EmailContent(EMAIL_CONFIRMATION_RESET_PASS_FILE);
        }
        String confirmURL = baseURI.toURL().toString();
        confirmURL = String.valueOf(confirmURL) + "/" + user.getUid();
        confirmURL = String.valueOf(confirmURL) + "?passwordResetId=" + user.getProperty("passwordResetId");
        this.sendEmail(this.confirmationResetPassEmail.getTitle(), this.confirmationResetPassEmail.getContent().replaceAll(EMAIL_URL_LINK, confirmURL).replaceAll(EMAIL_USER_LINK, user.getLogin()), user.getEmail());
    }

    public void setPasswordResetEmail(User user) throws URISyntaxException, IOException, MessagingException {
        if (this.passwordResetEmail == null) {
            this.passwordResetEmail = new EmailContent(EMAIL_PASSWORD_RESET);
        }
        this.sendEmail(this.passwordResetEmail.getTitle(), this.passwordResetEmail.getContent().replaceAll(EMAIL_USER_LINK, user.getLogin()).replaceAll(EMAIL_PASSWORD_LINK, user.getPassword()), user.getEmail());
    }

    private class EmailContent {
        private String title;
        private String content;

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public EmailContent(String fileName) throws URISyntaxException, IOException {
            URL entry = UserAdminActivator.getDefault().getBundleContext().getBundle().getEntry(fileName);
            if (entry == null) {
                throw new IOException("File not found: " + fileName);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(entry.openStream()));
            String line = null;
            try {
                this.title = reader.readLine();
                StringBuilder stringBuilder = new StringBuilder();
                String ls = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                }
                this.content = stringBuilder.toString();
            }
            finally {
                reader.close();
            }
        }
    }
}

