/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.formopenid.FormOpenIdAuthenticationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.openid.core.OpenIdException;
import org.eclipse.orion.server.openid.core.OpenIdHelper;
import org.eclipse.orion.server.openid.core.OpendIdProviderDescription;
import org.eclipse.orion.server.openid.core.OpenidConsumer;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageOpenidsServlet
extends HttpServlet {
    private static final long serialVersionUID = 5478748783512325610L;
    private FormOpenIdAuthenticationService authenticationService;
    private OpenidConsumer consumer;

    public ManageOpenidsServlet(FormOpenIdAuthenticationService formOpenIdAuthenticationService) {
        this.authenticationService = formOpenIdAuthenticationService;
    }

    private String getConfiguredOpenIds() {
        return (String)(this.authenticationService.getDefaultAuthenticationProperties() == null ? null : this.authenticationService.getDefaultAuthenticationProperties().get("openids"));
    }

    private static void writeOpenIdError(String error, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("redirect") == null) {
            resp.setContentType("text/html; charset=UTF-8");
            PrintWriter out = resp.getWriter();
            out.println("<html><head></head>");
            out.print("<body onload=\"window.opener.handleOpenIDResponse((window.location+'').split('?')[1],'");
            out.print(error);
            out.println("');window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
            return;
        }
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println("<html><head></head>");
        String url = req.getParameter("redirect");
        url = url.replaceAll("/&error(\\=[^&]*)?(?=&|$)|^error(\\=[^&]*)?(&|$)/", "");
        out.print("<body onload=\"window.location.replace('");
        out.print(url.toString());
        if (url.contains("?")) {
            out.print("&error=");
        } else {
            out.print("?error=");
        }
        out.print(new String(Base64.encode((byte[])error.getBytes())));
        out.println("');\">");
        out.println("</body>");
        out.println("</html>");
    }

    private List<OpendIdProviderDescription> getSupportedOpenids(HttpServletRequest req) {
        List openidProviders;
        String customOpenids;
        String string = customOpenids = req.getAttribute("openids") == null ? this.getConfiguredOpenIds() : (String)req.getAttribute("openids");
        if (customOpenids == null || customOpenids.trim().length() == 0) {
            openidProviders = OpenIdHelper.getDefaultOpenIdProviders();
        } else {
            try {
                openidProviders = OpenIdHelper.getSupportedOpenIdProviders((String)customOpenids);
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", "Cannot load openid list, JSON format expected", (Throwable)e));
                openidProviders = OpenIdHelper.getDefaultOpenIdProviders();
            }
        }
        return openidProviders;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        try {
            if (pathInfo.startsWith("/openid")) {
                String openid = req.getParameter("openid");
                if (openid != null) {
                    this.consumer = OpenIdHelper.redirectToOpenIdProvider((HttpServletRequest)req, (HttpServletResponse)response, (OpenidConsumer)this.consumer);
                    return;
                }
                String op_return = req.getParameter("op_return");
                if (op_return != null) {
                    OpenIdHelper.handleOpenIdReturn((HttpServletRequest)req, (HttpServletResponse)response, (OpenidConsumer)this.consumer);
                    return;
                }
            }
        }
        catch (OpenIdException e) {
            ManageOpenidsServlet.writeOpenIdError(e.getMessage(), req, response);
            return;
        }
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<!DOCTYPE html>");
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        writer.println("<script type=\"text/javascript\"");
        writer.println("src=\"../org.dojotoolkit/dojo/dojo.js\"></script>");
        writer.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"../mixloginstatic/css/manageOpenids.css\" />");
        writer.println("<script type=\"text/javascript\" src=\"../mixloginstatic/js/manageOpenids.js\"></script>");
        writer.println("</head>");
        writer.println("<body>");
        writer.println("<div id=\"newOpenId\"><h2 style=\"margin-top: 10px; margin-bottom: 10px; float: left; margin-right: 5px;\" id=\"addExternalAccount\">Add external account: <h2>");
        for (OpendIdProviderDescription provider : this.getSupportedOpenids(req)) {
            writer.print(provider.toJsImage().replaceAll("\\\\'", "'"));
        }
        writer.println("</div>");
        writer.println("<div id=\"openidList\"></div>");
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }
}

