/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenIdUserDecorator
implements IWebResourceDecorator {
    private boolean decorate = false;

    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        if (!this.decorate) {
            return;
        }
        if (!"/users".equals(request.getServletPath())) {
            return;
        }
        try {
            this.addPluginLinks(request, resource, representation);
            JSONArray children = representation.optJSONArray("users");
            if (children != null) {
                int i = 0;
                while (i < children.length()) {
                    JSONObject child = children.getJSONObject(i);
                    this.addPluginLinks(request, resource, child);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addPluginLinks(HttpServletRequest request, URI resource, JSONObject representation) throws URISyntaxException, JSONException {
        JSONArray plugins = representation.optJSONArray("Plugins");
        if (plugins != null) {
            JSONObject plugin = new JSONObject();
            URI result = new URI(resource.getScheme(), resource.getUserInfo(), resource.getHost(), resource.getPort(), String.valueOf(request.getContextPath()) + "/mixloginstatic/userProfilePlugin.html", null, null);
            plugin.put("Url", (Object)result);
            plugins.put((Object)plugin);
        }
    }

    public void setDecorate(boolean decorate) {
        this.decorate = decorate;
    }
}

