/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReader;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.users.OrionScope;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationService {
    private static final String PREFIX_EXPORT = "/xfer/export/";
    private static final String PREFIX_IMPORT = "/xfer/import/";
    public static final int POST = 1;
    public static final int PUT = 2;
    public static final int GET = 4;
    public static final int DELETE = 8;
    private static final int CURRENT_VERSION = 2;

    private static int getMethod(String methodName) {
        if (methodName.equals("POST")) {
            return 1;
        }
        if (methodName.equals("PUT")) {
            return 2;
        }
        if (methodName.equals("GET")) {
            return 4;
        }
        if (methodName.equals("DELETE")) {
            return 8;
        }
        return 0;
    }

    public static void addUserRight(String name, String uri) throws CoreException {
        try {
            IEclipsePreferences users = new OrionScope().getNode("Users");
            IEclipsePreferences result = (IEclipsePreferences)users.node(name);
            JSONArray userRightArray = AuthorizationReader.getAuthorizationData(result);
            JSONObject userRight = new JSONObject();
            userRight.put("Uri", (Object)uri);
            userRight.put("Method", 15);
            int i = 0;
            while (i < userRightArray.length()) {
                if (userRight.toString().equals(userRightArray.get(i).toString())) {
                    return;
                }
                ++i;
            }
            userRightArray.put((Object)userRight);
            AuthorizationService.saveRights(result, userRightArray);
        }
        catch (Exception e) {
            String msg = "Error persisting user rights";
            throw new CoreException((IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
        }
    }

    public static void removeUserRight(String name, String uri) throws CoreException {
        try {
            IEclipsePreferences users = new OrionScope().getNode("Users");
            IEclipsePreferences result = (IEclipsePreferences)users.node(name);
            JSONArray userRightArray = AuthorizationReader.getAuthorizationData(result);
            int i = 0;
            while (i < userRightArray.length()) {
                if (uri.equals(((JSONObject)userRightArray.get(i)).get("Uri"))) {
                    userRightArray.remove(i);
                }
                ++i;
            }
            AuthorizationService.saveRights(result, userRightArray);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new ServerStatus(4, 500, "Error persisting user rights", (Throwable)e));
        }
    }

    private static void saveRights(IEclipsePreferences result, JSONArray userRightArray) throws BackingStoreException {
        result.put("UserRights", userRightArray.toString());
        result.putInt("UserRightsVersion", 2);
        result.flush();
    }

    private static List<String> getRights(String name) {
        IEclipsePreferences users = new OrionScope().getNode("Users");
        IEclipsePreferences result = (IEclipsePreferences)users.node(name);
        try {
            JSONArray userRightArray = AuthorizationReader.getAuthorizationData(result);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < userRightArray.length()) {
                list.add(((JSONObject)userRightArray.get(i)).getString("Uri"));
                ++i;
            }
            return list;
        }
        catch (JSONException jSONException) {
            return Collections.emptyList();
        }
    }

    public static List<String> findUserWithRights(String rightToFind) {
        IEclipsePreferences users = new OrionScope().getNode("Users");
        ArrayList<String> matches = new ArrayList<String>();
        try {
            String[] usernames;
            String[] stringArray = usernames = users.childrenNames();
            int n = usernames.length;
            int n2 = 0;
            while (n2 < n) {
                String user = stringArray[n2];
                for (String right : AuthorizationService.getRights(user)) {
                    if (!rightToFind.startsWith(right)) continue;
                    matches.add(user);
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
        return matches;
    }

    public static boolean checkRights(String userName, String uri, String method) throws JSONException {
        if (uri.equals("/workspace") && !"anonymous".equals(userName)) {
            return true;
        }
        if (uri.startsWith("/site") && !"anonymous".equals(userName)) {
            return true;
        }
        if (uri.equals("/users/" + userName) && !"anonymous".equals(userName)) {
            return true;
        }
        if (uri.startsWith("/task")) {
            return true;
        }
        if (uri.startsWith(PREFIX_EXPORT) && uri.endsWith(".zip")) {
            uri = "/file/" + uri.substring(13, uri.length() - 4) + '/';
        } else if (uri.startsWith(PREFIX_IMPORT) && !(uri = "/file/" + uri.substring(PREFIX_IMPORT.length())).endsWith("/")) {
            uri = String.valueOf(uri) + '/';
        }
        String projectWorldReadable = PreferenceHelper.getString((String)"orion.file.anonymous.read", (String)"false");
        int methodMask = AuthorizationService.getMethod(method);
        if (methodMask == 4 && uri.startsWith("/file/") && "true".equalsIgnoreCase(projectWorldReadable)) {
            return !"/file/".equals(uri) && !uri.startsWith("/file/.metadata/");
        }
        IEclipsePreferences users = new OrionScope().getNode("Users");
        JSONArray userRightArray = AuthorizationReader.getAuthorizationData((IEclipsePreferences)users.node(userName));
        int i = 0;
        while (i < userRightArray.length()) {
            JSONObject userRight = (JSONObject)userRightArray.get(i);
            String uriToMatch = uri.toLowerCase(Locale.ENGLISH);
            String patternToMatch = userRight.getString("Uri").toLowerCase(Locale.ENGLISH);
            int methodToMatch = userRight.getInt("Method");
            if (AuthorizationService.wildCardMatch(uriToMatch, patternToMatch) && (methodMask & methodToMatch) == methodMask) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean wildCardMatch(String text, String pattern) {
        String[] cards = pattern.split("\\*");
        if (!pattern.startsWith("*") && !text.startsWith(cards[0])) {
            return false;
        }
        if (!pattern.endsWith("*") && !text.endsWith(cards[cards.length - 1])) {
            return false;
        }
        String[] stringArray = cards;
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            String card = stringArray[n2];
            int idex = text.indexOf(card);
            if (idex == -1) {
                return false;
            }
            text = text.substring(idex + card.length());
            ++n2;
        }
        return true;
    }
}

