/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revwalk.RevFlag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlotRenderer<TLane extends PlotLane, TColor> {
    private static final int LANE_WIDTH = 14;
    private static final int LINE_WIDTH = 2;
    private static final int LEFT_PAD = 2;

    protected void paintCommit(PlotCommit<TLane> commit, int h) {
        int dotSize = this.computeDotSize(h);
        TLane myLane = commit.getLane();
        int myLaneX = this.laneC((PlotLane)myLane);
        TColor myColor = this.laneColor(myLane);
        int maxCenter = 0;
        for (PlotLane passingLane : commit.passingLanes) {
            int cx = this.laneC(passingLane);
            TColor c = this.laneColor(passingLane);
            this.drawLine(c, cx, 0, cx, h, 2);
            maxCenter = Math.max(maxCenter, cx);
        }
        int nParent = commit.getParentCount();
        for (int i = 0; i < nParent; ++i) {
            PlotCommit p = (PlotCommit)commit.getParent(i);
            Object pLane = p.getLane();
            if (pLane == null) continue;
            TColor pColor = this.laneColor(pLane);
            int cx = this.laneC((PlotLane)pLane);
            if (Math.abs(myLaneX - cx) > 14) {
                int ix;
                if (myLaneX < cx) {
                    ix = cx - 7;
                    this.drawLine(pColor, myLaneX, h / 2, ix, h / 2, 2);
                    this.drawLine(pColor, ix, h / 2, cx, h, 2);
                } else {
                    ix = cx + 7;
                    this.drawLine(pColor, myLaneX, h / 2, ix, h / 2, 2);
                    this.drawLine(pColor, ix, h / 2, cx, h, 2);
                }
            } else {
                this.drawLine(pColor, myLaneX, h / 2, cx, h, 2);
            }
            maxCenter = Math.max(maxCenter, cx);
        }
        int dotX = myLaneX - dotSize / 2 - 1;
        int dotY = (h - dotSize) / 2;
        if (commit.getChildCount() > 0) {
            this.drawLine(myColor, myLaneX, 0, myLaneX, dotY, 2);
        }
        if (commit.has(RevFlag.UNINTERESTING)) {
            this.drawBoundaryDot(dotX, dotY, dotSize, dotSize);
        } else {
            this.drawCommitDot(dotX, dotY, dotSize, dotSize);
        }
        int textx = Math.max(maxCenter + 7, dotX + dotSize) + 8;
        int n = commit.refs.length;
        for (int i = 0; i < n; ++i) {
            textx += this.drawLabel(textx + dotSize, h / 2, commit.refs[i]);
        }
        String msg = commit.getShortMessage();
        this.drawText(msg, textx + dotSize + n * 2, h / 2);
    }

    protected abstract int drawLabel(int var1, int var2, Ref var3);

    private int computeDotSize(int h) {
        int d = (int)((float)Math.min(h, 14) * 0.5f);
        d += d & 1;
        return d;
    }

    protected abstract TColor laneColor(TLane var1);

    protected abstract void drawLine(TColor var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void drawCommitDot(int var1, int var2, int var3, int var4);

    protected abstract void drawBoundaryDot(int var1, int var2, int var3, int var4);

    protected abstract void drawText(String var1, int var2, int var3);

    private int laneX(PlotLane myLane) {
        int p = myLane != null ? myLane.getPosition() : 0;
        return 2 + 14 * p;
    }

    private int laneC(PlotLane myLane) {
        return this.laneX(myLane) + 7;
    }
}

