/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    int jniRef;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int HOT = 32;
    static final int MOVED = 64;
    static final int RESIZED = 128;
    static final int EXPANDING = 256;
    static final int IGNORE_WHEEL = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int THEME_BACKGROUND = 2048;
    static final int LAYOUT_NEEDED = 4096;
    static final int LAYOUT_CHANGED = 8192;
    static final int LAYOUT_CHILD = 16384;
    static final int RELEASED = 32768;
    static final int DISPOSE_SENT = 65536;
    static final int FOREIGN_HANDLE = 131072;
    static final int DRAG_DETECT = 262144;
    static final int RESIZING = 524288;
    static final int WEBKIT_EVENTS_FIX = 524288;
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";
    static final int SKIN_NEEDED = 0x100000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
        this.reskinWidget();
    }

    int accessibleHandle() {
        return 0;
    }

    int accessibilityActionDescription(int id2, int sel, int arg0) {
        return this.callSuperObject(id2, sel, arg0);
    }

    int accessibilityActionNames(int id2, int sel) {
        return this.callSuperObject(id2, sel);
    }

    int accessibilityAttributeNames(int id2, int sel) {
        return this.callSuperObject(id2, sel);
    }

    int accessibilityAttributeValue(int id2, int sel, int arg0) {
        return this.callSuperObject(id2, sel, arg0);
    }

    int accessibilityAttributeValue_forParameter(int id2, int sel, int arg0, int arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    int accessibilityFocusedUIElement(int id2, int sel) {
        return this.callSuperObject(id2, sel);
    }

    int accessibilityHitTest(int id2, int sel, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, point);
    }

    boolean accessibilityIsAttributeSettable(int id2, int sel, int arg0) {
        return this.callSuperBoolean(id2, sel, arg0);
    }

    boolean accessibilityIsIgnored(int id2, int sel) {
        return this.callSuperBoolean(id2, sel);
    }

    int accessibilityParameterizedAttributeNames(int id2, int sel) {
        return this.callSuperObject(id2, sel);
    }

    void accessibilityPerformAction(int id2, int sel, int arg0) {
        this.callSuper(id2, sel, arg0);
    }

    void accessibilitySetValue_forAttribute(int id2, int sel, int arg0, int arg1) {
        this.callSuper(id2, sel, arg0, arg1);
    }

    String getClipboardText() {
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            return "";
        }
        NSString string = pasteboard.stringForType(OS.NSStringPboardType);
        return string != null ? string.getString() : null;
    }

    void setClipRegion(NSView view) {
    }

    int attributedSubstringFromRange(int id2, int sel, int range) {
        return 0;
    }

    void callSuper(int id2, int sel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel);
    }

    void callSuper(int id2, int sel, int arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    void callSuper(int id2, int sel, NSRect arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    void callSuper(int id2, int sel, int arg0, int arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    void callSuper(int id2, int sel, NSRect arg0, int arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    int callSuper(int id2, int sel, int arg0, NSRect arg1, int arg2) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1, arg2);
    }

    boolean callSuperBoolean(int id2, int sel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel) != 0;
    }

    boolean canBecomeKeyWindow(int id2, int sel) {
        return this.callSuperBoolean(id2, sel);
    }

    void cancelOperation(int id2, int sel, int arg0) {
    }

    NSSize cellSize(int id2, int sel) {
        NSSize result = new NSSize();
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper_stret(result, super_struct, sel);
        return result;
    }

    NSSize cellSizeForBounds(int id2, int sel, NSRect cellFrame) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSSize result = new NSSize();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, cellFrame);
        return result;
    }

    boolean callSuperBoolean(int id2, int sel, int arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0) != 0;
    }

    boolean callSuperBoolean(int id2, int sel, NSRange range, int arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(super_struct, sel, range, arg1);
    }

    int callSuperObject(int id2, int sel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel);
    }

    int callSuperObject(int id2, int sel, int arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    int callSuperObject(int id2, int sel, int arg0, int arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    NSRect callSuperRect(int id2, int sel, int arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSRect result = new NSRect();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, arg0);
        return result;
    }

    boolean canDragRowsWithIndexes_atPoint(int id2, int sel, int rowIndexes, NSPoint mouseDownPoint) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(super_struct, sel, rowIndexes, mouseDownPoint);
    }

    int characterIndexForPoint(int id2, int sel, int point) {
        return Integer.MAX_VALUE;
    }

    int columnAtPoint(int id2, int sel, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, point);
    }

    boolean acceptsFirstMouse(int id2, int sel, int theEvent) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, theEvent) != 0;
    }

    boolean acceptsFirstResponder(int id2, int sel) {
        return this.callSuperBoolean(id2, sel);
    }

    boolean becomeFirstResponder(int id2, int sel) {
        return this.callSuperBoolean(id2, sel);
    }

    void becomeKeyWindow(int id2, int sel) {
        this.callSuper(id2, sel);
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if ((this.state & 0x100000) != 0x100000) {
            this.state |= 0x100000;
            this.display.addSkinnableWidget(this);
        }
    }

    boolean resignFirstResponder(int id2, int sel) {
        return this.callSuperBoolean(id2, sel);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(eventType, listener);
    }

    void _addListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    boolean canBecomeKeyView(int id2, int sel) {
        return true;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void clearDeferFlushing(int id2, int sel) {
    }

    boolean textView_clickOnLink_atIndex(int id2, int sel, int textView, int link, int charIndex) {
        return true;
    }

    void collapseItem_collapseChildren(int id2, int sel, int item, boolean children) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, item, children);
    }

    void copyToClipboard(char[] buffer) {
        if (buffer.length == 0) {
            return;
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            return;
        }
        pasteboard.declareTypes(NSArray.arrayWithObject(OS.NSStringPboardType), null);
        pasteboard.setString(NSString.stringWithCharacters(buffer, buffer.length), OS.NSStringPboardType);
    }

    void createHandle() {
    }

    void createJNIRef() {
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            this.error(2);
        }
    }

    void createWidget() {
        this.createJNIRef();
        this.createHandle();
        this.setOrientation();
        this.register();
    }

    void comboBoxSelectionDidChange(int id2, int sel, int notification) {
    }

    void comboBoxWillDismiss(int id2, int sel, int notification) {
    }

    void comboBoxWillPopUp(int id2, int sel, int notification) {
    }

    void deregister() {
    }

    void destroyJNIRef() {
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0;
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void deselectAll(int id2, int sel, int sender) {
        this.callSuper(id2, sel, sender);
    }

    void deselectRow(int id2, int sel, int index) {
        this.callSuper(id2, sel, index);
    }

    void doCommandBySelector(int id2, int sel, int aSelector) {
        this.callSuper(id2, sel, aSelector);
    }

    boolean dragSelectionWithEvent(int id2, int sel, int arg0, int arg1, int arg2) {
        return false;
    }

    void drawBackground(int id2, NSGraphicsContext context, NSRect rect) {
    }

    void drawBackgroundInClipRect(int id2, int sel, NSRect rect) {
        this.callSuper(id2, sel, rect);
    }

    void drawImageWithFrameInView(int id2, int sel, int image, NSRect rect, int view) {
        this.callSuper(id2, sel, image, rect, view);
    }

    NSRect drawTitleWithFrameInView(int id2, int sel, int title, NSRect rect, int view) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSRect result = new NSRect();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, title, rect, view);
        return result;
    }

    void drawInteriorWithFrame_inView(int id2, int sel, NSRect cellFrame, int view) {
        this.callSuper(id2, sel, cellFrame, view);
    }

    void drawLabelInRect(int id2, int sel, boolean shouldTruncateLabel, NSRect rect) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, shouldTruncateLabel, rect);
    }

    void drawViewBackgroundInRect(int id2, int sel, NSRect rect) {
        this.callSuper(id2, sel, rect);
    }

    void drawWithExpansionFrame_inView(int id2, int sel, NSRect cellFrame, int view) {
        this.callSuper(id2, sel, cellFrame, view);
    }

    void drawRect(int id2, int sel, NSRect rect) {
        if (!this.isDrawing()) {
            return;
        }
        Display display = this.display;
        NSView view = new NSView(id2);
        display.isPainting.addObject(view);
        NSGraphicsContext context = NSGraphicsContext.currentContext();
        context.saveGraphicsState();
        this.setClipRegion(view);
        this.drawBackground(id2, context, rect);
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, rect);
        if (!this.isDisposed()) {
            this.drawWidget(id2, context, rect);
        }
        context.restoreGraphicsState();
        display.isPainting.removeObjectIdenticalTo(view);
    }

    void _drawThemeProgressArea(int id2, int sel, int arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    void drawWidget(int id2, NSGraphicsContext context, NSRect rect) {
    }

    int imageView() {
        return 0;
    }

    void redrawWidget(NSView view, boolean children) {
        view.setNeedsDisplay(true);
    }

    void redrawWidget(NSView view, int x, int y, int width, int height, boolean children) {
        NSRect rect = new NSRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        view.setNeedsDisplayInRect(rect);
    }

    void error(int code) {
        SWT.error(code);
    }

    void expandItem_expandChildren(int id2, int sel, int item, boolean children) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, item, children);
    }

    NSRect expansionFrameWithFrame_inView(int id2, int sel, NSRect cellRect, int view) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSRect result = new NSRect();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, cellRect, view);
        return result;
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    NSRect firstRectForCharacterRange(int id2, int sel, int range) {
        return new NSRect();
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            --j;
        }
        return j;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(IS_ACTIVE)) {
            return new Boolean(this.isActive());
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    boolean getDrawing() {
        return true;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hasMarkedText(int id2, int sel) {
        return false;
    }

    NSRect headerRectOfColumn(int id2, int sel, int column) {
        return this.callSuperRect(id2, sel, column);
    }

    void helpRequested(int id2, int sel, int theEvent) {
    }

    void highlightSelectionInClipRect(int id2, int sel, int rect) {
    }

    int hitTest(int id2, int sel, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, point);
    }

    int hitTestForEvent(int id2, int sel, int event, NSRect rect, int controlView) {
        return 0;
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    int image(int id2, int sel) {
        return 0;
    }

    NSRect imageRectForBounds(int id2, int sel, NSRect cellFrame) {
        return new NSRect();
    }

    boolean insertText(int id2, int sel, int string) {
        this.callSuper(id2, sel, string);
        return true;
    }

    boolean isActive() {
        return true;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isDrawing() {
        return true;
    }

    boolean isFlipped(int id2, int sel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel) != 0;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isOpaque(int id2, int sel) {
        return false;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void flagsChanged(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void keyDown(int id2, int sel, int theEvent) {
        this.superKeyDown(id2, sel, theEvent);
    }

    void keyUp(int id2, int sel, int theEvent) {
        this.superKeyUp(id2, sel, theEvent);
    }

    void mouseDown(int id2, int sel, int theEvent) {
        this.mouseDownSuper(id2, sel, theEvent);
    }

    boolean mouseDownCanMoveWindow(int id2, int sel) {
        return this.callSuperBoolean(id2, sel);
    }

    void mouseDownSuper(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseUp(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseMoved(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseDragged(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseEntered(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseExited(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void cursorUpdate(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void rightMouseDown(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void rightMouseUp(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void rightMouseDragged(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void otherMouseDown(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void otherMouseUp(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void otherMouseDragged(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    boolean shouldDelayWindowOrderingForEvent(int id2, int sel, int theEvent) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, theEvent) != 0;
    }

    boolean menuHasKeyEquivalent_forEvent_target_action(int id2, int sel, int menu, int event, int target, int action) {
        return true;
    }

    int menuForEvent(int id2, int sel, int theEvent) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, theEvent);
    }

    void menuNeedsUpdate(int id2, int sel, int menu) {
    }

    boolean makeFirstResponder(int id2, int sel, int notification) {
        return this.callSuperBoolean(id2, sel, notification);
    }

    NSRange markedRange(int id2, int sel) {
        return new NSRange();
    }

    void menu_willHighlightItem(int id2, int sel, int menu, int item) {
    }

    void menuDidClose(int id2, int sel, int menu) {
    }

    void menuWillOpen(int id2, int sel, int menu) {
    }

    void noResponderFor(int id2, int sel, int selector) {
        this.callSuper(id2, sel, selector);
    }

    int numberOfRowsInTableView(int id2, int sel, int aTableView) {
        return 0;
    }

    int outlineView_child_ofItem(int id2, int sel, int outlineView, int index, int item) {
        return 0;
    }

    void outlineView_didClickTableColumn(int id2, int sel, int outlineView, int tableColumn) {
    }

    int outlineView_objectValueForTableColumn_byItem(int id2, int sel, int outlineView, int tableColumn, int item) {
        return 0;
    }

    boolean outlineView_isItemExpandable(int id2, int sel, int outlineView, int item) {
        return false;
    }

    int outlineView_numberOfChildrenOfItem(int id2, int sel, int outlineView, int item) {
        return 0;
    }

    boolean outlineView_shouldExpandItem_item(int id2, int sel, int outlineView, int item) {
        return true;
    }

    boolean outlineView_shouldReorderColumn_toColumn(int id2, int sel, int aTableView, int columnIndex, int newColumnIndex) {
        return true;
    }

    boolean outlineView_shouldEditTableColumn_row(int id2, int sel, int aTableView, int aTableColumn, int item) {
        return false;
    }

    boolean outlineView_shouldTrackCell_forTableColumn_item(int id2, int sel, int table, int cell, int tableColumn, int item) {
        return true;
    }

    void outlineView_willDisplayCell_forTableColumn_item(int id2, int sel, int outlineView, int cell, int tableColumn, int item) {
    }

    void outlineViewColumnDidMove(int id2, int sel, int aNotification) {
    }

    void outlineViewColumnDidResize(int id2, int sel, int aNotification) {
    }

    void outlineViewSelectionDidChange(int id2, int sel, int notification) {
    }

    void outlineViewSelectionIsChanging(int id2, int sel, int notification) {
    }

    void outlineView_setObjectValue_forTableColumn_byItem(int id2, int sel, int outlineView, int object, int tableColumn, int item) {
    }

    boolean outlineView_writeItems_toPasteboard(int id2, int sel, int arg0, int arg1, int arg2) {
        return false;
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void pageDown(int id2, int sel, int sender) {
        this.callSuper(id2, sel, sender);
    }

    void pageUp(int id2, int sel, int sender) {
        this.callSuper(id2, sel, sender);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void reflectScrolledClipView(int id2, int sel, int aClipView) {
        this.callSuper(id2, sel, aClipView);
    }

    void register() {
    }

    void release(boolean destroy) {
        if ((this.state & 0x10000) == 0) {
            this.state |= 0x10000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x8000) == 0) {
            this.state |= 0x8000;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
        this.destroyJNIRef();
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        if (this.display.tooltipTarget == this) {
            this.display.tooltipTarget = null;
        }
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void scrollClipViewToPoint(int id2, int sel, int clipView, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, clipView, point);
    }

    void selectRowIndexes_byExtendingSelection(int id2, int sel, int indexes, boolean extend) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, indexes, extend);
    }

    void scrollWheel(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    NSRange selectedRange(int id2, int sel) {
        return new NSRange();
    }

    int nextValidKeyView(int id2, int sel) {
        return this.callSuperObject(id2, sel);
    }

    int previousValidKeyView(int id2, int sel) {
        return this.callSuperObject(id2, sel);
    }

    void sendDoubleSelection() {
    }

    void sendEvent(Event event) {
        this.display.sendEvent(this.eventTable, event);
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        if ((this.state & 0x80000) != 0) {
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, type, nsEvent)) {
            return true;
        }
        return this.sendKeyEvent(type, event);
    }

    boolean sendKeyEvent(int type, Event event) {
        this.sendEvent(type, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendHorizontalSelection() {
    }

    void sendCancelSelection() {
    }

    void sendSearchSelection() {
    }

    void sendSelection() {
    }

    void sendSelectionEvent(int eventType) {
        this.sendSelectionEvent(eventType, null, false);
    }

    void sendSelectionEvent(int eventType, Event event, boolean send) {
        NSEvent nsEvent;
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        if ((nsEvent = NSApplication.sharedApplication().currentEvent()) != null) {
            this.setInputState(event, nsEvent, 0);
        }
        this.sendEvent(eventType, event, send);
    }

    void sendVerticalSelection() {
    }

    public void setData(Object data) {
        this.checkWidget();
        if (WEBKIT_EVENTS_FIX_KEY.equals(data)) {
            this.state |= 0x80000;
            return;
        }
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (GLCONTEXT_KEY.equals(key)) {
            this.setOpenGLContext(value);
            return;
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    void setOpenGLContext(Object value) {
    }

    void setOrientation() {
    }

    void setFrameOrigin(int id2, int sel, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, point);
    }

    void setFrameSize(int id2, int sel, NSSize size) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, size);
    }

    void setImage(int id2, int sel, int arg0) {
    }

    boolean setInputState(Event event, NSEvent nsEvent, int type) {
        int state;
        if (nsEvent == null && (nsEvent = NSApplication.sharedApplication().currentEvent()) == null) {
            return true;
        }
        int modifierFlags = nsEvent.modifierFlags();
        if ((modifierFlags & 0x80000) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((modifierFlags & 0x20000) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((modifierFlags & 0x40000) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((modifierFlags & 0x100000) != 0) {
            event.stateMask |= 0x400000;
        }
        if (((state = OS.GetCurrentEventButtonState()) & 1) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((state & 2) != 0) {
            event.stateMask |= 0x200000;
        }
        if ((state & 4) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((state & 8) != 0) {
            event.stateMask |= 0x800000;
        }
        if ((state & 0x10) != 0) {
            event.stateMask |= 0x2000000;
        }
        switch (type) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode == 262144) {
                    event.stateMask &= 0xFFFBFFFF;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask &= 0xFFBFFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode == 262144) {
                    event.stateMask |= 0x40000;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask |= 0x400000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int type, NSEvent nsEvent) {
        boolean isNull = false;
        short keyCode = nsEvent.keyCode();
        event.keyCode = Display.translateKey(keyCode);
        switch (event.keyCode) {
            case 10: {
                event.keyCode = 0x1000050;
                event.character = (char)13;
                break;
            }
            case 8: {
                event.character = (char)8;
                break;
            }
            case 13: {
                event.character = (char)13;
                break;
            }
            case 127: {
                event.character = (char)127;
                break;
            }
            case 27: {
                event.character = (char)27;
                break;
            }
            case 9: {
                event.character = (char)9;
                break;
            }
            default: {
                NSString chars;
                if ((event.keyCode == 0 || 16777258 <= event.keyCode && event.keyCode <= 0x1000050) && (chars = nsEvent.characters()) != null && chars.length() > 0) {
                    event.character = (char)chars.characterAtIndex(0);
                }
                if (event.keyCode != 0) break;
                int uchrPtr = 0;
                int currentKbd = OS.TISCopyCurrentKeyboardInputSource();
                int uchrCFData = OS.TISGetInputSourceProperty(currentKbd, OS.kTISPropertyUnicodeKeyLayoutData());
                if (uchrCFData != 0) {
                    uchrPtr = OS.CFDataGetBytePtr(uchrCFData);
                    if (uchrPtr != 0 && OS.CFDataGetLength(uchrCFData) > 0) {
                        int cgEvent = nsEvent.CGEvent();
                        long keyboardType = OS.CGEventGetIntegerValueField(cgEvent, 10);
                        int maxStringLength = 256;
                        char[] output = new char[maxStringLength];
                        int[] actualStringLength = new int[1];
                        int[] deadKeyState = new int[1];
                        OS.UCKeyTranslate(uchrPtr, keyCode, (short)(event.type != 1 ? 1 : 0), 0, (int)keyboardType, 0, deadKeyState, maxStringLength, actualStringLength, output);
                        event.keyCode = actualStringLength[0] < 1 ? 0 : output[0];
                    }
                } else {
                    NSString unmodifiedChars = nsEvent.charactersIgnoringModifiers().lowercaseString();
                    if (unmodifiedChars.length() > 0) {
                        event.keyCode = (char)unmodifiedChars.characterAtIndex(0);
                    }
                }
                if (currentKbd == 0) break;
                OS.CFRelease(currentKbd);
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        this.setLocationMask(event, nsEvent);
        this.setInputState(event, nsEvent, type);
        return true;
    }

    void setLocationMask(Event event, NSEvent nsEvent) {
        switch (nsEvent.keyCode()) {
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                event.keyLocation = 16384;
                break;
            }
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                event.keyLocation = 131072;
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 76: 
            case 78: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                event.keyLocation = 2;
            }
        }
    }

    boolean setMarkedText_selectedRange(int id2, int sel, int string, int range) {
        return true;
    }

    void setNeedsDisplay(int id2, int sel, boolean flag) {
        if (flag && !this.isDrawing()) {
            return;
        }
        NSView view = new NSView(id2);
        if (flag && this.display.isPainting.containsObject(view)) {
            NSMutableArray needsDisplay = this.display.needsDisplay;
            if (needsDisplay == null) {
                needsDisplay = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplay = needsDisplay = needsDisplay.initWithCapacity(12);
            }
            needsDisplay.addObject(view);
            return;
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, flag);
    }

    void setNeedsDisplayInRect(int id2, int sel, int arg0) {
        if (!this.isDrawing()) {
            return;
        }
        NSRect rect = new NSRect();
        OS.memmove(rect, arg0, NSRect.sizeof);
        NSView view = new NSView(id2);
        if (this.display.isPainting.containsObject(view)) {
            NSMutableArray needsDisplayInRect = this.display.needsDisplayInRect;
            if (needsDisplayInRect == null) {
                needsDisplayInRect = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplayInRect = needsDisplayInRect = needsDisplayInRect.initWithCapacity(12);
            }
            needsDisplayInRect.addObject(view);
            needsDisplayInRect.addObject(NSValue.valueWithRect(rect));
            return;
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, rect);
    }

    void setObjectValue(int id2, int sel, int arg0) {
        this.callSuper(id2, sel, arg0);
    }

    void setShouldExpandItem(int id2, int sel, boolean shouldExpand) {
    }

    void setShouldScrollClipView(int id2, int sel, boolean shouldScroll) {
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        return false;
    }

    boolean shouldChangeTextInRange_replacementString(int id2, int sel, int arg0, int arg1) {
        return true;
    }

    NSSize sizeOfLabel(int id2, int sel, boolean shouldTruncateLabel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSSize result = new NSSize();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, shouldTruncateLabel);
        return result;
    }

    void superKeyDown(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void superKeyUp(int id2, int sel, int theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void tableViewColumnDidMove(int id2, int sel, int aNotification) {
    }

    void tableViewColumnDidResize(int id2, int sel, int aNotification) {
    }

    void tableViewSelectionDidChange(int id2, int sel, int aNotification) {
    }

    void tableViewSelectionIsChanging(int id2, int sel, int aNotification) {
    }

    void tableView_didClickTableColumn(int id2, int sel, int tableView, int tableColumn) {
    }

    int tableView_objectValueForTableColumn_row(int id2, int sel, int aTableView, int aTableColumn, int rowIndex) {
        return 0;
    }

    boolean tableView_shouldSelectRow(int id2, int sel, int tableView, int index) {
        return true;
    }

    void tableView_setObjectValue_forTableColumn_row(int id2, int sel, int aTableView, int anObject, int aTableColumn, int rowIndex) {
    }

    boolean tableView_shouldReorderColumn_toColumn(int id2, int sel, int aTableView, int columnIndex, int newColumnIndex) {
        return true;
    }

    boolean tableView_shouldEditTableColumn_row(int id2, int sel, int aTableView, int aTableColumn, int rowIndex) {
        return false;
    }

    boolean tableView_shouldTrackCell_forTableColumn_row(int id2, int sel, int table, int cell, int tableColumn, int rowIndex) {
        return true;
    }

    void tableView_willDisplayCell_forTableColumn_row(int id2, int sel, int aTableView, int aCell, int aTableColumn, int rowIndex) {
    }

    void textViewDidChangeSelection(int id2, int sel, int aNotification) {
    }

    void textDidChange(int id2, int sel, int aNotification) {
        this.callSuper(id2, sel, aNotification);
    }

    void textDidEndEditing(int id2, int sel, int aNotification) {
        this.callSuper(id2, sel, aNotification);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(int id2, int sel, int aTextView, int oldSelectedCharRange, int newSelectedCharRange) {
        return new NSRange();
    }

    NSRect titleRectForBounds(int id2, int sel, NSRect cellFrame) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSRect result = new NSRect();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, cellFrame);
        return result;
    }

    int toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(int id2, int sel, int toolbar, int itemID, boolean flag) {
        return 0;
    }

    int toolbarAllowedItemIdentifiers(int id2, int sel, int toolbar) {
        return 0;
    }

    int toolbarDefaultItemIdentifiers(int id2, int sel, int toolbar) {
        return 0;
    }

    int toolbarSelectableItemIdentifiers(int id2, int sel, int toolbar) {
        return 0;
    }

    String tooltipText() {
        return null;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    void touchesBeganWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void touchesCancelledWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void touchesEndedWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void touchesMovedWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void beginGestureWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void endGestureWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void magnifyWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void rotateWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void swipeWithEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    void resetCursorRects(int id2, int sel) {
        this.callSuper(id2, sel);
    }

    void updateTrackingAreas(int id2, int sel) {
        this.callSuper(id2, sel);
    }

    int validAttributesForMarkedText(int id2, int sel) {
        return 0;
    }

    void tabView_didSelectTabViewItem(int id2, int sel, int tabView, int tabViewItem) {
    }

    void tabView_willSelectTabViewItem(int id2, int sel, int tabView, int tabViewItem) {
    }

    boolean tableView_writeRowsWithIndexes_toPasteboard(int id2, int sel, int arg0, int arg1, int arg2) {
        return false;
    }

    boolean validateMenuItem(int id2, int sel, int menuItem) {
        return true;
    }

    int view_stringForToolTip_point_userData(int id2, int sel, int view, int tag, int point, int userData) {
        return 0;
    }

    void viewDidMoveToWindow(int id2, int sel) {
    }

    void viewWillMoveToWindow(int id2, int sel, int arg0) {
    }

    void windowDidMove(int id2, int sel, int notification) {
    }

    void windowDidResize(int id2, int sel, int notification) {
    }

    void windowDidResignKey(int id2, int sel, int notification) {
    }

    void windowDidBecomeKey(int id2, int sel, int notification) {
    }

    void windowDidMiniturize(int id2, int sel, int notification) {
    }

    void windowDidDeminiturize(int id2, int sel, int notification) {
    }

    void windowDidEnterFullScreen(int id2, int sel, int notification) {
    }

    void windowDidExitFullScreen(int id2, int sel, int notification) {
    }

    void windowSendEvent(int id2, int sel, int event) {
        this.callSuper(id2, sel, event);
    }

    boolean windowShouldClose(int id2, int sel, int window) {
        return false;
    }

    void windowWillClose(int id2, int sel, int notification) {
    }

    int nextState(int id2, int sel) {
        return this.callSuperObject(id2, sel);
    }

    void updateOpenGLContext(int id2, int sel, int notification) {
    }

    boolean shouldDrawInsertionPoint(int id2, int sel) {
        return this.callSuperBoolean(id2, sel);
    }

    boolean readSelectionFromPasteboard(int id2, int sel, int pasteboard) {
        return false;
    }

    int validRequestorForSendType(int id2, int sel, int sendType, int returnType) {
        return this.callSuperObject(id2, sel, sendType, returnType);
    }

    boolean writeSelectionToPasteboard(int id2, int sel, int pasteboard, int types) {
        return false;
    }
}

