/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.authentication.formopenid.FormOpenIdAuthenticationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.openid.core.OpenIdException;
import org.eclipse.orion.server.openid.core.OpenIdHelper;
import org.eclipse.orion.server.openid.core.OpenidConsumer;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class FormOpenIdLoginServlet
extends OrionServlet {
    private FormOpenIdAuthenticationService authenticationService;
    private OpenidConsumer consumer;
    private static final long serialVersionUID = 1L;

    public FormOpenIdLoginServlet(FormOpenIdAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/form")) {
            block22: {
                try {
                    if (FormAuthHelper.performAuthentication((HttpServletRequest)req, (HttpServletResponse)resp)) {
                        String versionString = req.getHeader("Orion-Version");
                        Version version = versionString == null ? null : new Version(versionString);
                        String xRequestedWith = req.getHeader("X-Requested-With");
                        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
                            if (req.getParameter("redirect") != null && !req.getParameter("redirect").equals("")) {
                                resp.sendRedirect(req.getParameter("redirect"));
                            }
                        } else {
                            resp.setStatus(200);
                            PrintWriter writer = resp.getWriter();
                            String uid = (String)req.getSession().getAttribute("user");
                            try {
                                JSONObject userJson = FormAuthHelper.getUserJson((String)uid, (String)req.getContextPath());
                                writer.print(userJson);
                                resp.setContentType("application/json");
                            }
                            catch (JSONException jSONException) {}
                        }
                        resp.flushBuffer();
                        break block22;
                    }
                    this.displayError("Invalid user or password", req, resp);
                }
                catch (UnsupportedUserStoreException e) {
                    LogHelper.log((Throwable)e);
                    resp.sendError(404, e.getMessage());
                }
            }
            return;
        }
        if (pathInfo.startsWith("/openid")) {
            String openid = req.getParameter("openid");
            if (openid != null) {
                try {
                    this.consumer = OpenIdHelper.redirectToOpenIdProvider((HttpServletRequest)req, (HttpServletResponse)resp, (OpenidConsumer)this.consumer);
                }
                catch (OpenIdException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", "An error occurred redirecting to OpenId provider", (Throwable)e));
                    this.displayError(e.getMessage(), req, resp);
                }
                return;
            }
            String op_return = req.getParameter("op_return");
            if (op_return != null) {
                try {
                    OpenIdHelper.handleOpenIdReturnAndLogin((HttpServletRequest)req, (HttpServletResponse)resp, (OpenidConsumer)this.consumer);
                }
                catch (OpenIdException e) {
                    this.displayError(e.getMessage(), req, resp);
                }
                return;
            }
        }
        if (pathInfo.startsWith("/canaddusers")) {
            JSONObject jsonResp = new JSONObject();
            try {
                jsonResp.put("CanAddUsers", FormAuthHelper.canAddUsers());
                jsonResp.put("RegistrationURI", (Object)FormAuthHelper.registrationURI());
            }
            catch (JSONException jSONException) {}
            resp.getWriter().print(jsonResp);
            resp.setContentType("application/json");
            return;
        }
        String user = this.authenticationService.getAuthenticatedUser(req, resp, this.authenticationService.getDefaultAuthenticationProperties());
        if (user != null) {
            resp.setStatus(200);
            try {
                resp.getWriter().print(FormAuthHelper.getUserJson((String)user, (String)req.getContextPath()));
            }
            catch (JSONException e) {
                this.handleException(resp, "An error occured when creating JSON object for logged in user", (Exception)((Object)e));
            }
            return;
        }
    }

    private void displayError(String error, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            String url = "/mixloginstatic/LoginWindow.html";
            if (req.getParameter("redirect") != null) {
                url = String.valueOf(url) + "?redirect=" + req.getParameter("redirect");
            }
            if (error == null) {
                error = "Invalid login";
            }
            url = String.valueOf(url) + (url.contains("?") ? "&" : "?");
            url = String.valueOf(url) + "error=" + new String(Base64.encode((byte[])error.getBytes()));
            resp.sendRedirect(url);
        } else {
            resp.setStatus(401);
            PrintWriter writer = resp.getWriter();
            JSONObject jsonError = new JSONObject();
            try {
                jsonError.put("error", (Object)error);
                writer.print(jsonError);
                resp.setContentType("application/json");
            }
            catch (JSONException jSONException) {}
        }
        resp.flushBuffer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/openid") && (req.getParameter("openid") != null || req.getParameter("op_return") != null)) {
            this.doPost(req, resp);
            return;
        }
        RequestDispatcher rd = req.getRequestDispatcher("/mixlogin/login");
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }
}

