/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.core.resources.JSONSerializer;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.Serializer;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Clone")
public class Clone {
    public static final String RESOURCE = "clone";
    public static final String TYPE = "Clone";
    private String id;
    private URI contentLocation;
    private URIish uriish;
    private String name;
    private FileRepository db;
    private URI baseLocation;
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    protected Serializer<JSONObject> jsonSerializer;

    public Clone() {
        Property[] defaultProperties = new Property[]{new Property("Name"), new Property("Location"), new Property("ContentLocation"), new Property("RemoteLocation"), new Property("ConfigLocation"), new Property("HeadLocation"), new Property("CommitLocation"), new Property("BranchLocation"), new Property("TagLocation"), new Property("IndexLocation"), new Property("StatusLocation"), new Property("DiffLocation"), new Property("GitUrl")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.jsonSerializer = new JSONSerializer();
    }

    public void setId(String id) {
        this.id = id;
    }

    private String getId() {
        return this.id;
    }

    public void setContentLocation(URI contentURI) {
        this.contentLocation = contentURI;
    }

    public URI getContentLocation() {
        return this.contentLocation;
    }

    public void setUrl(URIish gitURI) {
        this.uriish = gitURI;
    }

    public String getUrl() {
        return this.uriish.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    @PropertyDescription(name="Name")
    public String getName() {
        return this.name;
    }

    private FileRepository getRepository() throws IOException {
        if (this.db == null) {
            this.db = new FileRepository(new File(new File(this.getContentLocation()), ".git"));
        }
        return this.db;
    }

    public void setBaseLocation(URI baseLocation) {
        this.baseLocation = baseLocation;
    }

    public JSONObject toJSON() throws URISyntaxException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Location")
    private URI getLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append(RESOURCE).append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="ContentLocation")
    private URI getContentLocation2() throws URISyntaxException {
        IPath np = new Path("file").append(this.getId()).makeAbsolute();
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="RemoteLocation")
    private URI getRemoteLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("remote").append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="ConfigLocation")
    private URI getConfigLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("config").append(RESOURCE).append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="HeadLocation")
    private URI getHeadLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("commit").append("HEAD").append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="CommitLocation")
    private URI getCommitLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("commit").append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="BranchLocation")
    private URI getBranchLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("branch").append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="TagLocation")
    private URI getTagLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("tag").append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="IndexLocation")
    private URI getIndexLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("index").append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="StatusLocation")
    private URI getStatusLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("status").append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="DiffLocation")
    private URI getDiffLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("diff").append("Default").append("file").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="GitUrl")
    private String getCloneUrl() {
        try {
            FileBasedConfig config = this.getRepository().getConfig();
            String remoteUri = config.getString("remote", "origin", "url");
            if (remoteUri != null) {
                return remoteUri;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private URI createUriWithPath(IPath path) throws URISyntaxException {
        return new URI(this.baseLocation.getScheme(), this.baseLocation.getUserInfo(), this.baseLocation.getHost(), this.baseLocation.getPort(), path.toString(), this.baseLocation.getQuery(), this.baseLocation.getFragment());
    }

    public JSONObject toJSON(Map.Entry<IPath, File> entry, URI baseLocation) throws JSONException, IOException, URISyntaxException {
        this.id = entry.getKey().toString();
        this.name = entry.getKey().segmentCount() == 1 ? WebProject.fromId((String)entry.getKey().segment(0)).getName() : entry.getKey().lastSegment();
        this.db = new FileRepository(entry.getValue());
        this.baseLocation = baseLocation;
        return this.toJSON();
    }
}

