/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSInputManager;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSet;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTouch;
import org.eclipse.swt.internal.cocoa.NSTrackingArea;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Touch;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public NSView view;
    Composite parent;
    String toolTipText;
    Object layoutData;
    int drawCount;
    Menu menu;
    double[] foreground;
    double[] background;
    Image backgroundImage;
    Font font;
    Cursor cursor;
    Region region;
    NSBezierPath regionPath;
    long visibleRgn;
    Accessible accessible;
    boolean touchEnabled;
    static final int CLIPPING = 1024;
    static final int VISIBLE_REGION = 4096;
    static final int DEFAULT_DRAG_HYSTERESIS = 5;
    static final double SYNTHETIC_BOLD = -2.5;
    static final double SYNTHETIC_ITALIC = 0.2;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    boolean acceptsFirstMouse(long id2, long sel, long theEvent) {
        Shell shell = this.getShell();
        if ((shell.style & 0x4000) != 0) {
            return true;
        }
        return super.acceptsFirstMouse(id2, sel, theEvent);
    }

    long accessibleHandle() {
        long returnValue = this.view.id;
        if (this.view instanceof NSControl && ((NSControl)this.view).cell() != null) {
            returnValue = ((NSControl)this.view).cell().id;
        }
        return returnValue;
    }

    long accessibilityActionDescription(long id2, long sel, long arg0) {
        NSString actionName;
        id returnValue;
        if (id2 == this.accessibleHandle() && this.accessible != null && (returnValue = this.accessible.internal_accessibilityActionDescription(actionName = new NSString(arg0), -1)) != null) {
            return returnValue.id;
        }
        return super.accessibilityActionDescription(id2, sel, arg0);
    }

    long accessibilityActionNames(long id2, long sel) {
        long returnValue = super.accessibilityActionNames(id2, sel);
        if (this.handleIsAccessible(id2)) {
            NSArray baseArray;
            if (this.accessible != null && (baseArray = this.accessible.internal_accessibilityActionNames(-1)) != null) {
                returnValue = baseArray.id;
            }
            if (this.hooks(35) || this.menu != null && !this.menu.isDisposed()) {
                baseArray = new NSArray(returnValue);
                NSMutableArray ourNames = NSMutableArray.arrayWithCapacity(baseArray.count() + 1L);
                ourNames.addObjectsFromArray(baseArray);
                ourNames.addObject(OS.NSAccessibilityShowMenuAction);
                returnValue = ourNames.id;
            }
        }
        return returnValue;
    }

    long accessibilityAttributeNames(long id2, long sel) {
        long returnValue = 0L;
        if (this.handleIsAccessible(id2) && this.accessible != null) {
            NSArray value = this.accessible.internal_accessibilityAttributeNames(-1);
            long l = returnValue = value != null ? value.id : 0L;
            if (returnValue == 0L) {
                returnValue = super.accessibilityAttributeNames(id2, sel);
            }
            returnValue = this.accessible.internal_addRelationAttributes(returnValue);
        }
        if (returnValue == 0L) {
            returnValue = super.accessibilityAttributeNames(id2, sel);
        }
        return returnValue;
    }

    boolean handleIsAccessible(long id2) {
        return id2 == this.accessibleHandle();
    }

    long accessibilityParameterizedAttributeNames(long id2, long sel) {
        NSArray returnValue;
        if (this.handleIsAccessible(id2) && this.accessible != null && (returnValue = this.accessible.internal_accessibilityParameterizedAttributeNames(-1)) != null) {
            return returnValue.id;
        }
        return super.accessibilityParameterizedAttributeNames(id2, sel);
    }

    void accessibilityPerformAction(long id2, long sel, long arg0) {
        NSString action;
        if (this.handleIsAccessible(id2) && this.accessible != null && this.accessible.internal_accessibilityPerformAction(action = new NSString(arg0), -1)) {
            return;
        }
        super.accessibilityPerformAction(id2, sel, arg0);
    }

    long accessibilityFocusedUIElement(long id2, long sel) {
        id returnValue = null;
        if (this.handleIsAccessible(id2) && this.accessible != null) {
            returnValue = this.accessible.internal_accessibilityFocusedUIElement(-1);
        }
        if (returnValue == null) {
            return super.accessibilityFocusedUIElement(id2, sel);
        }
        return returnValue.id;
    }

    long accessibilityHitTest(long id2, long sel, NSPoint point) {
        id returnValue = null;
        if (this.handleIsAccessible(id2) && this.accessible != null) {
            returnValue = this.accessible.internal_accessibilityHitTest(point, -1);
        }
        if (returnValue == null) {
            return super.accessibilityHitTest(id2, sel, point);
        }
        return returnValue.id;
    }

    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        NSString attribute = new NSString(arg0);
        long returnValue = 0L;
        id returnObject = null;
        if (this.handleIsAccessible(id2) && this.accessible != null) {
            returnObject = this.accessible.internal_accessibilityAttributeValue(attribute, -1);
        }
        if (returnObject == null) {
            returnValue = super.accessibilityAttributeValue(id2, sel, arg0);
            if (returnObject == null && attribute.isEqualToString(OS.NSAccessibilityHelpAttribute) && this.toolTipText != null) {
                returnValue = NSString.stringWith((String)this.toolTipText).id;
            }
        } else {
            returnValue = returnObject.id;
        }
        return returnValue;
    }

    long accessibilityAttributeValue_forParameter(long id2, long sel, long arg0, long arg1) {
        NSString attribute = new NSString(arg0);
        id returnValue = null;
        if (this.handleIsAccessible(id2) && this.accessible != null) {
            id parameter = new id(arg1);
            returnValue = this.accessible.internal_accessibilityAttributeValue_forParameter(attribute, parameter, -1);
        }
        if (returnValue == null) {
            return super.accessibilityAttributeValue_forParameter(id2, sel, arg0, arg1);
        }
        return returnValue.id;
    }

    boolean accessibilityIsAttributeSettable(long id2, long sel, long arg0) {
        boolean returnValue = false;
        if (this.handleIsAccessible(id2) && this.accessible != null) {
            NSString attribute = new NSString(arg0);
            returnValue = this.accessible.internal_accessibilityIsAttributeSettable(attribute, -1);
        }
        if (!returnValue) {
            returnValue = super.accessibilityIsAttributeSettable(id2, sel, arg0);
        }
        return returnValue;
    }

    void accessibilitySetValue_forAttribute(long id2, long sel, long arg0, long arg1) {
        if (this.handleIsAccessible(id2) && this.accessible != null) {
            id value = new id(arg0);
            NSString attribute = new NSString(arg1);
            this.accessible.internal_accessibilitySetValue_forAttribute(value, attribute, -1);
        } else {
            super.accessibilitySetValue_forAttribute(id2, sel, arg0, arg1);
        }
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(37, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    void addTraits(NSMutableDictionary dict, Font font) {
        if ((font.extraTraits & 2) != 0) {
            dict.setObject(NSNumber.numberWithDouble(-2.5), OS.NSStrokeWidthAttributeName);
        }
        if ((font.extraTraits & 1) != 0) {
            dict.setObject(NSNumber.numberWithDouble(0.2), OS.NSObliquenessAttributeName);
        }
    }

    public void addTouchListener(TouchListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    boolean becomeFirstResponder(long id2, long sel) {
        if ((this.state & 8) != 0) {
            return false;
        }
        return super.becomeFirstResponder(id2, sel);
    }

    void beginGestureWithEvent(long id2, long sel, long event) {
        if (!this.gestureEvent(id2, event, 2)) {
            return;
        }
        super.beginGestureWithEvent(id2, sel, event);
    }

    void endGestureWithEvent(long id2, long sel, long event) {
        if (!this.gestureEvent(id2, event, 4)) {
            return;
        }
        super.endGestureWithEvent(id2, sel, event);
    }

    void calculateVisibleRegion(NSView view, long visibleRgn, boolean clipChildren) {
        long tempRgn = OS.NewRgn();
        if (!view.isHiddenOrHasHiddenAncestor() && this.isDrawing()) {
            long childRgn = OS.NewRgn();
            NSWindow window = view.window();
            NSView contentView = window.contentView();
            NSView frameView = contentView.superview();
            NSRect bounds = contentView.visibleRect();
            bounds = contentView.convertRect_toView_(bounds, view);
            short[] rect = new short[4];
            OS.SetRect(rect, (short)bounds.x, (short)bounds.y, (short)(bounds.x + bounds.width), (short)(bounds.y + bounds.height));
            OS.RectRgn(visibleRgn, rect);
            NSView tempView = view;
            NSView lastControl = null;
            while (tempView.id != frameView.id) {
                bounds = tempView.visibleRect();
                bounds = tempView.convertRect_toView_(bounds, view);
                OS.SetRect(rect, (short)bounds.x, (short)bounds.y, (short)(bounds.x + bounds.width), (short)(bounds.y + bounds.height));
                OS.RectRgn(tempRgn, rect);
                OS.SectRgn(tempRgn, visibleRgn, visibleRgn);
                if (OS.EmptyRgn(visibleRgn)) break;
                if (clipChildren || tempView.id != view.id) {
                    NSArray subviews = tempView.subviews();
                    long count = subviews.count();
                    int i = 0;
                    while ((long)i < count) {
                        NSView child = new NSView(subviews.objectAtIndex(count - (long)i - 1L));
                        if (lastControl != null && child.id == lastControl.id) break;
                        if (!child.isHidden()) {
                            bounds = child.visibleRect();
                            bounds = child.convertRect_toView_(bounds, view);
                            OS.SetRect(rect, (short)bounds.x, (short)bounds.y, (short)(bounds.x + bounds.width), (short)(bounds.y + bounds.height));
                            OS.RectRgn(tempRgn, rect);
                            OS.UnionRgn(tempRgn, childRgn, childRgn);
                        }
                        ++i;
                    }
                }
                lastControl = tempView;
                tempView = tempView.superview();
            }
            OS.DiffRgn(visibleRgn, childRgn, visibleRgn);
            OS.DisposeRgn(childRgn);
        } else {
            OS.CopyRgn(tempRgn, visibleRgn);
        }
        OS.DisposeRgn(tempRgn);
    }

    void cancelOperation(long id2, long sel, long sender) {
        if (this.hasKeyboardFocus(id2)) {
            NSEvent nsEvent = NSApplication.sharedApplication().currentEvent();
            Shell s = this.getShell();
            s.keyInputHappened = false;
            boolean[] consume = new boolean[1];
            if (this.translateTraversal(nsEvent.keyCode(), nsEvent, consume)) {
                return;
            }
            if (this.isDisposed()) {
                return;
            }
            if (!this.sendKeyEvent(nsEvent, 1)) {
                return;
            }
        }
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0) {
                if (mode == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x800) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkToolTip(Widget target) {
        if (this.isVisible() && this.display.tooltipControl == this && (target == null || this.display.tooltipTarget == target)) {
            Shell shell = this.getShell();
            shell.sendToolTipEvent(false);
            shell.sendToolTipEvent(true);
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    NSView contentView() {
        return this.view;
    }

    NSAttributedString createString(String string, Font font, double[] foreground, int alignment, boolean wrap, boolean enabled, boolean mnemonics) {
        NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
        if (font == null) {
            font = this.font != null ? this.font : this.defaultFont();
        }
        dict.setObject(font.handle, OS.NSFontAttributeName);
        this.addTraits(dict, font);
        if (enabled) {
            if (foreground != null) {
                NSColor color = NSColor.colorWithDeviceRed(foreground[0], foreground[1], foreground[2], foreground[3]);
                dict.setObject(color, OS.NSForegroundColorAttributeName);
            }
        } else {
            dict.setObject(NSColor.disabledControlTextColor(), OS.NSForegroundColorAttributeName);
        }
        NSMutableParagraphStyle paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        paragraphStyle.setLineBreakMode(wrap ? 0 : 2);
        if (alignment != 0) {
            int align = 0;
            if ((alignment & 0x1000000) != 0) {
                align = 2;
            } else if ((alignment & 0x20000) != 0) {
                align = 1;
            }
            paragraphStyle.setAlignment(align);
        }
        if ((this.style & 0x4000000) != 0) {
            paragraphStyle.setBaseWritingDirection(1L);
        } else {
            paragraphStyle.setBaseWritingDirection(0L);
        }
        dict.setObject(paragraphStyle, OS.NSParagraphStyleAttributeName);
        paragraphStyle.release();
        int length = string.length();
        char[] chars = new char[length];
        string.getChars(0, chars.length, chars, 0);
        if (mnemonics) {
            length = this.fixMnemonic(chars);
        }
        NSString str = ((NSString)new NSString().alloc()).initWithCharacters(chars, length);
        NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(str, dict);
        str.release();
        dict.release();
        return attribStr;
    }

    void createWidget() {
        this.state |= 0x40000;
        this.checkOrientation(this.parent);
        super.createWidget();
        this.checkBackground();
        this.checkBuffered();
        this.setDefaultFont();
        this.setZOrder();
        this.setRelations();
        if ((this.state & 0x400) != 0) {
            this.setBackground();
        }
        this.display.clearPool();
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(22);
    }

    Font defaultFont() {
        if (this.display.smallFonts) {
            return this.display.getSystemFont();
        }
        return Font.cocoa_new(this.display, this.defaultNSFont());
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(21);
    }

    NSFont defaultNSFont() {
        return this.display.getSystemFont().handle;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
    }

    void destroyWidget() {
        NSView view = this.topView();
        view.removeFromSuperview();
        this.releaseHandle();
    }

    void doCommandBySelector(long id2, long sel, long selector) {
        if (this.hasKeyboardFocus(id2)) {
            if (this.imeInComposition()) {
                return;
            }
            Shell s = this.getShell();
            NSEvent nsEvent = NSApplication.sharedApplication().currentEvent();
            if (nsEvent != null && nsEvent.type() == 10L) {
                long modifiers = nsEvent.modifierFlags();
                if (!s.keyInputHappened || (modifiers & 0x100000L) != 0L) {
                    s.keyInputHappened = true;
                    boolean[] consume = new boolean[1];
                    if (this.translateTraversal(nsEvent.keyCode(), nsEvent, consume)) {
                        return;
                    }
                    if (this.isDisposed()) {
                        return;
                    }
                    if (!this.sendKeyEvent(nsEvent, 1)) {
                        return;
                    }
                    if (consume[0]) {
                        return;
                    }
                }
            }
            if ((this.state & 2) != 0) {
                return;
            }
        }
        super.doCommandBySelector(id2, sel, selector);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    boolean dragDetect(int button, int count, int stateMask, int x, int y) {
        if (button != 1 || count != 1) {
            return false;
        }
        if (!this.dragDetect(x, y, false, null)) {
            return false;
        }
        return this.sendDragEvent(button, stateMask, x, y);
    }

    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        NSApplication application = NSApplication.sharedApplication();
        boolean dragging = false;
        long eventType = 1L;
        double dragX = x;
        double dragY = y;
        NSEvent mouseUpEvent = null;
        NSMutableArray dragEvents = NSMutableArray.arrayWithCapacity(10L);
        NSDate timeout = NSDate.dateWithTimeIntervalSinceNow(0.3);
        while (eventType != 2L) {
            NSEvent event = application.nextEventMatchingMask(68L, timeout, OS.NSEventTrackingRunLoopMode, true);
            if (event == null) {
                dragging = true;
                break;
            }
            eventType = event.type();
            if (eventType == 6L) {
                dragEvents.addObject(event);
                NSPoint windowLoc = event.locationInWindow();
                NSPoint viewLoc = this.view.convertPoint_fromView_(windowLoc, null);
                if (!this.view.isFlipped()) {
                    viewLoc.y = this.view.bounds().height - viewLoc.y;
                }
                if (!(Math.abs(viewLoc.x - dragX) > 5.0) && !(Math.abs(viewLoc.y - dragY) > 5.0)) continue;
                dragging = true;
                break;
            }
            if (eventType != 2L) continue;
            mouseUpEvent = event;
        }
        if (mouseUpEvent != null) {
            application.postEvent(mouseUpEvent, true);
        }
        if (dragEvents.count() > 0L) {
            while (dragEvents.count() > 0L) {
                NSEvent currEvent = new NSEvent(dragEvents.objectAtIndex((long)(dragEvents.count() - 1L)).id);
                dragEvents.removeLastObject();
                application.postEvent(currEvent, true);
            }
        }
        return dragging;
    }

    boolean drawGripper(int x, int y, int width, int height, boolean vertical) {
        return false;
    }

    boolean drawsBackground() {
        return true;
    }

    void drawWidget(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.paintView().id) {
            return;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return;
        }
        GCData data = new GCData();
        data.paintRect = rect;
        GC gc = GC.cocoa_new(this, data);
        Event event = new Event();
        event.gc = gc;
        event.x = (int)rect.x;
        event.y = (int)rect.y;
        event.width = (int)rect.width;
        event.height = (int)rect.height;
        this.sendEvent(9, event);
        event.gc = null;
        gc.dispose();
    }

    void enableWidget(boolean enabled) {
        if (this.view instanceof NSControl) {
            ((NSControl)this.view).setEnabled(enabled);
        }
        this.updateCursorRects(this.isEnabled());
    }

    boolean equals(double[] color1, double[] color2) {
        if (color1 == color2) {
            return true;
        }
        if (color1 == null) {
            return color2 == null;
        }
        if (color2 == null) {
            return color1 == null;
        }
        int i = 0;
        while (i < color1.length) {
            if (color1[i] != color2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    NSView eventView() {
        return this.view;
    }

    void fillBackground(NSView view, NSGraphicsContext context, NSRect rect, int imgHeight) {
        this.fillBackground(view, context, rect, imgHeight, null, 0, 0);
    }

    void fillBackground(NSView view, NSGraphicsContext context, NSRect rect, int imgHeight, NSView gcView, int tx, int ty) {
        double alpha;
        Image image;
        if (!this.drawsBackground()) {
            return;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((image = control.backgroundImage) != null && !image.isDisposed()) {
            context.saveGraphicsState();
            NSColor.colorWithPatternImage(image.handle).setFill();
            NSPoint phase = new NSPoint();
            NSView controlView = control.view;
            if (!controlView.isFlipped()) {
                phase.y = controlView.bounds().height;
            }
            if (imgHeight == -1) {
                NSView contentView = controlView.window().contentView();
                phase = controlView.convertPoint_toView_(phase, contentView);
                phase.y = contentView.bounds().height - phase.y;
            } else {
                phase = view.convertPoint_toView_(phase, controlView);
                phase.y += (double)(imgHeight - this.backgroundImage.getBounds().height);
            }
            if (gcView != null) {
                NSPoint pt = gcView.convertPoint_toView_(new NSPoint(), view);
                phase.x += pt.x;
                phase.y -= pt.y;
            }
            phase.x -= (double)tx;
            phase.y += (double)ty;
            context.setPatternPhase(phase);
            NSBezierPath.fillRect(rect);
            context.restoreGraphicsState();
            return;
        }
        double[] background = control.background;
        if (background == null) {
            if (this.isTransparent()) {
                return;
            }
            background = control.defaultBackground().handle;
            alpha = this.getThemeAlpha();
        } else {
            alpha = background[3];
        }
        context.saveGraphicsState();
        NSColor.colorWithDeviceRed(background[0], background[1], background[2], alpha).setFill();
        NSBezierPath.fillRect(rect);
        context.restoreGraphicsState();
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Control findBackgroundControl() {
        if (this.backgroundImage != null || this.background != null) {
            return this;
        }
        return !this.isTransparent() && (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    Widget findTooltip(NSPoint pt) {
        return this;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this, menus);
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        NSWindow window = this.view.window();
        if (!window.makeFirstResponder(null)) {
            window.endEditingFor(null);
        }
    }

    void flagsChanged(long id2, long sel, long theEvent) {
        if (this.hasKeyboardFocus(id2) && (this.state & 0x80000) == 0) {
            Shell s = this.getShell();
            s.keyInputHappened = false;
            int mask = 0;
            NSEvent nsEvent = new NSEvent(theEvent);
            long modifiers = nsEvent.modifierFlags();
            int keyCode = Display.translateKey(nsEvent.keyCode());
            switch (keyCode) {
                case 65536: {
                    mask = 524288;
                    break;
                }
                case 262144: {
                    mask = 262144;
                    break;
                }
                case 0x400000: {
                    mask = 0x100000;
                    break;
                }
                case 131072: {
                    mask = 131072;
                    break;
                }
                case 16777298: {
                    Event event = new Event();
                    event.keyCode = keyCode;
                    this.setInputState(event, nsEvent, 1);
                    this.sendKeyEvent(1, event);
                    this.setInputState(event, nsEvent, 2);
                    this.sendKeyEvent(2, event);
                }
            }
            if (mask != 0) {
                s.keyInputHappened = true;
                int type = ((long)mask & modifiers) != 0L ? 1 : 2;
                Event event = new Event();
                event.keyCode = keyCode;
                this.setLocationMask(event, nsEvent);
                this.setInputState(event, nsEvent, type);
                if (!this.sendKeyEvent(type, event)) {
                    return;
                }
            }
        }
        super.flagsChanged(id2, sel, theEvent);
    }

    NSView focusView() {
        return this.view;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.setSavedFocus(null);
        NSView focusView = this.focusView();
        if (!focusView.canBecomeKeyView()) {
            return false;
        }
        boolean result = this.forceFocus(focusView);
        if (this.isDisposed()) {
            return false;
        }
        shell.setSavedFocus(this);
        shell.bringToTop(false);
        if (this.isDisposed()) {
            return false;
        }
        return result;
    }

    boolean forceFocus(NSView focusView) {
        NSWindow window = this.view.window();
        if (window == null) {
            return false;
        }
        return window.makeFirstResponder(focusView);
    }

    boolean gestureEvent(long id2, long eventPtr, int detail) {
        if (!this.display.sendEvent) {
            return true;
        }
        this.display.sendEvent = false;
        if (this.touchEnabled) {
            return true;
        }
        if (!this.isEventView(id2)) {
            return true;
        }
        if (!this.hooks(48) && !this.filters(48)) {
            return true;
        }
        NSEvent nsEvent = new NSEvent(eventPtr);
        Event event = new Event();
        NSView view = this.eventView();
        NSPoint windowPoint = nsEvent.locationInWindow();
        NSPoint point = view.convertPoint_fromView_(windowPoint, null);
        if (!view.isFlipped()) {
            point.y = view.bounds().height - point.y;
        }
        event.x = (int)point.x;
        event.y = (int)point.y;
        this.setInputState(event, nsEvent, 48);
        event.detail = detail;
        if (detail == 2) {
            this.display.rotation = 0.0;
            this.display.magnification = 1.0;
            this.display.gestureActive = true;
        } else if (detail == 4) {
            this.display.gestureActive = false;
        }
        switch (detail) {
            case 16: {
                event.xDirection = (int)(-nsEvent.deltaX());
                event.yDirection = (int)(-nsEvent.deltaY());
                break;
            }
            case 8: {
                this.display.rotation += (double)nsEvent.rotation();
                event.rotation = this.display.rotation;
                break;
            }
            case 32: {
                this.display.magnification += nsEvent.magnification();
                event.magnification = this.display.magnification;
                break;
            }
            case 64: {
                if (!this.display.gestureActive) break;
                event.xDirection = (int)(-nsEvent.deltaX());
                event.yDirection = (int)(-nsEvent.deltaY());
                if (event.xDirection != 0 || event.yDirection != 0) break;
                return true;
            }
        }
        this.sendEvent(48, event);
        return event.doit;
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.getBackgroundColor();
    }

    Color getBackgroundColor() {
        return this.background != null ? Color.cocoa_new(this.display, this.background) : this.defaultBackground();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        NSRect rect = this.topView().frame();
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x40000) != 0;
    }

    boolean getDrawing() {
        return this.drawCount <= 0;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    public Color getForeground() {
        this.checkWidget();
        return this.getForegroundColor();
    }

    Color getForegroundColor() {
        return this.foreground != null ? Color.cocoa_new(this.display, this.foreground) : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        NSRect rect = this.topView().frame();
        return new Point((int)rect.x, (int)rect.y);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getMininumHeight() {
        return 0;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors.length == 1) {
            return monitors[0];
        }
        int index = -1;
        int value = -1;
        Rectangle bounds = this.getBounds();
        if (this != this.getShell()) {
            bounds = this.display.map((Control)this.parent, null, bounds);
        }
        int i = 0;
        while (i < monitors.length) {
            Rectangle rect = bounds.intersection(monitors[i].getBounds());
            int area = rect.width * rect.height;
            if (area > 0 && area > value) {
                index = i;
                value = area;
            }
            ++i;
        }
        if (index >= 0) {
            return monitors[index];
        }
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        int i2 = 0;
        while (i2 < monitors.length) {
            int x;
            Rectangle rect = monitors[i2].getBounds();
            int n = centerX < rect.x ? rect.x - centerX : (x = centerX > rect.x + rect.width ? centerX - rect.x - rect.width : 0);
            int y = centerY < rect.y ? rect.y - centerY : (centerY > rect.y + rect.height ? centerY - rect.y - rect.height : 0);
            int distance = x * x + y * y;
            if (index == -1 || distance < value) {
                index = i2;
                value = distance;
            }
            ++i2;
        }
        return monitors[index];
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    NSBezierPath getPath(Region region) {
        if (region == null) {
            return null;
        }
        return this.getPath(region.handle);
    }

    NSBezierPath getPath(long region) {
        Callback callback = new Callback(this, "regionToRects", 4);
        if (callback.getAddress() == 0L) {
            this.error(3);
        }
        NSBezierPath path = NSBezierPath.bezierPath();
        path.retain();
        OS.QDRegionToRects(region, 5, callback.getAddress(), path.id);
        callback.dispose();
        if (path.isEmpty()) {
            path.appendBezierPathWithRect(new NSRect());
        }
        return path;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        NSRect rect = this.topView().frame();
        return new Point((int)rect.width, (int)rect.height);
    }

    float getThemeAlpha() {
        return 1.0f * this.parent.getThemeAlpha();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return this.display.getTouchEnabled() && this.touchEnabled;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    long getVisibleRegion() {
        if (this.visibleRgn == 0L) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(this.view, this.visibleRgn, true);
        }
        long result = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, result);
        return result;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    boolean hasFocus() {
        return this.display.getFocusControl() == this;
    }

    boolean hasRegion() {
        return this.region != null || this.parent.hasRegion();
    }

    long hitTest(long id2, long sel, NSPoint point) {
        if ((this.state & 8) != 0) {
            return 0L;
        }
        if (!this.isActive()) {
            return 0L;
        }
        if (this.regionPath != null) {
            NSPoint pt;
            NSView rgnView = this.topView();
            if (!rgnView.isFlipped()) {
                rgnView = this.eventView();
            }
            if (!this.regionPath.containsPoint(pt = rgnView.convertPoint_fromView_(point, new NSView(id2).superview()))) {
                return 0L;
            }
        }
        return super.hitTest(id2, sel, point);
    }

    boolean imeInComposition() {
        return false;
    }

    boolean insertText(long id2, long sel, long string) {
        NSObject saver = new NSObject(string);
        saver.retain();
        try {
            if (this.hasKeyboardFocus(id2)) {
                long type;
                Shell s = this.getShell();
                NSEvent nsEvent = NSApplication.sharedApplication().currentEvent();
                if (nsEvent != null && ((type = nsEvent.type()) == 10L || type == 14L)) {
                    NSString str = new NSString(string);
                    if (str.isKindOfClass(OS.class_NSAttributedString)) {
                        str = new NSAttributedString(string).string();
                    }
                    int length = (int)str.length();
                    char[] buffer = new char[length];
                    str.getCharacters(buffer);
                    int i = 0;
                    while (i < buffer.length) {
                        s.keyInputHappened = true;
                        Event event = new Event();
                        if (i == 0 && type == 10L) {
                            this.setKeyState(event, 1, nsEvent);
                        }
                        event.character = buffer[i];
                        if (!this.sendKeyEvent(1, event)) {
                            return false;
                        }
                        ++i;
                    }
                }
                if ((this.state & 2) != 0) {
                    return true;
                }
            }
            boolean bl = super.insertText(id2, sel, string);
            return bl;
        }
        finally {
            saver.release();
        }
    }

    public long internal_new_GC(GCData data) {
        this.checkWidget();
        NSView view = this.paintView();
        long context = 0L;
        if (data != null && data.paintRect != null) {
            NSGraphicsContext graphicsContext = NSGraphicsContext.currentContext();
            context = graphicsContext.id;
            if (!view.isFlipped()) {
                data.state &= 0xFFFFEFFF;
            }
        } else {
            NSGraphicsContext flippedContext;
            NSWindow window = view.window();
            if (window.windowNumber() <= 0L) {
                double alpha = window.alphaValue();
                window.setAlphaValue(0.0);
                window.orderBack(null);
                window.orderOut(null);
                window.setAlphaValue(alpha);
            }
            NSGraphicsContext graphicsContext = NSGraphicsContext.graphicsContextWithWindow(window);
            graphicsContext = flippedContext = NSGraphicsContext.graphicsContextWithGraphicsPort(graphicsContext.graphicsPort(), true);
            context = graphicsContext.id;
            if (data != null) {
                data.flippedContext = flippedContext;
                data.state &= 0xFFFFEFFF;
                data.visibleRgn = this.getVisibleRegion();
                this.display.addContext(data);
            }
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            }
            data.device = this.display;
            data.thread = this.display.thread;
            data.view = view;
            data.view.retain();
            data.view.window().retain();
            data.foreground = this.getForegroundColor().handle;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            data.background = control.getBackgroundColor().handle;
            data.font = this.font != null ? this.font : this.defaultFont();
        }
        return context;
    }

    public void internal_dispose_GC(long hDC, GCData data) {
        this.checkWidget();
        long context = hDC;
        NSGraphicsContext graphicsContext = new NSGraphicsContext(context);
        this.display.removeContext(data);
        if (data != null) {
            if (data.paintRect == null) {
                graphicsContext.flushGraphics();
            }
            if (data.visibleRgn != 0L) {
                OS.DisposeRgn(data.visibleRgn);
            }
            data.visibleRgn = 0L;
            if (data.view != null) {
                data.view.window().release();
                data.view.release();
                data.view = null;
            }
        }
    }

    void invalidateChildrenVisibleRegion() {
    }

    void invalidateVisibleRegion() {
        int index = 0;
        Control[] siblings = this.parent._getChildren();
        while (index < siblings.length && siblings[index] != this) {
            ++index;
        }
        int i = index;
        while (i < siblings.length) {
            Control sibling = siblings[i];
            sibling.resetVisibleRegion();
            sibling.invalidateChildrenVisibleRegion();
            ++i;
        }
        this.parent.resetVisibleRegion();
    }

    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isEnabledCursor() {
        return this.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control focusControl = this.display.focusControl;
        if (focusControl != null && !focusControl.isDisposed()) {
            return this == focusControl;
        }
        return this.hasFocus();
    }

    boolean isObscured() {
        long visibleRgn = this.getVisibleRegion();
        long boundsRgn = OS.NewRgn();
        short[] rect = new short[4];
        NSRect bounds = this.view.visibleRect();
        OS.SetRect(rect, (short)bounds.x, (short)bounds.y, (short)(bounds.x + bounds.width), (short)(bounds.y + bounds.height));
        OS.RectRgn(boundsRgn, rect);
        OS.DiffRgn(boundsRgn, visibleRgn, boundsRgn);
        boolean obscured = !OS.EmptyRgn(boundsRgn);
        OS.DisposeRgn(boundsRgn);
        OS.DisposeRgn(visibleRgn);
        return obscured;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isResizing() {
        return (this.state & 0x80000) != 0 || this.parent.isResizing();
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, null)) & 0x60) != 0;
    }

    boolean isTransparent() {
        if (this.background != null) {
            return false;
        }
        return this.parent.isTransparent();
    }

    boolean isTrim(NSView view) {
        return false;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void keyDown(long id2, long sel, long theEvent) {
        if (this.hasKeyboardFocus(id2)) {
            boolean textInput;
            Shell s = this.getShell();
            s.keyInputHappened = false;
            boolean bl = textInput = OS.objc_msgSend(id2, OS.sel_conformsToProtocol_, OS.objc_getProtocol("NSTextInput")) != 0L;
            if (!textInput) {
                NSEvent nsEvent = new NSEvent(theEvent);
                boolean[] consume = new boolean[1];
                if (this.translateTraversal(nsEvent.keyCode(), nsEvent, consume)) {
                    return;
                }
                if (this.isDisposed()) {
                    return;
                }
                if (!this.sendKeyEvent(nsEvent, 1)) {
                    return;
                }
                if (consume[0]) {
                    return;
                }
            } else {
                super.keyDown(id2, sel, theEvent);
                if (this.imeInComposition()) {
                    return;
                }
                if (!s.keyInputHappened) {
                    NSEvent nsEvent = new NSEvent(theEvent);
                    boolean[] consume = new boolean[1];
                    if (this.translateTraversal(nsEvent.keyCode(), nsEvent, consume)) {
                        return;
                    }
                    if (this.isDisposed()) {
                        return;
                    }
                    if (!this.sendKeyEvent(nsEvent, 1)) {
                        return;
                    }
                    if (consume[0]) {
                        return;
                    }
                }
                return;
            }
        }
        super.keyDown(id2, sel, theEvent);
    }

    boolean hasKeyboardFocus(long inId) {
        return this.view.window().firstResponder().id == inId;
    }

    void keyUp(long id2, long sel, long theEvent) {
        NSEvent nsEvent;
        if (this.hasKeyboardFocus(id2) && !this.sendKeyEvent(nsEvent = new NSEvent(theEvent), 2)) {
            return;
        }
        super.keyUp(id2, sel, theEvent);
    }

    void magnifyWithEvent(long id2, long sel, long event) {
        if (!this.gestureEvent(id2, event, 32)) {
            return;
        }
        super.magnifyWithEvent(id2, sel, event);
    }

    void markLayout(boolean changed, boolean all) {
    }

    long menuForEvent(long id2, long sel, long theEvent) {
        if (!this.isEnabled()) {
            return 0L;
        }
        NSPoint pt = NSEvent.mouseLocation();
        pt.y = (int)(this.display.getPrimaryFrame().height - pt.y);
        int x = (int)pt.x;
        int y = (int)pt.y;
        Event event = new Event();
        event.x = x;
        event.y = y;
        NSEvent nsEvent = new NSEvent(theEvent);
        event.detail = nsEvent.buttonNumber() > 0L ? 0 : 1;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return 0L;
        }
        if (!event.doit) {
            return 0L;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (x != event.x || y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0L;
        }
        return super.menuForEvent(id2, sel, theEvent);
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    void scrollWheel(long id2, long sel, long theEvent) {
        boolean handled = false;
        if (id2 == this.view.id) {
            NSEvent nsEvent = new NSEvent(theEvent);
            if (!(!this.hooks(48) && !this.filters(48) || nsEvent.deltaY() == 0.0 && nsEvent.deltaX() == 0.0 || this.gestureEvent(id2, theEvent, 64))) {
                handled = true;
            }
            if (!handled) {
                if ((this.hooks(37) || this.filters(37)) && nsEvent.deltaY() != 0.0 && !this.sendMouseEvent(nsEvent, 37, true)) {
                    handled = true;
                }
                if ((this.hooks(38) || this.filters(38)) && nsEvent.deltaX() != 0.0 && !this.sendMouseEvent(nsEvent, 38, true)) {
                    handled = true;
                }
            }
        }
        if (!handled) {
            super.scrollWheel(id2, sel, theEvent);
        }
    }

    boolean isEventView(long id2) {
        return true;
    }

    boolean mouseEvent(long id2, long sel, long theEvent, int type) {
        if (!this.display.sendEvent) {
            return true;
        }
        this.display.sendEvent = false;
        if (!this.isEventView(id2)) {
            return true;
        }
        boolean dragging = false;
        boolean[] consume = null;
        NSEvent nsEvent = new NSEvent(theEvent);
        int nsType = (int)nsEvent.type();
        NSInputManager manager = NSInputManager.currentInputManager();
        if (manager != null && manager.wantsToHandleMouseEvents() && manager.handleMouseEvent(nsEvent)) {
            return true;
        }
        boolean runEnterExit = false;
        Control runEnterExitControl = null;
        switch (nsType) {
            case 1: {
                if (nsEvent.clickCount() != 1L || (nsEvent.modifierFlags() & 0x40000L) != 0L || (this.state & 0x40000) == 0 || !this.hooks(29)) break;
                consume = new boolean[1];
                NSPoint location = this.view.convertPoint_fromView_(nsEvent.locationInWindow(), null);
                if (!this.view.isFlipped()) {
                    location.y = this.view.bounds().height - location.y;
                }
                dragging = this.dragDetect((int)location.x, (int)location.y, false, consume);
                break;
            }
            case 6: 
            case 7: 
            case 27: {
                runEnterExit = true;
                runEnterExitControl = this;
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                if (this.display.clickCount == 2) {
                    this.sendMouseEvent(nsEvent, 8, false);
                }
                runEnterExit = true;
                runEnterExitControl = this.display.findControl(true);
            }
        }
        this.sendMouseEvent(nsEvent, type, false);
        if (dragging) {
            this.sendMouseEvent(nsEvent, 29, false);
        }
        if (runEnterExit) {
            this.display.checkEnterExit(runEnterExitControl, nsEvent, false);
        }
        return consume == null || consume[0] == false;
    }

    void mouseDown(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 3)) {
            return;
        }
        boolean tracking = this.isEventView(id2);
        Display display = this.display;
        if (tracking) {
            display.trackingControl = this;
        }
        super.mouseDown(id2, sel, theEvent);
        if (tracking) {
            display.trackingControl = null;
        }
    }

    void mouseUp(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 4)) {
            return;
        }
        super.mouseUp(id2, sel, theEvent);
    }

    void mouseDragged(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 5)) {
            return;
        }
        super.mouseDragged(id2, sel, theEvent);
    }

    void rightMouseDown(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 3)) {
            return;
        }
        super.rightMouseDown(id2, sel, theEvent);
    }

    void rightMouseUp(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 4)) {
            return;
        }
        super.rightMouseUp(id2, sel, theEvent);
    }

    void rightMouseDragged(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 5)) {
            return;
        }
        super.rightMouseDragged(id2, sel, theEvent);
    }

    void otherMouseDown(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 3)) {
            return;
        }
        super.otherMouseDown(id2, sel, theEvent);
    }

    void otherMouseUp(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 4)) {
            return;
        }
        super.otherMouseUp(id2, sel, theEvent);
    }

    void otherMouseDragged(long id2, long sel, long theEvent) {
        if (!this.mouseEvent(id2, sel, theEvent, 5)) {
            return;
        }
        super.otherMouseDragged(id2, sel, theEvent);
    }

    void moved() {
        this.sendEvent(10);
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    NSView paintView() {
        return this.eventView();
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext(gc.handle);
        NSAffineTransform transform = NSAffineTransform.transform();
        transform.translateXBy(0.0, this.view.bounds().height);
        transform.scaleXBy(1.0, -1.0);
        transform.concat();
        this.view.displayRectIgnoringOpacity(this.view.bounds(), gc.handle);
        NSGraphicsContext.static_restoreGraphicsState();
        return true;
    }

    public void redraw() {
        this.checkWidget();
        this.view.setNeedsDisplay(true);
    }

    void redraw(boolean children) {
        this.view.setNeedsDisplay(true);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        NSRect rect = new NSRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        this.view.setNeedsDisplayInRect(rect);
    }

    long regionToRects(long message, long rgn, long r, long path) {
        NSPoint pt = new NSPoint();
        short[] rect = new short[4];
        if (message == 2L) {
            C.memmove(rect, r, (long)(rect.length * 2));
            pt.x = rect[1];
            pt.y = rect[0];
            OS.objc_msgSend(path, OS.sel_moveToPoint_, pt);
            pt.x = rect[3];
            OS.objc_msgSend(path, OS.sel_lineToPoint_, pt);
            pt.x = rect[3];
            pt.y = rect[2];
            OS.objc_msgSend(path, OS.sel_lineToPoint_, pt);
            pt.x = rect[1];
            OS.objc_msgSend(path, OS.sel_lineToPoint_, pt);
            OS.objc_msgSend(path, OS.sel_closePath);
        }
        return 0L;
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
    }

    void release(boolean destroy) {
        Control next = null;
        Control previous = null;
        if (destroy && this.parent != null) {
            Control[] children = this.parent._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (index > 0 && index + 1 < children.length) {
                next = children[index + 1];
                previous = children[index - 1];
            }
        }
        super.release(destroy);
        if (destroy && previous != null) {
            previous.addRelation(next);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
        this.parent = null;
    }

    void releaseParent() {
        this.invalidateVisibleRegion();
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
            this.display.timerExec(-1, this.display.hoverTimer);
        }
        if (this.display.trackingControl == this) {
            this.display.trackingControl = null;
        }
        if (this.display.tooltipControl == this) {
            this.display.tooltipControl = null;
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        if (this.visibleRgn != 0L) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0L;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeGestureListener(GestureListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    void removeRelation() {
        NSControl viewAsControl;
        if (!this.isDescribedByLabel()) {
            return;
        }
        NSObject accessibleElement = this.focusView();
        if (accessibleElement instanceof NSControl && (viewAsControl = (NSControl)accessibleElement).cell() != null) {
            accessibleElement = viewAsControl.cell();
        }
        accessibleElement.accessibilitySetOverrideValue(accessibleElement, OS.NSAccessibilityTitleUIElementAttribute);
    }

    public void removeTouchListener(TouchListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    void resetVisibleRegion() {
        GCData[] gcs;
        if (this.visibleRgn != 0L) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0L;
        }
        if ((gcs = this.display.contexts) != null) {
            long visibleRgn = 0L;
            int i = 0;
            while (i < gcs.length) {
                GCData data = gcs[i];
                if (data != null && data.view == this.view) {
                    if (visibleRgn == 0L) {
                        visibleRgn = this.getVisibleRegion();
                    }
                    data.state &= 0xFFFFEFFF;
                    OS.CopyRgn(visibleRgn, data.visibleRgn);
                }
                ++i;
            }
            if (visibleRgn != 0L) {
                OS.DisposeRgn(visibleRgn);
            }
        }
    }

    void resized() {
        this.sendEvent(11);
    }

    void rotateWithEvent(long id2, long sel, long event) {
        if (!this.gestureEvent(id2, event, 8)) {
            return;
        }
        super.rotateWithEvent(id2, sel, event);
    }

    boolean sendDragEvent(int button, int stateMask, int x, int y) {
        Event event = new Event();
        event.button = button;
        event.x = x;
        event.y = y;
        event.stateMask = stateMask;
        this.postEvent(29, event);
        return event.doit;
    }

    void sendFocusEvent(int type) {
        Display display = this.display;
        Shell shell = this.getShell();
        display.focusEvent = type;
        display.focusControl = this;
        this.sendEvent(type);
        display.focusEvent = 0;
        display.focusControl = null;
        if (!shell.isDisposed()) {
            switch (type) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendMouseEvent(NSEvent nsEvent, int type, boolean send) {
        NSPoint windowPoint;
        Shell shell = null;
        Event event = new Event();
        switch (type) {
            case 3: {
                shell = this.getShell();
            }
            case 4: 
            case 8: 
            case 29: {
                int button = (int)nsEvent.buttonNumber();
                switch (button) {
                    case 0: {
                        event.button = 1;
                        break;
                    }
                    case 1: {
                        event.button = 3;
                        break;
                    }
                    case 2: {
                        event.button = 2;
                        break;
                    }
                    case 3: {
                        event.button = 4;
                        break;
                    }
                    case 4: {
                        event.button = 5;
                    }
                }
                break;
            }
            case 37: {
                event.detail = 1;
                double delta = nsEvent.deltaY();
                event.count = delta > 0.0 ? Math.max(1, (int)delta) : Math.min(-1, (int)delta);
                break;
            }
            case 38: {
                double delta = nsEvent.deltaX();
                int n = event.count = delta > 0.0 ? Math.max(1, (int)delta) : Math.min(-1, (int)delta);
            }
        }
        if (event.button != 0) {
            event.count = this.display.clickCount;
        }
        NSView view = this.eventView();
        if (nsEvent == null || nsEvent.type() == 5L) {
            NSWindow window = view.window();
            windowPoint = window.convertScreenToBase(NSEvent.mouseLocation());
        } else {
            windowPoint = nsEvent.locationInWindow();
        }
        NSPoint point = view.convertPoint_fromView_(windowPoint, null);
        if (!view.isFlipped()) {
            point.y = view.bounds().height - point.y;
        }
        event.x = (int)point.x;
        event.y = (int)point.y;
        this.setInputState(event, nsEvent, type);
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        if (shell != null) {
            shell.setActiveControl(this);
        }
        return event.doit;
    }

    Touch touchStateFromNSTouch(NSTouch touch) {
        TouchSource source = this.display.findTouchSource(touch);
        long osPhase = touch.phase();
        long identity = OS.objc_msgSend(touch.id, OS.sel_identity);
        int state = 0;
        switch ((int)osPhase) {
            case 1: {
                state = 1;
                break;
            }
            case 2: {
                state = 2;
                break;
            }
            case 8: 
            case 16: {
                state = 4;
            }
        }
        ++this.display.touchCounter;
        boolean primary = false;
        NSPoint normalizedPos = touch.normalizedPosition();
        double normalizedX = normalizedPos.x;
        double normalizedY = 1.0 - normalizedPos.y;
        if (this.display.currentTouches().count() == 1L) {
            this.display.primaryIdentifier = identity;
        }
        if (this.display.primaryIdentifier == identity) {
            primary = true;
        }
        NSSize deviceSize = touch.deviceSize();
        int deviceX = (int)(normalizedX * deviceSize.width);
        int deviceY = (int)(normalizedY * deviceSize.height);
        Touch newTS = new Touch(identity, source, state, primary, deviceX, deviceY);
        return newTS;
    }

    NSTouch findTouchWithId(NSArray touches, NSObject identity) {
        long count = touches.count();
        long i = 0L;
        while (i < count) {
            NSTouch aTouch = new NSTouch(touches.objectAtIndex((long)i).id);
            NSObject currIdentity = new NSObject(OS.objc_msgSend(aTouch.id, OS.sel_identity));
            if (currIdentity.isEqual(identity)) {
                return aTouch;
            }
            ++i;
        }
        return null;
    }

    void setBackground() {
        if (!this.drawsBackground()) {
            return;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.setBackgroundImage(control.backgroundImage.handle);
        } else {
            double[] color = control.background != null ? control.background : control.defaultBackground().handle;
            NSColor nsColor = NSColor.colorWithDeviceRed(color[0], color[1], color[2], color[3]);
            this.setBackgroundColor(nsColor);
        }
    }

    public void setBackground(Color color) {
        double[] background;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray = background = color != null ? color.handle : null;
        if (this.equals(background, this.background)) {
            return;
        }
        this.background = background;
        this.updateBackgroundColor();
        this.redrawWidget(this.view, true);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        this.updateBackgroundImage();
    }

    void setBackgroundImage(NSImage image) {
        this.redrawWidget(this.view, true);
    }

    void setBackgroundColor(NSColor nsColor) {
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), true, true);
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        NSView topView = this.topView();
        if (move && resize) {
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            topView.setFrame(rect);
        } else if (move) {
            NSPoint point = new NSPoint();
            point.x = x;
            point.y = y;
            topView.setFrameOrigin(point);
        } else if (resize) {
            NSSize size = new NSSize();
            size.width = width;
            size.height = height;
            topView.setFrameSize(size);
        }
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    void setClipRegion(NSView view) {
        if (this.regionPath != null) {
            NSView rgnView = this.topView();
            if (!rgnView.isFlipped()) {
                rgnView = this.eventView();
            }
            NSPoint pt = view.convertPoint_toView_(new NSPoint(), rgnView);
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(-pt.x, -pt.y);
            this.regionPath.transformUsingAffineTransform(transform);
            this.regionPath.addClip();
            transform.translateXBy(2.0 * pt.x, 2.0 * pt.y);
            this.regionPath.transformUsingAffineTransform(transform);
        }
        this.parent.setClipRegion(view);
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.view.window().areCursorRectsEnabled()) {
            return;
        }
        this.display.setCursor(this.display.currentControl);
    }

    void setDefaultFont() {
        if (this.display.smallFonts) {
            this.setFont(this.defaultFont().handle);
            this.setSmallSize();
        }
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
        this.state = dragDetect ? (this.state |= 0x40000) : (this.state &= 0xFFFBFFFF);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
        this.setFont(font != null ? font.handle : this.defaultFont().handle);
    }

    void setFont(NSFont font) {
        if (this.view instanceof NSControl) {
            ((NSControl)this.view).setFont(font);
        }
    }

    public void setForeground(Color color) {
        double[] foreground;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray = foreground = color != null ? color.handle : null;
        if (this.equals(foreground, this.foreground)) {
            return;
        }
        this.foreground = foreground;
        this.setForeground(foreground);
        this.redrawWidget(this.view, false);
    }

    void setForeground(double[] color) {
    }

    void setFrameOrigin(long id2, long sel, NSPoint point) {
        NSView topView = this.topView();
        if (topView.id != id2) {
            super.setFrameOrigin(id2, sel, point);
            return;
        }
        NSRect frame = topView.frame();
        super.setFrameOrigin(id2, sel, point);
        if (frame.x != point.x || frame.y != point.y) {
            this.invalidateVisibleRegion();
            this.moved();
        }
    }

    void setFrameSize(long id2, long sel, NSSize size) {
        NSView topView = this.topView();
        if (topView.id != id2) {
            super.setFrameSize(id2, sel, size);
            return;
        }
        NSRect frame = topView.frame();
        super.setFrameSize(id2, sel, size);
        if (frame.width != size.width || frame.height != size.height) {
            this.invalidateVisibleRegion();
            boolean oldResizing = (this.state & 0x80000) != 0;
            this.state |= 0x80000;
            this.resized();
            if (!oldResizing) {
                this.state &= 0xFFF7FFFF;
            }
        }
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setBounds(location.x, location.y, 0, 0, true, false);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell newShell = parent.getShell();
        Shell oldShell = this.getShell();
        Decorations newDecorations = parent.menuShell();
        Decorations oldDecorations = this.menuShell();
        if (oldShell != newShell || oldDecorations != newDecorations) {
            Menu[] menus = oldShell.findMenus(this);
            this.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        }
        NSView topView = this.topView();
        topView.retain();
        topView.removeFromSuperview();
        parent.contentView().addSubview(topView, -1L, null);
        topView.release();
        this.parent = parent;
        this.reskin(1);
        return true;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                this.invalidateVisibleRegion();
                this.redrawWidget(this.topView(), true);
            }
        } else {
            if (this.drawCount == 0) {
                this.invalidateVisibleRegion();
            }
            ++this.drawCount;
        }
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        this.region = region;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = this.getPath(region);
        this.redrawWidget(this.view, true);
    }

    void setRelations() {
        Control child;
        if (this.parent == null) {
            return;
        }
        Control[] children = this.parent._getChildren();
        int count = children.length;
        if (count > 1 && (child = children[count - 2]) != this) {
            child.addRelation(this);
        }
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), false, true);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true);
    }

    void setSmallSize() {
        NSCell cell;
        if (this.view instanceof NSControl && (cell = ((NSControl)this.view).cell()) != null) {
            cell.setControlSize(1L);
        }
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.checkToolTip(null);
    }

    public void setTouchEnabled(boolean enabled) {
        this.checkWidget();
        this.eventView().setAcceptsTouchEvents(enabled);
        this.touchEnabled = enabled;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean fixFocus = false;
        if (!visible && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.topView().setHidden(!visible);
        if (this.isDisposed()) {
            return;
        }
        this.invalidateVisibleRegion();
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    void setZOrder() {
        NSView topView = this.topView();
        this.parent.contentView().addSubview(topView, -1L, null);
    }

    boolean shouldDelayWindowOrderingForEvent(long id2, long sel, long theEvent) {
        Shell shell = this.getShell();
        if ((shell.style & 0x4000) != 0) {
            return false;
        }
        return super.shouldDelayWindowOrderingForEvent(id2, sel, theEvent);
    }

    void setZOrder(Control sibling, boolean above) {
        int index = 0;
        int siblingIndex = 0;
        int oldNextIndex = -1;
        Control[] children = null;
        children = this.parent._getChildren();
        while (index < children.length) {
            if (children[index] == this) break;
            ++index;
        }
        if (sibling != null) {
            while (siblingIndex < children.length) {
                if (children[siblingIndex] == sibling) break;
                ++siblingIndex;
            }
        }
        this.removeRelation();
        if (index + 1 < children.length) {
            oldNextIndex = index + 1;
            children[oldNextIndex].removeRelation();
        }
        if (sibling != null) {
            if (above) {
                sibling.removeRelation();
            } else if (siblingIndex + 1 < children.length) {
                children[siblingIndex + 1].removeRelation();
            }
        }
        NSView otherView = sibling == null ? null : sibling.topView();
        NSView topView = this.topView();
        topView.retain();
        topView.removeFromSuperview();
        this.parent.contentView().addSubview(topView, above ? 1 : -1, otherView);
        topView.release();
        this.invalidateVisibleRegion();
        index = sibling != null ? (above ? siblingIndex - (index < siblingIndex ? 1 : 0) : siblingIndex + (siblingIndex < index ? 1 : 0)) : (above ? 0 : children.length - 1);
        children = this.parent._getChildren();
        if (index > 0) {
            children[index - 1].addRelation(this);
        }
        if (index + 1 < children.length) {
            this.addRelation(children[index + 1]);
        }
        if (oldNextIndex != -1) {
            if (oldNextIndex <= index) {
                --oldNextIndex;
            }
            if (oldNextIndex > 0 && oldNextIndex != index && oldNextIndex != index + 1) {
                children[oldNextIndex - 1].addRelation(children[oldNextIndex]);
            }
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void swipeWithEvent(long id2, long sel, long event) {
        if (!this.gestureEvent(id2, event, 16)) {
            return;
        }
        super.swipeWithEvent(id2, sel, event);
    }

    NSSize textExtent(String string) {
        NSAttributedString attribStr = this.createString(string, null, null, 0, false, true, false);
        NSSize size = attribStr.size();
        attribStr.release();
        return size;
    }

    String tooltipText() {
        return this.toolTipText;
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        return this.display.map(null, this, x, y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        return this.display.map(this, null, x, y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    NSView topView() {
        return this.view;
    }

    boolean touchEvent(long id2, long sel, long eventPtr) {
        if (!this.display.sendEvent) {
            return true;
        }
        this.display.sendEvent = false;
        if (!this.hooks(47) && !this.filters(47)) {
            return true;
        }
        if (!this.isEventView(id2)) {
            return true;
        }
        if (!this.touchEnabled) {
            return true;
        }
        NSEvent nsEvent = new NSEvent(eventPtr);
        NSMutableArray currentTouches = this.display.currentTouches();
        Event event = new Event();
        NSPoint location = this.view.convertPoint_fromView_(nsEvent.locationInWindow(), null);
        if (!this.view.isFlipped()) {
            location.y = this.view.bounds().height - location.y;
        }
        event.x = (int)location.x;
        event.y = (int)location.y;
        this.setInputState(event, nsEvent, 47);
        NSSet allTouchesSet = nsEvent.touchesMatchingPhase(-1L, null);
        long touchCount = allTouchesSet.count();
        Touch[] touches = new Touch[(int)touchCount];
        int currTouchIndex = 0;
        NSArray endedTouches = nsEvent.touchesMatchingPhase(24L, null).allObjects();
        int i = 0;
        while ((long)i < endedTouches.count()) {
            NSTouch touch = new NSTouch(endedTouches.objectAtIndex((long)((long)i)).id);
            NSObject identity = new NSObject(OS.objc_msgSend(touch.id, OS.sel_identity));
            NSTouch endedTouch = this.findTouchWithId(currentTouches, identity);
            if (endedTouch != null) {
                currentTouches.removeObject(endedTouch);
            }
            touches[currTouchIndex++] = this.touchStateFromNSTouch(touch);
            ++i;
        }
        if (currentTouches.count() == 0L) {
            this.display.touchCounter = 0;
        }
        NSArray activeTouches = nsEvent.touchesMatchingPhase(7L, null).allObjects();
        int i2 = 0;
        while ((long)i2 < activeTouches.count()) {
            NSTouch touch = new NSTouch(activeTouches.objectAtIndex((long)((long)i2)).id);
            NSObject identity = new NSObject(OS.objc_msgSend(touch.id, OS.sel_identity));
            NSTouch activeTouch = this.findTouchWithId(currentTouches, identity);
            if (activeTouch == null) {
                currentTouches.addObject(touch);
            }
            touches[currTouchIndex++] = this.touchStateFromNSTouch(touch);
            ++i2;
        }
        if (activeTouches.count() != currentTouches.count()) {
            long j = currentTouches.count() - 1L;
            while (j >= 0L) {
                NSTouch touch = new NSTouch(currentTouches.objectAtIndex((long)j).id);
                NSObject identity = new NSObject(OS.objc_msgSend(touch.id, OS.sel_identity));
                NSTouch activeTouch = this.findTouchWithId(activeTouches, identity);
                if (activeTouch == null) {
                    Touch fakeTouchUp = this.touchStateFromNSTouch(touch);
                    fakeTouchUp.state = 4;
                    if (currTouchIndex == touches.length) {
                        Touch[] newTouchStates = new Touch[touches.length + 1];
                        System.arraycopy(touches, 0, newTouchStates, 0, touches.length);
                        touches = newTouchStates;
                    }
                    touches[currTouchIndex++] = fakeTouchUp;
                    currentTouches.removeObject(activeTouch);
                }
                --j;
            }
        }
        event.touches = touches;
        this.postEvent(47, event);
        return true;
    }

    void touchesBeganWithEvent(long id2, long sel, long event) {
        if (!this.touchEvent(id2, sel, event)) {
            return;
        }
        super.touchesBeganWithEvent(id2, sel, event);
    }

    void touchesCancelledWithEvent(long id2, long sel, long event) {
        if (!this.touchEvent(id2, sel, event)) {
            return;
        }
        super.touchesCancelledWithEvent(id2, sel, event);
    }

    void touchesEndedWithEvent(long id2, long sel, long event) {
        if (!this.touchEvent(id2, sel, event)) {
            return;
        }
        super.touchesEndedWithEvent(id2, sel, event);
    }

    void touchesMovedWithEvent(long id2, long sel, long event) {
        if (!this.touchEvent(id2, sel, event)) {
            return;
        }
        super.touchesMovedWithEvent(id2, sel, event);
    }

    boolean translateTraversal(int key, NSEvent theEvent, boolean[] consume) {
        int detail = 0;
        int code = this.traversalCode(key, theEvent);
        boolean all = false;
        switch (key) {
            case 53: {
                all = true;
                detail = 2;
                break;
            }
            case 36: 
            case 76: {
                all = true;
                detail = 4;
                break;
            }
            case 48: {
                long modifiers = theEvent.modifierFlags();
                boolean next = (modifiers & 0x20000L) == 0L;
                detail = next ? 16 : 8;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                boolean next = key == 125 || key == 124;
                detail = next ? 64 : 32;
                break;
            }
            case 116: 
            case 121: {
                all = true;
                long modifiers = theEvent.modifierFlags();
                if ((modifiers & 0x40000L) == 0L) {
                    return false;
                }
                detail = key == 121 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        consume[0] = (code & detail) != 0;
        event.doit = consume[0];
        event.detail = detail;
        if (!this.setKeyState(event, 31, theEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, NSEvent theEvent) {
        int code = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverseMnemonic(char key) {
        return false;
    }

    public boolean traverse(int traversal, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int traversal, KeyEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    boolean traverse(int traversal, char character, int keyCode, int keyLocation, int stateMask, boolean doit) {
        if (traversal == 0) {
            switch (keyCode) {
                case 27: {
                    traversal = 2;
                    doit = true;
                    break;
                }
                case 13: {
                    traversal = 4;
                    doit = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    traversal = 64;
                    doit = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    traversal = 32;
                    doit = false;
                    break;
                }
                case 9: {
                    traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                    doit = true;
                    break;
                }
                case 0x1000006: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 512;
                    doit = true;
                    break;
                }
                case 0x1000005: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 256;
                    doit = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        Event event = new Event();
        event.character = character;
        event.detail = traversal;
        event.doit = doit;
        event.keyCode = keyCode;
        event.keyLocation = keyLocation;
        event.stateMask = stateMask;
        Shell shell = this.getShell();
        boolean all = false;
        switch (traversal) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                all = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Widget group = this.computeTabGroup();
        Widget[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Widget widget = list[index];
            if (widget.isDisposed() || !widget.setTabGroupFocus()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(Event event) {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        if (this.display.isPainting.containsObject(this.view)) {
            return;
        }
        if (this.isResizing()) {
            return;
        }
        Shell shell = this.getShell();
        NSWindow window = shell.deferFlushing && shell.scrolling ? this.view.window() : null;
        try {
            if (window != null) {
                window.retain();
                window.disableFlushWindow();
            }
            this.view.displayIfNeeded();
        }
        finally {
            if (window != null) {
                window.enableFlushWindow();
                window.release();
            }
        }
    }

    void updateBackgroundColor() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        double[] color = control.background != null ? control.background : control.defaultBackground().handle;
        NSColor nsColor = NSColor.colorWithDeviceRed(color[0], color[1], color[2], color[3]);
        this.setBackgroundColor(nsColor);
    }

    void updateBackgroundImage() {
        Control control = this.findBackgroundControl();
        Image image = control != null ? control.backgroundImage : this.backgroundImage;
        this.setBackgroundImage(image != null ? image.handle : null);
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x400;
        this.checkBackground();
        if (oldState != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void resetCursorRects(long id2, long sel) {
        if (this.isEnabled()) {
            this.callSuper(id2, sel);
        }
    }

    void updateTrackingAreas(long id2, long sel) {
        if (this.isEnabled()) {
            this.callSuper(id2, sel);
        }
    }

    void updateCursorRects(boolean enabled) {
        this.updateCursorRects(enabled, this.view);
    }

    void updateCursorRects(boolean enabled, NSView widget) {
        if (enabled) {
            widget.resetCursorRects();
            widget.updateTrackingAreas();
        } else {
            widget.discardCursorRects();
            NSArray areas = widget.trackingAreas();
            int i = 0;
            while ((long)i < areas.count()) {
                widget.removeTrackingArea(new NSTrackingArea(areas.objectAtIndex(i)));
                ++i;
            }
        }
    }

    void updateLayout(boolean all) {
    }
}

