/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.resources;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    private static final String METHOD_NAME_GET = "get";
    private static final String METHOD_NAME_IS = "is";

    public static Method findGetterForPropertyName(Class<?> resourceClass, String propertyName) {
        Class<?> currentResourceClass = resourceClass;
        do {
            Method[] methodArray = currentResourceClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getParameterTypes().length == 0) {
                    String propertyDescriptionName;
                    PropertyDescription propertyDescriptionAnnotation;
                    String methodName = method.getName();
                    int methodNameLength = methodName.length();
                    if ((methodName.startsWith(METHOD_NAME_GET) && methodNameLength > METHOD_NAME_GET.length() || methodName.startsWith(METHOD_NAME_IS) && methodNameLength > METHOD_NAME_IS.length()) && (propertyDescriptionAnnotation = ReflectionHelper.getAnnotation(method, PropertyDescription.class)) != null && propertyName.equals(propertyDescriptionName = propertyDescriptionAnnotation.name())) {
                        return method;
                    }
                }
                ++n2;
            }
        } while ((currentResourceClass = currentResourceClass.getSuperclass()) != null);
        throw new IllegalArgumentException(NLS.bind((String)"Could not find property named {0} in {1}", (Object[])new Object[]{propertyName, resourceClass}));
    }

    public static Object callGetter(Object object, Method method) {
        try {
            method.setAccessible(true);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> superClass = declaringClass.getSuperclass();
        if (superClass != null) {
            try {
                Method superClassMethod = superClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return ReflectionHelper.getAnnotation(superClassMethod, annotationClass);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static Field findFieldForName(Class<?> resourceClass, String resourceShapeFieldName) {
        Class<?> currentResourceClass = resourceClass;
        while (true) {
            try {
                return currentResourceClass.getDeclaredField(resourceShapeFieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((currentResourceClass = currentResourceClass.getSuperclass()) != null) continue;
                throw new IllegalArgumentException(NLS.bind((String)"Could not field named {0}", (Object)resourceShapeFieldName));
            }
            break;
        }
    }

    public static <T> T getValue(Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

