/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuItemRenderer;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HandledMenuItemRenderer
extends MenuItemRenderer {
    private static final String HMI_STATIC_CONTEXT = "HMIR-staticContext";
    @Inject
    Logger logger;

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MHandledMenuItem) || !(parent instanceof Menu)) {
            return null;
        }
        MHandledMenuItem itemModel = (MHandledMenuItem)element;
        if (itemModel.getVisibleWhen() != null) {
            this.processVisible((MMenuItem)itemModel);
        }
        if (!itemModel.isVisible()) {
            return null;
        }
        int addIndex = this.calcVisibleIndex(element);
        int flags = 0;
        if (itemModel.getType() == ItemType.PUSH) {
            flags = 8;
        } else if (itemModel.getType() == ItemType.CHECK) {
            flags = 32;
        } else if (itemModel.getType() == ItemType.RADIO) {
            flags = 16;
        }
        ParameterizedCommand cmd = itemModel.getWbCommand();
        if (cmd == null) {
            IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
            cmd = HandledMenuItemRenderer.generateParameterizedCommand((MHandledItem)itemModel, lclContext);
        }
        MenuItem newItem = new MenuItem((Menu)parent, flags, addIndex);
        this.setItemText((MMenuItem)itemModel, newItem);
        this.setEnabled(itemModel, newItem);
        newItem.setImage(this.getImage((MUILabel)itemModel));
        newItem.setSelection(itemModel.isSelected());
        return newItem;
    }

    private void setEnabled(MHandledMenuItem itemModel, MenuItem newItem) {
        ParameterizedCommand cmd = itemModel.getWbCommand();
        if (cmd == null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
        IEclipseContext staticContext = EclipseContextFactory.create((String)HMI_STATIC_CONTEXT);
        ContributionsAnalyzer.populateModelInterfaces((Object)itemModel, (IEclipseContext)staticContext, (Class[])itemModel.getClass().getInterfaces());
        try {
            itemModel.setEnabled(service.canExecute(cmd, staticContext));
        }
        finally {
            staticContext.dispose();
        }
        newItem.setEnabled(itemModel.isEnabled());
    }

    protected void setItemText(MMenuItem model, MenuItem item) {
        String text = model.getLocalizedLabel();
        if (model instanceof MHandledItem) {
            TriggerSequence sequence;
            MHandledItem handledItem = (MHandledItem)model;
            IEclipseContext context = this.getContext((MUIElement)model);
            EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
            ParameterizedCommand cmd = handledItem.getWbCommand();
            if (cmd != null && (text == null || text.length() == 0)) {
                try {
                    text = cmd.getName();
                }
                catch (NotDefinedException e) {
                    e.printStackTrace();
                }
            }
            if ((sequence = bs.getBestSequenceFor(handledItem.getWbCommand())) != null) {
                text = String.valueOf(text) + '\t' + sequence.format();
            }
            item.setText(text == null ? handledItem.getCommand().getElementId() : text);
        } else {
            super.setItemText(model, item);
        }
    }

    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        if (me instanceof MHandledItem) {
            final MHandledItem item = (MHandledItem)me;
            final IEclipseContext lclContext = this.getContext(me);
            MenuItem mi = (MenuItem)me.getWidget();
            mi.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
                    ParameterizedCommand cmd = item.getWbCommand();
                    if (cmd == null) {
                        return;
                    }
                    IEclipseContext staticContext = EclipseContextFactory.create((String)HandledMenuItemRenderer.HMI_STATIC_CONTEXT);
                    if (e != null) {
                        staticContext.set(Event.class, (Object)e);
                    }
                    ContributionsAnalyzer.populateModelInterfaces((Object)item, (IEclipseContext)staticContext, (Class[])item.getClass().getInterfaces());
                    try {
                        service.executeHandler(cmd, staticContext);
                    }
                    finally {
                        staticContext.dispose();
                    }
                }
            });
        }
    }

    public static ParameterizedCommand generateParameterizedCommand(MHandledItem item, IEclipseContext lclContext) {
        ECommandService cmdService = (ECommandService)lclContext.get(ECommandService.class.getName());
        HashMap<String, String> parameters = null;
        List modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = cmdService.createCommand(item.getCommand().getElementId(), parameters);
        item.setWbCommand(cmd);
        return cmd;
    }
}

