/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.site.SiteConfiguration;
import org.eclipse.orion.internal.server.servlets.site.SiteConfigurationResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebElement;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.core.users.OrionScope;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.prefs.BackingStoreException;

public class WebUser
extends WebElement {
    public WebUser(IEclipsePreferences store) {
        super(store);
    }

    public static WebUser fromUserName(String userName) {
        IEclipsePreferences users = new OrionScope().getNode("Users");
        IEclipsePreferences result = (IEclipsePreferences)users.node(userName);
        if (result.get("Name", null) == null) {
            result.put("Name", userName);
        }
        if (result.get("Id", null) == null) {
            result.put("Id", new UniversalUniqueIdentifier().toBase64String());
        }
        try {
            result.flush();
        }
        catch (BackingStoreException e) {
            LogHelper.log((Throwable)e);
        }
        return new WebUser(result);
    }

    public WebWorkspace createWorkspace(String name) throws CoreException {
        String id = WebWorkspace.nextWorkspaceId();
        WebWorkspace workspace = WebWorkspace.fromId(id);
        workspace.setName(name);
        workspace.save();
        JSONObject newWorkspace = new JSONObject();
        try {
            newWorkspace.put("Id", (Object)id);
            newWorkspace.put("LastModified", System.currentTimeMillis());
        }
        catch (JSONException jSONException) {}
        String workspaces = this.store.get("Workspaces", null);
        JSONArray workspaceArray = null;
        if (workspaces != null) {
            try {
                workspaceArray = new JSONArray(workspaces);
            }
            catch (JSONException jSONException) {}
        }
        if (workspaceArray == null) {
            workspaceArray = new JSONArray();
        }
        workspaceArray.put((Object)newWorkspace);
        this.store.put("Workspaces", workspaceArray.toString());
        this.save();
        return workspace;
    }

    public JSONArray getWorkspacesJSON() {
        try {
            String workspaces = this.store.get("Workspaces", null);
            if (workspaces != null) {
                return new JSONArray(workspaces);
            }
        }
        catch (JSONException jSONException) {}
        return new JSONArray();
    }

    public SiteConfiguration createSiteConfiguration(String name, String workspace) throws CoreException {
        String id = SiteConfiguration.nextSiteConfigurationId();
        SiteConfiguration siteConfig = SiteConfiguration.fromId(id);
        siteConfig.setName(name);
        siteConfig.setWorkspace(workspace);
        siteConfig.save();
        JSONObject newSiteConfiguration = new JSONObject();
        try {
            newSiteConfiguration.put("Id", (Object)id);
        }
        catch (JSONException jSONException) {}
        IEclipsePreferences siteConfigNode = (IEclipsePreferences)this.getSiteConfigurationsNode().node(id);
        siteConfigNode.put("Id", id);
        this.save();
        return siteConfig;
    }

    public void removeSiteConfiguration(SiteConfiguration siteConfig) throws CoreException {
        try {
            this.getSiteConfigurationsNode().node(siteConfig.getId()).removeNode();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", "Error removing site configuration", (Throwable)e));
        }
        this.save();
    }

    public JSONArray getSiteConfigurationsJSON(URI baseLocation) {
        try {
            IEclipsePreferences siteConfigsNode = (IEclipsePreferences)this.store.node("SiteConfigurations");
            String[] siteConfigIds = siteConfigsNode.childrenNames();
            JSONArray jsonArray = new JSONArray();
            String[] stringArray = siteConfigIds;
            int n = siteConfigIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                SiteConfiguration siteConfig = WebUser.getExistingSiteConfiguration(id);
                JSONObject siteConfigJson = SiteConfigurationResourceHandler.toJSON(siteConfig, baseLocation);
                jsonArray.put((Object)siteConfigJson);
                ++n2;
            }
            return jsonArray;
        }
        catch (BackingStoreException e) {
            LogHelper.log((Throwable)e);
            return new JSONArray();
        }
    }

    public SiteConfiguration getSiteConfiguration(String id) {
        try {
            IEclipsePreferences siteConfigsNode = this.getSiteConfigurationsNode();
            if (siteConfigsNode.nodeExists(id)) {
                if (SiteConfiguration.siteConfigExists(id)) {
                    SiteConfiguration siteConfig = SiteConfiguration.fromId(id);
                    return siteConfig;
                }
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Site configuration does not exist in backing store"));
            }
        }
        catch (BackingStoreException e) {
            LogHelper.log((Throwable)e);
        }
        return null;
    }

    private static SiteConfiguration getExistingSiteConfiguration(String id) {
        if (SiteConfiguration.siteConfigExists(id)) {
            SiteConfiguration siteConfig = SiteConfiguration.fromId(id);
            return siteConfig;
        }
        return null;
    }

    private IEclipsePreferences getSiteConfigurationsNode() {
        return (IEclipsePreferences)this.store.node("SiteConfigurations");
    }

    public void delete() throws CoreException {
        try {
            IEclipsePreferences parent = (IEclipsePreferences)this.store.parent();
            this.store.clear();
            this.store.removeNode();
            parent.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", "Error removing user", (Throwable)e));
        }
    }
}

