/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry.shape;

import org.apache.lucene.spatial.geometry.shape.Geometry2D;
import org.apache.lucene.spatial.geometry.shape.IntersectCase;
import org.apache.lucene.spatial.geometry.shape.Point2D;
import org.apache.lucene.spatial.geometry.shape.Vector2D;

public class Rectangle
implements Geometry2D {
    private Point2D ptMin;
    private Point2D ptMax;

    public Rectangle() {
        this.ptMin = new Point2D(-1.0, 1.0);
        this.ptMax = new Point2D(1.0, 1.0);
    }

    public Rectangle(Point2D ptMin, Point2D ptMax) {
        this.ptMin = new Point2D(ptMin);
        this.ptMax = new Point2D(ptMax);
    }

    public Rectangle(double x1, double y1, double x2, double y2) {
        this.set(x1, y1, x2, y2);
    }

    public String toString() {
        return "[" + this.ptMin + "," + this.ptMax + "]";
    }

    private void set(double x1, double y1, double x2, double y2) {
        this.ptMin = new Point2D(Math.min(x1, x2), Math.min(y1, y2));
        this.ptMax = new Point2D(Math.max(x1, x2), Math.max(y1, y2));
    }

    public double area() {
        return (this.ptMax.getX() - this.ptMin.getX()) * (this.ptMax.getY() - this.ptMin.getY());
    }

    public Point2D centroid() {
        return new Point2D((this.ptMin.getX() + this.ptMax.getX()) / 2.0, (this.ptMin.getY() + this.ptMax.getY()) / 2.0);
    }

    public boolean contains(Point2D p) {
        return p.getX() >= this.ptMin.getX() && p.getX() <= this.ptMax.getX() && p.getY() >= this.ptMin.getY() && p.getY() <= this.ptMax.getY();
    }

    public void translate(Vector2D v) {
        this.ptMin.add(v);
        this.ptMax.add(v);
    }

    Point2D MinPt() {
        return this.ptMin;
    }

    Point2D MaxPt() {
        return this.ptMax;
    }

    public IntersectCase intersect(Rectangle r) {
        throw new UnsupportedOperationException();
    }

    public Point2D getMaxPoint() {
        return this.ptMax;
    }

    public Point2D getMinPoint() {
        return this.ptMin;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ptMax == null ? 0 : this.ptMax.hashCode());
        result = 31 * result + (this.ptMin == null ? 0 : this.ptMin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (this.ptMax == null ? other.ptMax != null : !this.ptMax.equals(other.ptMax)) {
            return false;
        }
        return !(this.ptMin == null ? other.ptMin != null : !this.ptMin.equals(other.ptMin));
    }
}

