/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServletResourceHandler<T> {
    public static Method getMethod(HttpServletRequest request) {
        return Method.fromString(request.getMethod());
    }

    public static URI getURI(HttpServletRequest request) {
        StringBuffer result = request.getRequestURL();
        try {
            return new URI(result.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public abstract boolean handleRequest(HttpServletRequest var1, HttpServletResponse var2, T var3) throws ServletException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        HEAD,
        OPTIONS,
        POST,
        PUT,
        DELETE;


        public static Method fromString(String methodName) {
            if ("GET".equals(methodName)) {
                return GET;
            }
            if ("PUT".equals(methodName)) {
                return PUT;
            }
            if ("POST".equals(methodName)) {
                return POST;
            }
            if ("HEAD".equals(methodName)) {
                return HEAD;
            }
            if ("OPTIONS".equals(methodName)) {
                return OPTIONS;
            }
            if ("DELETE".equals(methodName)) {
                return DELETE;
            }
            return null;
        }
    }
}

