/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.servlets.task.TaskServlet;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.core.tasks.TaskModificationListener;

public class TaskNonotificationRegistry {
    private TaskServlet servlet;
    private ITaskService service;
    private Map<String, TaskListenerJob> listeners = new HashMap<String, TaskListenerJob>();
    private Map<String, Date> lastNodifications = new HashMap<String, Date>();

    public TaskNonotificationRegistry(TaskServlet servlet, ITaskService service) {
        this.servlet = servlet;
        this.service = service;
    }

    public synchronized void setLastNotification(String longpollingId, Date lastNotification, String userId) {
        this.lastNodifications.put(longpollingId, lastNotification);
    }

    public synchronized Job addListener(String longpollingId, HttpServletRequest req, HttpServletResponse resp, String userId) throws ServletException {
        TaskListenerJob listenerJob = new TaskListenerJob(userId, longpollingId, req, resp);
        boolean notifyNow = true;
        if (this.listeners.containsKey(longpollingId)) {
            TaskListenerJob currentJob = this.listeners.get(longpollingId);
            currentJob.cancel();
            if (currentJob.getUserId().equals(userId)) {
                notifyNow = false;
            }
        }
        this.listeners.put(longpollingId, listenerJob);
        if (notifyNow) {
            Date timestamp = new Date();
            List tasks = this.service.getTasks(userId, this.lastNodifications.get(longpollingId) == null ? null : this.lastNodifications.get(longpollingId), false);
            Collection tasksDeleted = this.service.getTasksDeletedSince(userId, this.lastNodifications.get(longpollingId));
            if (!tasks.isEmpty() || !tasksDeleted.isEmpty()) {
                listenerJob.notify(timestamp, tasks, tasksDeleted);
                listenerJob.schedule();
                return listenerJob;
            }
        }
        this.service.addTaskModyficationListener((TaskModificationListener)listenerJob);
        listenerJob.schedule();
        return listenerJob;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskListenerJob
    extends Job
    implements TaskModificationListener {
        private HttpServletRequest req;
        private HttpServletResponse resp;
        private String userId;
        private boolean wasNotified;

        public TaskListenerJob(String userId, String longpollingId, HttpServletRequest req, HttpServletResponse resp) {
            super(longpollingId);
            this.wasNotified = false;
            this.req = req;
            this.resp = resp;
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        protected synchronized void canceling() {
            this.wasNotified = true;
            TaskNonotificationRegistry.this.listeners.remove(this.getName());
            try {
                TaskServlet.writeJSONResponse(this.req, this.resp, TaskNonotificationRegistry.this.servlet.getTasksList(new ArrayList<TaskInfo>(), new Date(), this.req, this.resp));
            }
            catch (Exception e) {
                this.done((IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
                return;
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!this.wasNotified) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return new ServerStatus(4, 500, e.getMessage(), (Throwable)e);
                }
            }
            TaskNonotificationRegistry.this.service.removeTaskModyficationListener((TaskModificationListener)this);
            return Status.OK_STATUS;
        }

        public synchronized void notify(Date timestamp, List<TaskInfo> tasks, Collection<String> deletedTasks) {
            this.wasNotified = true;
            TaskNonotificationRegistry.this.listeners.remove(this.getName());
            try {
                TaskServlet.writeJSONResponse(this.req, this.resp, TaskNonotificationRegistry.this.servlet.getTasksList(tasks, deletedTasks, timestamp, this.req, this.resp));
                TaskNonotificationRegistry.this.lastNodifications.put(this.getName(), timestamp);
            }
            catch (Exception e) {
                this.done((IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
                return;
            }
            this.done(Status.OK_STATUS);
        }

        public synchronized void tasksModified(String userId, Date modificationDate) {
            if (this.wasNotified) {
                return;
            }
            if (!this.userId.equals(userId)) {
                return;
            }
            Date lastNotification = (Date)TaskNonotificationRegistry.this.lastNodifications.get(this.getName());
            this.notify(modificationDate, TaskNonotificationRegistry.this.service.getTasks(userId, lastNotification, false), TaskNonotificationRegistry.this.service.getTasksDeletedSince(userId, lastNotification));
        }

        public synchronized void tasksDeleted(String userId, Date timestamp) {
            if (this.wasNotified) {
                return;
            }
            if (!this.userId.equals(userId)) {
                return;
            }
            this.notify(timestamp, new ArrayList<TaskInfo>(), TaskNonotificationRegistry.this.service.getTasksDeletedSince(userId, (Date)TaskNonotificationRegistry.this.lastNodifications.get(this.getName())));
        }
    }
}

