/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectParentDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        Path resourcePath = new Path(resource.getPath());
        if (!"/file".equals(request.getServletPath())) {
            return;
        }
        try {
            WebWorkspace workspace;
            WebProject project;
            String projectName;
            if (resourcePath.hasTrailingSeparator() && !representation.getBoolean("Directory")) {
                resourcePath = resourcePath.append(representation.getString("Name"));
            }
            this.addParents(resource, representation, (IPath)resourcePath);
            if (resourcePath.segmentCount() == 3 && (projectName = (project = (workspace = WebWorkspace.fromId(resourcePath.segment(1))).getProjectByName(resourcePath.segment(2))).getName()) != null) {
                representation.put("Name", (Object)projectName);
            }
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addParents(URI resource, JSONObject representation, IPath resourcePath) throws JSONException {
        resourcePath = resourcePath.removeLastSegments(1).addTrailingSeparator();
        JSONArray parents = new JSONArray();
        while (resourcePath.segmentCount() > 3) {
            try {
                URI uri = resource.resolve(new URI(null, resourcePath.toString(), null));
                this.addParent(parents, resourcePath.lastSegment(), new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
            resourcePath = resourcePath.removeLastSegments(1);
        }
        if (resourcePath.segmentCount() == 3) {
            WebWorkspace workspace = WebWorkspace.fromId(resourcePath.segment(1));
            WebProject project = workspace.getProjectByName(resourcePath.segment(2));
            try {
                URI uri = resource.resolve(new URI(null, resourcePath.toString(), null));
                this.addParent(parents, project.getName(), new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
        }
        representation.put("Parents", (Object)parents);
    }

    private void addParent(JSONArray parents, String name, URI location) throws JSONException {
        URI childLocation;
        JSONObject parent = new JSONObject();
        parent.put("Name", (Object)name);
        parent.put("Location", (Object)location);
        try {
            childLocation = new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), location.getPath(), "depth=1", location.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        parent.put("ChildrenLocation", (Object)childLocation);
        parents.put((Object)parent);
    }
}

