/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.workspace.WebElement;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64Counter;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProject
extends WebElement {
    public static final String PROJECT_NODE_NAME = "Projects";
    private static final Base64Counter projectCounter = new Base64Counter();

    public static WebProject fromId(String id) {
        WebProject result = new WebProject((IEclipsePreferences)scope.getNode(PROJECT_NODE_NAME).node(id));
        result.setId(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nextProjectId() {
        Base64Counter base64Counter = projectCounter;
        synchronized (base64Counter) {
            String candidate;
            do {
                candidate = projectCounter.toString();
                projectCounter.increment();
            } while (WebProject.exists(candidate) || !caseSensitive && WebProject.containsUpperCase(candidate));
            return candidate;
        }
    }

    public static boolean exists(String id) {
        try {
            return scope.getNode(PROJECT_NODE_NAME).nodeExists(id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<WebProject> allProjects() {
        ArrayList<WebProject> result = new ArrayList<WebProject>();
        IEclipsePreferences projectRoot = scope.getNode(PROJECT_NODE_NAME);
        try {
            String[] ids;
            String[] stringArray = ids = projectRoot.childrenNames();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                result.add(WebProject.fromId(id));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            LogHelper.log((Throwable)e);
        }
        return result;
    }

    public WebProject(IEclipsePreferences store) {
        super(store);
    }

    public void remove() {
        this.store.remove("ContentLocation");
        this.store.remove("Id");
        this.store.remove("Name");
    }

    public void setContentLocation(URI contentURI) {
        this.store.put("ContentLocation", contentURI.toString());
    }

    public URI getContentLocation() {
        String result = this.store.get("ContentLocation", null);
        if (result != null) {
            try {
                return new URI(result);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return URI.create(this.getId());
    }

    public IFileStore getProjectStore() throws CoreException {
        URI location = this.getContentLocation();
        if (location.isAbsolute()) {
            return EFS.getStore((URI)location);
        }
        Path localPath = new Path(location.getPath());
        if (localPath.isAbsolute()) {
            return EFS.getLocalFileSystem().getStore((IPath)localPath);
        }
        URI rootLocation = Activator.getDefault().getRootLocationURI();
        IFileStore root = EFS.getStore((URI)rootLocation);
        return root.getChild(location.toString());
    }
}

