/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace.authorization;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReaderV1;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReaderV3;
import org.json.JSONArray;
import org.json.JSONException;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AuthorizationReader {
    static AuthorizationReader readerV1 = new AuthorizationReaderV1();
    static AuthorizationReader readerV3 = new AuthorizationReaderV3();
    private static final int CURRENT_VERSION = 3;

    public static JSONArray getAuthorizationData(String userId, IEclipsePreferences preferences) throws JSONException {
        AuthorizationReader reader;
        int version = preferences.getInt("UserRightsVersion", 1);
        switch (version) {
            case 1: 
            case 2: {
                reader = readerV1;
                break;
            }
            case 3: {
                reader = readerV3;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported auth data version: " + version);
            }
        }
        JSONArray authInfo = reader.readAuthorizationInfo(userId, preferences);
        try {
            if (version != 3) {
                AuthorizationReader.saveRights(preferences, authInfo);
            }
        }
        catch (BackingStoreException backingStoreException) {}
        return authInfo;
    }

    abstract JSONArray readAuthorizationInfo(String var1, IEclipsePreferences var2) throws JSONException;

    static void saveRights(IEclipsePreferences result, JSONArray userRightArray) throws BackingStoreException {
        result.put("UserRights", userRightArray.toString());
        result.putInt("UserRightsVersion", 3);
        result.parent().flush();
    }
}

