/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.xfer.SFTPTransferJob;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFTPExportJob
extends SFTPTransferJob {
    public SFTPExportJob(String userRunningTask, File localFile, String host, int port, Path remotePath, String user, String passphrase, List<String> options) {
        super(userRunningTask, localFile, host, port, (IPath)remotePath, user, passphrase, options);
    }

    protected void doTransferFile(ChannelSftp channel, IPath remotePath, File localFile) throws IOException, SftpException {
        if (this.shouldSkip(channel, remotePath, localFile)) {
            return;
        }
        channel.put((InputStream)new FileInputStream(localFile), remotePath.toString());
    }

    private boolean shouldSkip(ChannelSftp channel, IPath remotePath, File localFile) throws IOException {
        SftpATTRS remoteAttributes;
        try {
            remoteAttributes = channel.stat(remotePath.toString());
        }
        catch (SftpException sftpException) {
            return false;
        }
        if (this.getOptions().contains("no-overwrite")) {
            throw new IOException(NLS.bind((String)"Remote file exists: {0}", (Object)remotePath.removeFirstSegments(this.remoteRoot.segmentCount()).toString()));
        }
        int localMTime = (int)(localFile.lastModified() / 1000L);
        int remoteMTime = remoteAttributes.getMTime();
        if (this.getOptions().contains("overwrite-older") && remoteMTime > localMTime) {
            return true;
        }
        return localMTime == remoteMTime && localFile.length() == remoteAttributes.getSize();
    }

    @Override
    protected void transferDirectory(ChannelSftp channel, IPath remotePath, File localFile) throws SftpException, IOException {
        this.setTaskMessage(NLS.bind((String)"Exporting {0}...", (Object)(String.valueOf(this.host) + remotePath.toString())));
        try {
            channel.mkdir(remotePath.toString());
        }
        catch (SftpException sftpException) {}
        ArrayList<File> localChildren = new ArrayList<File>();
        File[] localFiles = localFile.listFiles();
        if (localFiles != null) {
            localChildren.addAll(Arrays.asList(localFiles));
        }
        for (File localChild : localChildren) {
            String childName = localChild.getName();
            if (this.shouldSkip(childName)) continue;
            IPath remoteChild = remotePath.append(childName);
            if (localChild.isDirectory()) {
                this.transferDirectory(channel, remoteChild, localChild);
                continue;
            }
            this.doTransferFile(channel, remoteChild, localChild);
        }
    }
}

