/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.CharArrayWriter;
import java.io.IOException;

public class LimitedSizeCharArrayWriter
extends CharArrayWriter {
    private long maxSize;
    private long size = 0L;

    public LimitedSizeCharArrayWriter(long maxSize) {
        this.maxSize = maxSize;
    }

    public void write(char[] c, int off, int len) {
        this.size += (long)len;
        super.write(c, off, len);
    }

    public void write(char[] cbuf) throws IOException {
        this.size += (long)cbuf.length;
        if (this.size < this.maxSize) {
            super.write(cbuf);
        }
    }

    public void write(String str, int off, int len) {
        this.size += (long)len;
        if (this.size < this.maxSize) {
            super.write(str, off, len);
        }
    }

    public void write(int c) {
        ++this.size;
        if (this.size < this.maxSize) {
            super.write(c);
        }
    }

    public void write(String str) throws IOException {
        this.size += (long)str.length();
        if (this.size < this.maxSize) {
            super.write(str);
        }
    }
}

