/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.params.TermsParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.StrField;
import org.apache.solr.util.BoundedTreeSet;

public class TermsComponent
extends SearchComponent {
    public static final int UNLIMITED_MAX_COUNT = -1;
    public static final String COMPONENT_NAME = "terms";

    public void prepare(ResponseBuilder rb) throws IOException {
        String shards;
        SolrParams params = rb.req.getParams();
        if (params.getBool(COMPONENT_NAME, false)) {
            rb.doTerms = true;
        }
        if ((shards = params.get("shards")) != null) {
            if (params.get("shards.qt") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shards.qt parameter specified");
            }
            List lst = StrUtils.splitSmart((String)shards, (String)",", (boolean)true);
            rb.shards = lst.toArray(new String[lst.size()]);
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (params.getBool(COMPONENT_NAME, false)) {
            String lowerStr = params.get("terms.lower", null);
            String[] fields = params.getParams("terms.fl");
            if (fields != null && fields.length > 0) {
                SimpleOrderedMap terms = new SimpleOrderedMap();
                rb.rsp.add(COMPONENT_NAME, terms);
                int limit = params.getInt("terms.limit", 10);
                if (limit < 0) {
                    limit = Integer.MAX_VALUE;
                }
                String upperStr = params.get("terms.upper");
                boolean upperIncl = params.getBool("terms.upper.incl", false);
                boolean lowerIncl = params.getBool("terms.lower.incl", true);
                boolean sort = !"index".equals(params.get("terms.sort", "count"));
                int freqmin = params.getInt("terms.mincount", 1);
                int freqmax = params.getInt("terms.maxcount", -1);
                if (freqmax < 0) {
                    freqmax = Integer.MAX_VALUE;
                }
                String prefix = params.get("terms.prefix");
                String regexp = params.get("terms.regex");
                Pattern pattern = regexp != null ? Pattern.compile(regexp, this.resolveRegexpFlags(params)) : null;
                boolean raw = params.getBool("terms.raw", false);
                block0: for (int j = 0; j < fields.length; ++j) {
                    Term theTerm;
                    String lower;
                    FieldType ft;
                    String field = StringHelper.intern((String)fields[j]);
                    FieldType fieldType = ft = raw ? null : rb.req.getSchema().getFieldTypeNoEx(field);
                    if (ft == null) {
                        ft = new StrField();
                    }
                    String string = lowerStr == null ? prefix : (lower = raw ? lowerStr : ft.toInternal(lowerStr));
                    if (lower == null) {
                        lower = "";
                    }
                    String upper = upperStr == null ? null : (raw ? upperStr : ft.toInternal(upperStr));
                    Term lowerTerm = new Term(field, lower);
                    Term upperTerm = upper == null ? null : new Term(field, upper);
                    TermEnum termEnum = rb.req.getSearcher().getReader().terms(lowerTerm);
                    int i = 0;
                    BoundedTreeSet<SimpleFacets.CountPair<String, Integer>> queue = sort ? new BoundedTreeSet<SimpleFacets.CountPair<String, Integer>>(limit) : null;
                    NamedList fieldTerms = new NamedList();
                    terms.add(field, (Object)fieldTerms);
                    Term lowerTestTerm = termEnum.term();
                    if (lowerTestTerm != null && !lowerIncl && lowerTestTerm.field() == field && lowerTestTerm.text().equals(lower)) {
                        termEnum.next();
                    }
                    while ((i < limit || sort) && (theTerm = termEnum.term()) != null && field == theTerm.field()) {
                        int upperCmp;
                        String string2 = theTerm.text();
                        if (prefix != null && !string2.startsWith(prefix)) break;
                        if (pattern != null && !pattern.matcher(string2).matches()) {
                            termEnum.next();
                            continue;
                        }
                        if (upperTerm != null && ((upperCmp = theTerm.compareTo(upperTerm)) > 0 || upperCmp == 0 && !upperIncl)) break;
                        int docFreq = termEnum.docFreq();
                        if (docFreq >= freqmin && docFreq <= freqmax) {
                            String label;
                            String string3 = label = raw ? string2 : ft.indexedToReadable(string2);
                            if (sort) {
                                queue.add(new SimpleFacets.CountPair<String, Integer>(label, docFreq));
                            } else {
                                fieldTerms.add(label, (Object)docFreq);
                                ++i;
                            }
                        }
                        termEnum.next();
                    }
                    termEnum.close();
                    if (!sort) continue;
                    for (SimpleFacets.CountPair countPair : queue) {
                        if (i >= limit) continue block0;
                        fieldTerms.add((String)countPair.key, countPair.val);
                        ++i;
                    }
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No terms.fl parameter specified");
            }
        }
    }

    int resolveRegexpFlags(SolrParams params) {
        String[] flagParams = params.getParams("terms.regex.flag");
        if (flagParams == null) {
            return 0;
        }
        int flags = 0;
        for (String flagParam : flagParams) {
            try {
                flags |= TermsParams.TermsRegexpFlag.valueOf((String)flagParam.toUpperCase(Locale.ENGLISH)).getValue();
            }
            catch (IllegalArgumentException iae) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown terms regex flag '" + flagParam + "'");
            }
        }
        return flags;
    }

    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.doTerms) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            TermsHelper th = rb._termsHelper;
            if (th == null) {
                th = rb._termsHelper = new TermsHelper();
                th.init(rb.req.getParams());
            }
            ShardRequest sreq = this.createShardQuery(rb.req.getParams());
            rb.addRequest(this, sreq);
        }
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doTerms || (sreq.purpose & 0x400) == 0) {
            return;
        }
        TermsHelper th = rb._termsHelper;
        if (th != null) {
            for (ShardResponse srsp : sreq.responses) {
                th.parse((NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME));
            }
        }
    }

    public void finishStage(ResponseBuilder rb) {
        if (!rb.doTerms || rb.stage != ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return;
        }
        TermsHelper ti = rb._termsHelper;
        NamedList terms = ti.buildResponse();
        rb.rsp.add(COMPONENT_NAME, terms);
        rb._termsHelper = null;
    }

    private ShardRequest createShardQuery(SolrParams params) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1024;
        sreq.params = new ModifiableSolrParams(params);
        sreq.params.remove("shards");
        sreq.params.remove("terms.maxcount");
        sreq.params.remove("terms.mincount");
        sreq.params.set("terms.limit", -1);
        sreq.params.set("terms.sort", new String[]{"index"});
        String qt = params.get("qt");
        if (qt != null) {
            sreq.params.add("qt", new String[]{qt});
        }
        return sreq;
    }

    public String getVersion() {
        return "$Revision: 1067552 $";
    }

    public String getSourceId() {
        return "$Id: TermsComponent.java 1067552 2011-02-05 23:52:42Z koji $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_5/solr/core/src/java/org/apache/solr/handler/component/TermsComponent.java $";
    }

    public String getDescription() {
        return "A Component for working with Term Enumerators";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TermsHelper {
        private HashMap<String, HashMap<String, TermsResponse.Term>> fieldmap = new HashMap(5);
        private SolrParams params;

        public void init(SolrParams params) {
            this.params = params;
            String[] fields = params.getParams("terms.fl");
            if (fields != null) {
                for (String field : fields) {
                    this.fieldmap.put(field, new HashMap(128));
                }
            }
        }

        public void parse(NamedList terms) {
            if (terms == null) {
                return;
            }
            TermsResponse termsResponse = new TermsResponse(terms);
            for (String key : this.fieldmap.keySet()) {
                HashMap<String, TermsResponse.Term> termmap = this.fieldmap.get(key);
                List termlist = termsResponse.getTerms(key);
                if (termlist == null) continue;
                for (TermsResponse.Term tc : termlist) {
                    String term = tc.getTerm();
                    if (termmap.containsKey(term)) {
                        TermsResponse.Term oldtc = termmap.get(term);
                        oldtc.addFrequency(tc.getFrequency());
                        termmap.put(term, oldtc);
                        continue;
                    }
                    termmap.put(term, tc);
                }
            }
        }

        public NamedList buildResponse() {
            SimpleOrderedMap response = new SimpleOrderedMap();
            boolean sort = !"index".equals(this.params.get("terms.sort", "count"));
            long freqmin = 1L;
            String s = this.params.get("terms.mincount");
            if (s != null) {
                freqmin = Long.parseLong(s);
            }
            long freqmax = -1L;
            s = this.params.get("terms.maxcount");
            if (s != null) {
                freqmax = Long.parseLong(s);
            }
            if (freqmax < 0L) {
                freqmax = Long.MAX_VALUE;
            }
            long limit = 10L;
            s = this.params.get("terms.limit");
            if (s != null) {
                limit = Long.parseLong(s);
            }
            if (limit < 0L) {
                limit = Long.MAX_VALUE;
            }
            for (String key : this.fieldmap.keySet()) {
                SimpleOrderedMap fieldterms = new SimpleOrderedMap();
                TermsResponse.Term[] data = null;
                data = sort ? this.getCountSorted(this.fieldmap.get(key)) : this.getLexSorted(this.fieldmap.get(key));
                int cnt = 0;
                for (TermsResponse.Term tc : data) {
                    if (tc.getFrequency() >= freqmin && tc.getFrequency() <= freqmax) {
                        fieldterms.add(tc.getTerm(), (Object)this.num(tc.getFrequency()));
                        ++cnt;
                    }
                    if ((long)cnt >= limit) break;
                }
                response.add(key, (Object)fieldterms);
            }
            return response;
        }

        private Number num(long val) {
            if (val < Integer.MAX_VALUE) {
                return (int)val;
            }
            return val;
        }

        public TermsResponse.Term[] getLexSorted(HashMap<String, TermsResponse.Term> data) {
            TermsResponse.Term[] arr = data.values().toArray(new TermsResponse.Term[data.size()]);
            Arrays.sort(arr, new Comparator<TermsResponse.Term>(){

                @Override
                public int compare(TermsResponse.Term o1, TermsResponse.Term o2) {
                    return o1.getTerm().compareTo(o2.getTerm());
                }
            });
            return arr;
        }

        public TermsResponse.Term[] getCountSorted(HashMap<String, TermsResponse.Term> data) {
            TermsResponse.Term[] arr = data.values().toArray(new TermsResponse.Term[data.size()]);
            Arrays.sort(arr, new Comparator<TermsResponse.Term>(){

                @Override
                public int compare(TermsResponse.Term o1, TermsResponse.Term o2) {
                    long freq1 = o1.getFrequency();
                    long freq2 = o2.getFrequency();
                    if (freq2 < freq1) {
                        return -1;
                    }
                    if (freq1 < freq2) {
                        return 1;
                    }
                    return o1.getTerm().compareTo(o2.getTerm());
                }
            });
            return arr;
        }
    }
}

