/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.orion.internal.server.core.tasks.TaskService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    public static volatile BundleContext bundleContext;
    static Activator singleton;
    ServiceTracker<FrameworkLog, FrameworkLog> logTracker;
    ServiceTracker<IPreferencesService, IPreferencesService> prefTracker;
    private ServiceRegistration<ITaskService> taskServiceRegistration;

    public static Activator getDefault() {
        return singleton;
    }

    public static FrameworkLog getFrameworkLog() {
        Activator a = singleton;
        if (a == null) {
            return null;
        }
        ServiceTracker<FrameworkLog, FrameworkLog> tracker = a.getLogTracker();
        if (tracker == null) {
            return null;
        }
        return (FrameworkLog)tracker.getService();
    }

    public static IPreferencesService getPreferenceService() {
        Activator a = singleton;
        if (a == null) {
            return null;
        }
        ServiceTracker<IPreferencesService, IPreferencesService> tracker = a.getPrefTracker();
        if (tracker == null) {
            return null;
        }
        return (IPreferencesService)tracker.getService();
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    private ServiceTracker<FrameworkLog, FrameworkLog> getLogTracker() {
        if (this.logTracker != null) {
            return this.logTracker;
        }
        if (bundleContext == null) {
            return null;
        }
        this.logTracker = new ServiceTracker(bundleContext, FrameworkLog.class, null);
        this.logTracker.open();
        return this.logTracker;
    }

    private ServiceTracker<IPreferencesService, IPreferencesService> getPrefTracker() {
        if (this.prefTracker != null) {
            return this.prefTracker;
        }
        if (bundleContext == null) {
            return null;
        }
        this.prefTracker = new ServiceTracker(bundleContext, IPreferencesService.class, null);
        this.prefTracker.open();
        return this.prefTracker;
    }

    private IPath getTaskLocation() throws IOException {
        Collection refs;
        BundleContext context = Activator.getDefault().getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            throw new IOException("Framework instance location is undefined");
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location == null) {
                throw new IOException("Framework instance location is undefined");
            }
            URL root = location.getDataArea("org.eclipse.orion.server.core");
            IPath iPath = new Path(root.toExternalForm().substring(5)).append("tasks");
            return iPath;
        }
        finally {
            context.ungetService(ref);
        }
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        this.startTaskService();
    }

    private void startTaskService() {
        try {
            IPath taskLocation = this.getTaskLocation();
            TaskService service = new TaskService(taskLocation);
            this.taskServiceRegistration = bundleContext.registerService(ITaskService.class, (Object)service, null);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Failed to initialize task service", (Throwable)e));
        }
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
        this.stopTaskService();
        if (this.prefTracker != null) {
            this.prefTracker.close();
            this.prefTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
    }

    private void stopTaskService() {
        ServiceRegistration<ITaskService> reg = this.taskServiceRegistration;
        this.taskServiceRegistration = null;
        if (reg != null) {
            reg.unregister();
        }
    }
}

