/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.tasks;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.core.tasks.TaskDescription;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskStore {
    private final File root;

    public TaskStore(File root) {
        this.root = root;
        this.root.mkdirs();
    }

    private String getUserDirectory(String userId) {
        return new String(Base64.encode(userId.getBytes()));
    }

    private String getUserName(String userDirectoryName) {
        try {
            return new String(Base64.decode(userDirectoryName.getBytes()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized String readTask(TaskDescription td) {
        File userDirectory = new File(this.root, this.getUserDirectory(td.getUserId()));
        if (!userDirectory.exists()) {
            return null;
        }
        File taskFile = new File(userDirectory, td.getTaskId());
        if (!taskFile.exists()) {
            return null;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(taskFile);
            StringWriter writer = new StringWriter();
            IOUtilities.pipe(reader, writer, true, false);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            LogHelper.log(e);
            return null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogHelper.log(e);
                    return null;
                }
            }
        }
    }

    public synchronized void writeTask(TaskDescription td, String representation) {
        try {
            File userDirectory = new File(this.root, this.getUserDirectory(td.getUserId()));
            if (!userDirectory.exists()) {
                userDirectory.mkdir();
            }
            File taskFile = new File(userDirectory, td.getTaskId());
            FileWriter writer = new FileWriter(taskFile);
            StringReader reader = new StringReader(representation);
            IOUtilities.pipe(reader, writer, true, true);
        }
        catch (IOException e) {
            LogHelper.log(e);
        }
    }

    public synchronized boolean removeTask(TaskDescription td) {
        File userDirectory = new File(this.root, this.getUserDirectory(td.getUserId()));
        if (!userDirectory.exists()) {
            return false;
        }
        File taskFile = new File(userDirectory, td.getTaskId());
        if (!taskFile.exists()) {
            return false;
        }
        return taskFile.delete();
    }

    private List<String> internalReadAllTasks(File userDirectory) {
        ArrayList<String> result = new ArrayList<String>();
        File[] fileArray = userDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File taskFile = fileArray[n2];
            if (taskFile.isFile()) {
                FileReader reader = null;
                try {
                    try {
                        reader = new FileReader(taskFile);
                        StringWriter writer = new StringWriter();
                        IOUtilities.pipe(reader, writer, true, false);
                        result.add(writer.toString());
                    }
                    catch (IOException e) {
                        LogHelper.log(e);
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                LogHelper.log(e2);
                                return null;
                            }
                        }
                        return null;
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LogHelper.log(e);
                            return null;
                        }
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    private List<TaskDescription> internalReadAllTasksDescriptions(File userDirectory) {
        ArrayList<TaskDescription> result = new ArrayList<TaskDescription>();
        String userId = this.getUserName(userDirectory.getName());
        if (userId == null) {
            return result;
        }
        File[] fileArray = userDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File taskFile = fileArray[n2];
            if (taskFile.isFile()) {
                result.add(new TaskDescription(userId, taskFile.getName()));
            }
            ++n2;
        }
        return result;
    }

    public synchronized List<String> readAllTasks(String userId) {
        File userDirectory = new File(this.root, this.getUserDirectory(userId));
        if (!userDirectory.exists()) {
            return new ArrayList<String>();
        }
        return this.internalReadAllTasks(userDirectory);
    }

    public synchronized List<TaskDescription> readAllTasks() {
        ArrayList<TaskDescription> result = new ArrayList<TaskDescription>();
        File[] fileArray = this.root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File userDirectory = fileArray[n2];
            if (userDirectory.isDirectory()) {
                result.addAll(this.internalReadAllTasksDescriptions(userDirectory));
            }
            ++n2;
        }
        return result;
    }
}

