/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.tasks;

import java.net.URI;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskInfo {
    public static final String KEY_PERCENT_COMPLETE = "PercentComplete";
    public static final String KEY_ID = "Id";
    public static final String KEY_USER = "User";
    public static final String KEY_MESSAGE = "Message";
    public static final String KEY_RUNNING = "Running";
    public static final String KEY_LOCATION = "Location";
    public static final String KEY_RESULT = "Result";
    public static final String KEY_CAN_BE_CANCELED = "CanBeCanceled";
    public static final String KEY_TIMESTAMP_MODIFIED = "Modified";
    public static final String KEY_TIMESTAMP_CREATED = "Created";
    public static final String KEY_NAME = "Name";
    public static final String KEY_FAILED = "Failed";
    public static final String KEY_CANCELED = "Canceled";
    public static final String KEY_IDEMPOTENT = "Idempotent";
    private final String id;
    private final String userId;
    private boolean idempotent = false;
    private String message = "";
    private int percentComplete = 0;
    private boolean running = true;
    private URI resultLocation = null;
    private IStatus result;
    private boolean canBeCanceled = false;
    private Date modified;
    private Date created;
    private String name;

    public static TaskInfo fromJSON(String taskString) {
        try {
            String resultString;
            JSONObject json = new JSONObject(taskString);
            TaskInfo info = new TaskInfo(json.getString(KEY_USER), json.getString(KEY_ID), json.optBoolean(KEY_IDEMPOTENT, false));
            info.setMessage(json.optString(KEY_MESSAGE, ""));
            info.setName(json.optString(KEY_NAME, ""));
            info.modified = json.has(KEY_TIMESTAMP_MODIFIED) ? new Date(json.getLong(KEY_TIMESTAMP_MODIFIED)) : new Date(0L);
            info.created = json.has(KEY_TIMESTAMP_CREATED) ? new Date(json.getLong(KEY_TIMESTAMP_CREATED)) : new Date(0L);
            info.running = json.optBoolean(KEY_RUNNING, true);
            info.setPercentComplete(json.optInt(KEY_PERCENT_COMPLETE, 0));
            String location = json.optString(KEY_LOCATION, null);
            if (location != null) {
                info.resultLocation = URI.create(location);
            }
            if ((resultString = json.optString(KEY_RESULT, null)) != null) {
                info.result = ServerStatus.fromJSON(resultString);
            }
            return info;
        }
        catch (JSONException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Invalid task: " + taskString, (Throwable)e));
            return null;
        }
    }

    public TaskInfo(String userId, String id, boolean idempotent) {
        this.idempotent = idempotent;
        this.userId = userId;
        this.id = id;
        this.modified = new Date();
        this.created = new Date();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean canBeCanceled() {
        return this.canBeCanceled;
    }

    public void setCanBeCanceled(boolean canBeCanceled) {
        this.canBeCanceled = canBeCanceled;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public String getMessage() {
        return this.message;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public URI getResultLocation() {
        return this.resultLocation;
    }

    public IStatus getResult() {
        return this.result;
    }

    public String getTaskId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isRunning() {
        return this.running;
    }

    public TaskInfo setMessage(String message) {
        this.message = message == null ? "" : message;
        return this;
    }

    public TaskInfo setPercentComplete(int percentComplete) {
        if (percentComplete < 0) {
            percentComplete = 0;
        }
        if (percentComplete > 100) {
            percentComplete = 100;
        }
        this.percentComplete = percentComplete;
        return this;
    }

    public TaskInfo done(IStatus status) {
        this.running = false;
        this.percentComplete = 100;
        this.result = status;
        this.message = status.getMessage();
        this.modified = new Date();
        return this;
    }

    public TaskInfo setResultLocation(String location) {
        this.resultLocation = URI.create(location);
        return this;
    }

    public TaskInfo setResultLocation(URI location) {
        this.resultLocation = location;
        return this;
    }

    public JSONObject toLightJSON() {
        JSONObject resultObject = new JSONObject();
        try {
            resultObject.put(KEY_RUNNING, this.isRunning());
            resultObject.put(KEY_MESSAGE, (Object)this.getMessage());
            resultObject.put(KEY_ID, (Object)this.getTaskId());
            resultObject.put(KEY_USER, (Object)this.getUserId());
            resultObject.put(KEY_PERCENT_COMPLETE, this.getPercentComplete());
            resultObject.put(KEY_TIMESTAMP_MODIFIED, this.modified.getTime());
            resultObject.put(KEY_CAN_BE_CANCELED, this.canBeCanceled);
            resultObject.put(KEY_TIMESTAMP_CREATED, this.created.getTime());
            resultObject.put(KEY_IDEMPOTENT, this.idempotent);
            resultObject.put(KEY_NAME, (Object)(this.name == null ? "" : this.name));
            if (this.result != null) {
                if (!this.result.isOK()) {
                    resultObject.put(KEY_FAILED, true);
                    resultObject.put(KEY_RESULT, (Object)ServerStatus.convert(this.result).toJSON());
                }
                if (this.result.getSeverity() == 8) {
                    resultObject.put(KEY_CANCELED, true);
                }
            }
        }
        catch (JSONException jSONException) {}
        return resultObject;
    }

    public JSONObject toJSON() {
        JSONObject resultObject = new JSONObject();
        try {
            resultObject.put(KEY_RUNNING, this.isRunning());
            resultObject.put(KEY_MESSAGE, (Object)this.getMessage());
            resultObject.put(KEY_ID, (Object)this.getTaskId());
            resultObject.put(KEY_USER, (Object)this.getUserId());
            resultObject.put(KEY_PERCENT_COMPLETE, this.getPercentComplete());
            resultObject.put(KEY_TIMESTAMP_MODIFIED, this.modified.getTime());
            resultObject.put(KEY_TIMESTAMP_CREATED, this.created.getTime());
            resultObject.put(KEY_CAN_BE_CANCELED, this.canBeCanceled);
            resultObject.put(KEY_IDEMPOTENT, this.idempotent);
            resultObject.put(KEY_NAME, (Object)(this.name == null ? "" : this.name));
            if (this.resultLocation != null) {
                resultObject.put(KEY_LOCATION, (Object)this.resultLocation);
            }
            if (this.result != null) {
                resultObject.put(KEY_RESULT, (Object)ServerStatus.convert(this.result).toJSON());
                if (!this.result.isOK()) {
                    resultObject.put(KEY_FAILED, true);
                }
                if (this.result.getSeverity() == 8) {
                    resultObject.put(KEY_CANCELED, true);
                }
            }
        }
        catch (JSONException jSONException) {}
        return resultObject;
    }

    public String toString() {
        return "TaskInfo" + this.toJSON();
    }
}

