/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Clone;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.eclipse.osgi.util.NLS;

public class CloneJob
extends GitJob {
    private final WebProject project;
    private final Clone clone;
    private final String user;

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, WebProject project) {
        super(NLS.bind((String)"Cloning {0}", (Object)clone.getUrl()), userRunningTask, NLS.bind((String)"Cloning {0}...", (Object)clone.getUrl()), false, false, (GitCredentialsProvider)credentials);
        this.clone = clone;
        this.user = user;
        this.project = project;
        this.setFinalLocation(URI.create(cloneLocation));
        this.setFinalMessage("Clone complete.");
    }

    private IStatus doClone() {
        try {
            File cloneFolder = new File(this.clone.getContentLocation().getPath());
            if (!cloneFolder.exists()) {
                cloneFolder.mkdir();
            }
            CloneCommand cc = Git.cloneRepository();
            cc.setBare(false);
            cc.setCredentialsProvider((CredentialsProvider)this.credentials);
            cc.setDirectory(cloneFolder);
            cc.setRemote("origin");
            cc.setURI(this.clone.getUrl());
            Git git = cc.call();
            this.setMessage(NLS.bind((String)"Configuring {0}...", (Object)this.clone.getUrl()));
            GitCloneHandlerV1.doConfigureClone(git, this.user);
            git.getRepository().close();
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (GitAPIException e) {
            return this.getGitAPIExceptionStatus(e, "Error cloning git repository");
        }
        catch (JGitInternalException e) {
            return this.getJGitInternalExceptionStatus(e, "Error cloning git repository");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected IStatus performJob() {
        IStatus result = this.doClone();
        if (result.isOK()) {
            return result;
        }
        try {
            if (this.project != null) {
                GitCloneHandlerV1.removeProject(this.user, this.project);
            } else {
                FileUtils.delete((File)URIUtil.toFile((URI)this.clone.getContentLocation()), (int)1);
            }
        }
        catch (IOException e) {
            String msg = "An error occured when cleaning up after a clone failure";
            result = new ServerStatus(4, 500, msg, (Throwable)e);
        }
        return result;
    }
}

