/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class LogJob
extends GitJob {
    private final LogCommand logCommand;
    private final Log log;

    public LogJob(String userRunningTask, LogCommand logCommand, Log log, URI logLocation) {
        super(NLS.bind((String)"Generating git log for {0}", (Object)logCommand.getRepository()), userRunningTask, NLS.bind((String)"Generating git log for {0} ...", (Object)logCommand.getRepository()), true, false);
        this.setFinalLocation(logLocation);
        this.setFinalMessage("Generating git log completed.");
        this.logCommand = logCommand;
        this.log = log;
    }

    protected IStatus performJob() {
        try {
            Iterable commits = this.logCommand.call();
            this.log.setCommits(commits);
            JSONObject result = this.log.toJSON();
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when generating log for ref {0}", (Object)this.logCommand.getRepository());
            return new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
        }
    }
}

