/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.net.URI;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.jobs.ListBranchesJob;
import org.eclipse.orion.server.git.objects.Branch;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class GitBranchHandlerV1
extends AbstractGitHandler {
    public static int PAGE_SIZE = 50;

    GitBranchHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected boolean handleGet(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String gitSegment = requestInfo.gitSegment;
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        IPath filePath = requestInfo.filePath;
        try {
            if (gitSegment == null) {
                ListBranchesJob job;
                String commits = request.getParameter("commits");
                int commitsNumber = commits == null ? 0 : Integer.parseInt(commits);
                String page = request.getParameter("page");
                if (page != null) {
                    int pageNo = Integer.parseInt(page);
                    int pageSize = request.getParameter("pageSize") == null ? PAGE_SIZE : Integer.parseInt(request.getParameter("pageSize"));
                    job = new ListBranchesJob(TaskJobHandler.getUserId((HttpServletRequest)request), filePath, BaseToCloneConverter.getCloneLocation(GitBranchHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH_LIST), commitsNumber, pageNo, pageSize, request.getRequestURI());
                } else {
                    job = new ListBranchesJob(TaskJobHandler.getUserId((HttpServletRequest)request), filePath, BaseToCloneConverter.getCloneLocation(GitBranchHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH_LIST), commitsNumber);
                }
                return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, (ServletResourceHandler)this.statusHandler);
            }
            List branches = new Git(db).branchList().call();
            JSONObject result = null;
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitBranchHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH);
            for (Ref ref : branches) {
                if (!Repository.shortenRefName((String)ref.getName()).equals(gitSegment)) continue;
                result = new Branch(cloneLocation, db, ref).toJSON();
                break;
            }
            if (result == null) {
                String msg = NLS.bind((String)"Branch {0} not found", (Object)gitSegment);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
            }
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, result);
            return true;
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when looking for a branch.", (Throwable)e));
        }
    }

    @Override
    protected boolean handlePost(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        IPath filePath;
        HttpServletResponse response;
        HttpServletRequest request;
        block6: {
            String gitSegment = requestInfo.gitSegment;
            request = requestInfo.request;
            response = requestInfo.response;
            Repository db = requestInfo.db;
            filePath = requestInfo.filePath;
            JSONObject toCreate = requestInfo.getJSONRequest();
            try {
                if (gitSegment != null) break block6;
                String branchName = toCreate.optString("Name", null);
                String startPoint = toCreate.optString("Branch", null);
                if (branchName == null || branchName.isEmpty()) {
                    if (startPoint == null || startPoint.isEmpty()) {
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Branch name must be provided", null));
                    }
                    String shortName = Repository.shortenRefName((String)startPoint);
                    branchName = shortName.substring(shortName.lastIndexOf("/") + 1);
                }
                CreateBranchCommand cc = new Git(db).branchCreate();
                cc.setName(branchName);
                if (startPoint != null && !startPoint.isEmpty()) {
                    cc.setStartPoint(startPoint);
                    cc.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
                }
                Ref ref = cc.call();
                URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitBranchHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH_LIST);
                JSONObject result = new Branch(cloneLocation, db, ref).toJSON();
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                response.setHeader("Location", result.getString("Location"));
                response.setStatus(201);
                return true;
            }
            catch (Exception e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when creating a branch.", (Throwable)e));
            }
        }
        String msg = NLS.bind((String)"Failed to create a branch for {0}", (Object)filePath);
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
    }

    @Override
    protected boolean handleDelete(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String gitSegment = requestInfo.gitSegment;
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Git git = requestInfo.git;
        try {
            if (gitSegment != null) {
                DeleteBranchCommand cc = git.branchDelete();
                cc.setBranchNames(new String[]{gitSegment});
                cc.setForce(true);
                cc.call();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when removing a branch.", (Throwable)e));
        }
    }
}

