/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.ConfigOption;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class GitConfigHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitConfigHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            switch (GitConfigHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleGet(request, response, path);
                }
                case POST: {
                    return this.handlePost(request, response, path);
                }
                case PUT: {
                    return this.handlePut(request, response, path);
                }
                case DELETE: {
                    return this.handleDelete(request, response, path);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to process an operation on commits for {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, ConfigInvalidException {
        Path p = new Path(path);
        URI baseLocation = GitConfigHandlerV1.getURI((HttpServletRequest)request);
        if (p.segment(0).equals("clone") && p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(1)), null));
            }
            FileRepository db = new FileRepository(gitDir);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.CONFIG);
            ConfigOption configOption = new ConfigOption(cloneLocation, (Repository)db);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)configOption.toJSON());
            return true;
        }
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(2)), null));
            }
            FileRepository db = new FileRepository(gitDir);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.CONFIG_OPTION);
            try {
                ConfigOption configOption = new ConfigOption(cloneLocation, (Repository)db, p.segment(0));
                if (!configOption.exists()) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, "There is no config entry with key provided", null));
                }
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)configOption.toJSON());
                return true;
            }
            catch (IllegalArgumentException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
            }
        }
        return false;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, JSONException, ServletException, URISyntaxException, ConfigInvalidException {
        Path p = new Path(path);
        if (p.segment(0).equals("clone") && p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(1)), null));
            }
            FileRepository db = new FileRepository(gitDir);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitConfigHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.CONFIG);
            JSONObject toPost = OrionServlet.readJSONRequest((HttpServletRequest)request);
            String key = toPost.optString("Key", null);
            if (key == null || key.isEmpty()) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry key must be provided", null));
            }
            String value = toPost.optString("Value", null);
            if (value == null || value.isEmpty()) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry value must be provided", null));
            }
            try {
                ConfigOption configOption = new ConfigOption(cloneLocation, (Repository)db, key);
                boolean present = configOption.exists();
                if (present) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 409, NLS.bind((String)"Config entry for {0} already exists", (Object)key), null));
                }
                GitConfigHandlerV1.save(configOption, value);
                JSONObject result = configOption.toJSON();
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                response.setHeader("Location", result.getString("Location"));
                response.setStatus(201);
                return true;
            }
            catch (IllegalArgumentException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
            }
        }
        return false;
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, JSONException, ServletException, URISyntaxException, ConfigInvalidException {
        Path p = new Path(path);
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            String value;
            ConfigOption configOption;
            block6: {
                File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
                if (gitDir == null) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(2)), null));
                }
                FileRepository db = new FileRepository(gitDir);
                URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitConfigHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.CONFIG_OPTION);
                try {
                    configOption = new ConfigOption(cloneLocation, (Repository)db, p.segment(0));
                    JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
                    value = toPut.optString("Value", null);
                    if (value == null || value.isEmpty()) {
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry value must be provided", null));
                    }
                    if (configOption.exists()) break block6;
                    response.setStatus(404);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
                }
            }
            GitConfigHandlerV1.save(configOption, value);
            JSONObject result = configOption.toJSON();
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            response.setHeader("Location", result.getString("Location"));
            return true;
        }
        return false;
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, ServletException, ConfigInvalidException, URISyntaxException {
        Path p = new Path(path);
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(2)), null));
            }
            FileRepository db = new FileRepository(gitDir);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitConfigHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.CONFIG_OPTION);
            try {
                ConfigOption configOption = new ConfigOption(cloneLocation, (Repository)db, p.segment(0));
                if (configOption.exists()) {
                    GitConfigHandlerV1.delete(configOption);
                    response.setStatus(200);
                } else {
                    response.setStatus(404);
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
            }
        }
        return false;
    }

    private static void save(ConfigOption co, String value) throws IOException {
        co.getConfig().setString(co.getSection(), co.getSubsection(), co.getName(), value);
        co.getConfig().save();
    }

    private static void delete(ConfigOption co) throws IOException {
        co.getConfig().unset(co.getSection(), co.getSubsection(), co.getName());
        co.getConfig().save();
    }
}

