/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.jsch;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;

public class LazyKnownHosts
implements HostKeyRepository {
    private HostKeyRepository repo;
    private String lastUnknownHost = null;
    private byte[] lastUnknownKey = null;
    private int lastStatus = 0;

    LazyKnownHosts(JSch jsch, String knownHosts) throws JSchException {
        if (knownHosts != null) {
            try {
                StringBufferInputStream in = new StringBufferInputStream(knownHosts);
                try {
                    jsch.setKnownHosts((InputStream)in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.repo = jsch.getHostKeyRepository();
    }

    public int check(String host, byte[] key) {
        this.lastStatus = this.repo.check(host, key);
        if (this.lastStatus != 0) {
            this.lastUnknownHost = host;
            this.lastUnknownKey = key;
        } else {
            this.lastUnknownHost = null;
            this.lastUnknownKey = null;
        }
        return this.lastStatus;
    }

    public void add(HostKey hostkey, UserInfo ui) {
        this.repo.add(hostkey, ui);
    }

    public void remove(String host, String type) {
        this.repo.remove(host, type);
    }

    public void remove(String host, String type, byte[] key) {
        this.repo.remove(host, type, key);
    }

    public String getKnownHostsRepositoryID() {
        return "LAZY_" + this.repo.getKnownHostsRepositoryID();
    }

    public HostKey[] getHostKey() {
        return this.repo.getHostKey();
    }

    public HostKey[] getHostKey(String host, String type) {
        return this.repo.getHostKey();
    }

    public String getLastUnknownkedHost() {
        return this.lastUnknownHost;
    }

    public byte[] getLastUnknownKey() {
        return this.lastUnknownKey;
    }

    public int getLastStatus() {
        return this.lastStatus;
    }
}

