/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private boolean createBranch = false;
    private CreateBranchCommand.SetupUpstreamMode upstreamMode;
    private String startPoint = null;
    private RevCommit startCommit;
    private CheckoutResult status;
    private List<String> paths = new LinkedList<String>();
    private boolean checkoutAllPaths;

    protected CheckoutCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref call() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException {
        this.checkCallable();
        this.processOptions();
        try {
            RefUpdate.Result updateResult;
            DirCacheCheckout dco;
            if (this.checkoutAllPaths || !this.paths.isEmpty()) {
                this.checkoutPaths();
                this.status = new CheckoutResult(CheckoutResult.Status.OK, this.paths);
                this.setCallable(false);
                Ref ref = null;
                return ref;
            }
            if (this.createBranch) {
                Git git = new Git(this.repo);
                CreateBranchCommand command = git.branchCreate();
                command.setName(this.name);
                command.setStartPoint(this.getStartPoint().name());
                if (this.upstreamMode != null) {
                    command.setUpstreamMode(this.upstreamMode);
                }
                command.call();
            }
            Ref headRef = this.repo.getRef("HEAD");
            String shortHeadRef = this.getShortBranchName(headRef);
            String refLogMessage = "checkout: moving from " + shortHeadRef;
            ObjectId branch = this.repo.resolve(this.name);
            if (branch == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.name));
            }
            RevWalk revWalk = new RevWalk(this.repo);
            ObjectId headId = headRef.getObjectId();
            RevCommit headCommit = headId == null ? null : revWalk.parseCommit(headId);
            RevCommit newCommit = revWalk.parseCommit(branch);
            RevTree headTree = headCommit == null ? null : headCommit.getTree();
            DirCache dc = this.repo.lockDirCache();
            try {
                dco = new DirCacheCheckout(this.repo, headTree, dc, newCommit.getTree());
                dco.setFailOnConflict(true);
                try {
                    dco.checkout();
                }
                catch (org.eclipse.jgit.errors.CheckoutConflictException e) {
                    this.status = new CheckoutResult(CheckoutResult.Status.CONFLICTS, dco.getConflicts());
                    throw new CheckoutConflictException(dco.getConflicts(), e);
                }
            }
            finally {
                dc.unlock();
            }
            Ref ref = this.repo.getRef(this.name);
            if (ref != null && !ref.getName().startsWith("refs/heads/")) {
                ref = null;
            }
            String toName = Repository.shortenRefName(this.name);
            RefUpdate refUpdate = this.repo.updateRef("HEAD", ref == null);
            refUpdate.setForceUpdate(this.force);
            refUpdate.setRefLogMessage(refLogMessage + " to " + toName, false);
            if (ref != null) {
                updateResult = refUpdate.link(ref.getName());
            } else {
                refUpdate.setNewObjectId(newCommit);
                updateResult = refUpdate.forceUpdate();
            }
            this.setCallable(false);
            boolean ok = false;
            switch (updateResult) {
                case NEW: {
                    ok = true;
                    break;
                }
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    ok = true;
                    break;
                }
            }
            if (!ok) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, updateResult.name()));
            }
            this.status = !dco.getToBeDeleted().isEmpty() ? new CheckoutResult(CheckoutResult.Status.NONDELETED, dco.getToBeDeleted()) : new CheckoutResult(new ArrayList<String>(dco.getUpdated().keySet()), dco.getRemoved());
            Ref ref2 = ref;
            return ref2;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        finally {
            if (this.status == null) {
                this.status = CheckoutResult.ERROR_RESULT;
            }
        }
    }

    private String getShortBranchName(Ref headRef) {
        if (headRef.getTarget().getName().equals(headRef.getName())) {
            return headRef.getTarget().getObjectId().getName();
        }
        return Repository.shortenRefName(headRef.getTarget().getName());
    }

    public CheckoutCommand addPath(String path) {
        this.checkCallable();
        this.paths.add(path);
        return this;
    }

    public CheckoutCommand setAllPaths(boolean all) {
        this.checkoutAllPaths = all;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckoutCommand checkoutPaths() throws IOException, RefNotFoundException {
        RevWalk revWalk = new RevWalk(this.repo);
        DirCache dc = this.repo.lockDirCache();
        try {
            boolean checkoutIndex;
            DirCacheEditor editor = dc.editor();
            TreeWalk startWalk = new TreeWalk(revWalk.getObjectReader());
            startWalk.setRecursive(true);
            if (!this.checkoutAllPaths) {
                startWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            boolean bl = checkoutIndex = this.startCommit == null && this.startPoint == null;
            if (!checkoutIndex) {
                startWalk.addTree(revWalk.parseCommit(this.getStartPoint()).getTree());
            } else {
                startWalk.addTree(new DirCacheIterator(dc));
            }
            final File workTree = this.repo.getWorkTree();
            final ObjectReader r = this.repo.getObjectDatabase().newReader();
            try {
                while (startWalk.next()) {
                    final ObjectId blobId = startWalk.getObjectId(0);
                    final FileMode mode = startWalk.getFileMode(0);
                    editor.add(new DirCacheEditor.PathEdit(startWalk.getPathString()){

                        public void apply(DirCacheEntry ent) {
                            if (checkoutIndex && ent.getStage() > 0) {
                                UnmergedPathException e = new UnmergedPathException(ent);
                                throw new JGitInternalException(e.getMessage(), e);
                            }
                            ent.setObjectId(blobId);
                            ent.setFileMode(mode);
                            File file = new File(workTree, ent.getPathString());
                            File parentDir = file.getParentFile();
                            try {
                                FileUtils.mkdirs(parentDir, true);
                                DirCacheCheckout.checkoutEntry(CheckoutCommand.this.repo, file, ent, r);
                            }
                            catch (IOException e) {
                                throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, ent.getPathString()), e);
                            }
                        }
                    });
                }
                editor.commit();
            }
            finally {
                startWalk.release();
                r.release();
            }
        }
        finally {
            dc.unlock();
            revWalk.release();
        }
        return this;
    }

    private ObjectId getStartPoint() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        ObjectId result = null;
        result = this.repo.resolve(this.startPoint == null ? "HEAD" : this.startPoint);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.startPoint != null ? this.startPoint : "HEAD"));
        }
        return result;
    }

    private void processOptions() throws InvalidRefNameException {
        if (!(this.checkoutAllPaths || !this.paths.isEmpty() || this.name != null && Repository.isValidRefName("refs/heads/" + this.name))) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
    }

    public CheckoutCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public CheckoutCommand setCreateBranch(boolean createBranch) {
        this.checkCallable();
        this.createBranch = createBranch;
        return this;
    }

    public CheckoutCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public CheckoutCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        return this;
    }

    public CheckoutCommand setStartPoint(RevCommit startCommit) {
        this.checkCallable();
        this.startCommit = startCommit;
        this.startPoint = null;
        return this;
    }

    public CheckoutCommand setUpstreamMode(CreateBranchCommand.SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    public CheckoutResult getResult() {
        if (this.status == null) {
            return CheckoutResult.NOT_TRIED_RESULT;
        }
        return this.status;
    }
}

