/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.user.securestorage;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;

public class SecureStorageUserProfileNode
implements IOrionUserProfileNode {
    private ISecurePreferences node;

    public SecureStorageUserProfileNode(ISecurePreferences node) {
        this.node = node;
    }

    public void put(String key, String value, boolean encrypt) throws CoreException {
        try {
            this.node.put(key, value, encrypt);
        }
        catch (StorageException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", "Can not store the user profile", (Throwable)e));
        }
    }

    public String get(String key, String def) throws CoreException {
        block3: {
            try {
                if (!this.node.isEncrypted(key)) break block3;
                return "";
            }
            catch (StorageException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", "Can not read the user profile", (Throwable)e));
            }
        }
        return this.node.get(key, def);
    }

    public void remove(String key) {
        this.node.remove(key);
    }

    public String[] keys() {
        return this.node.keys();
    }

    public IOrionUserProfileNode getUserProfileNode(String pathName) {
        return new SecureStorageUserProfileNode(this.node.node(pathName));
    }

    public boolean userProfileNodeExists(String pathName) {
        return this.node.nodeExists(pathName);
    }

    public void removeUserProfileNode() {
        this.node.removeNode();
    }

    public String[] childrenNames() {
        return this.node.childrenNames();
    }

    public void flush() throws CoreException {
        try {
            this.node.flush();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", "Can not store the user profile", (Throwable)e));
        }
    }
}

