/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.objects.Branch;
import org.eclipse.orion.server.git.objects.Commit;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Remote;
import org.eclipse.orion.server.git.objects.RemoteBranch;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Commit")
public class Log
extends GitObject {
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private List<RevCommit> commits;
    private String pattern;
    private Ref toRefId;
    private Ref fromRefId;
    private int page;
    private int pageSize;

    public Log(URI cloneLocation, Repository db, Iterable<RevCommit> commits, String pattern, Ref toRefId, Ref fromRefId) {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Children"), new Property("RepositoryPath"), new Property("toRef"), new Property("fromRef"), new Property("PreviousLocation"), new Property("NextLocation")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.commits = commits != null ? Log.toList(commits) : Collections.emptyList();
        this.pattern = pattern;
        this.toRefId = toRefId;
        this.fromRefId = fromRefId;
    }

    public void setCommits(Iterable<RevCommit> commits) {
        this.commits = Log.toList(commits);
    }

    private static <E> List<E> toList(Iterable<E> iterable) {
        ArrayList<E> list = new ArrayList<E>();
        for (E item : iterable) {
            list.add(item);
        }
        return list;
    }

    public void setPaging(int page, int pageSize) {
        this.page = page;
        this.pageSize = pageSize;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        Assert.isNotNull(this.commits, (String)"'commits' is null");
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Children")
    private JSONArray getChildren() throws GitAPIException, JSONException, URISyntaxException, IOException, CoreException {
        Map<ObjectId, JSONArray> commitToBranchMap = Log.getCommitToBranchMap(this.cloneLocation, this.db);
        JSONArray children = new JSONArray();
        int i = 0;
        for (RevCommit revCommit : this.commits) {
            Commit commit = new Commit(this.cloneLocation, this.db, revCommit, this.pattern);
            commit.setCommitToBranchMap(commitToBranchMap);
            children.put((Object)commit.toJSON());
            if (i++ == this.pageSize - 1) break;
        }
        return children;
    }

    @PropertyDescription(name="RepositoryPath")
    private String getRepositoryPath() {
        return this.pattern == null ? "" : this.pattern;
    }

    @PropertyDescription(name="toRef")
    private JSONObject getToRef() throws JSONException, URISyntaxException, IOException, CoreException {
        if (this.toRefId != null) {
            return this.createJSONObjectForRef(this.toRefId.getTarget());
        }
        return null;
    }

    @PropertyDescription(name="fromRef")
    private JSONObject getFromRef() throws JSONException, URISyntaxException, IOException, CoreException {
        if (this.fromRefId != null) {
            return this.createJSONObjectForRef(this.fromRefId.getTarget());
        }
        return null;
    }

    @PropertyDescription(name="PreviousLocation")
    private URI getPreviousPageLocation() throws URISyntaxException {
        if (this.page > 0) {
            StringBuilder c = new StringBuilder("");
            if (this.fromRefId != null) {
                c.append(this.fromRefId.getName());
            }
            if (this.fromRefId != null && this.toRefId != null) {
                c.append("..");
            }
            if (this.toRefId != null) {
                c.append(Repository.shortenRefName((String)this.toRefId.getName()));
            }
            if (this.page > 1) {
                return BaseToCommitConverter.getCommitLocation(this.cloneLocation, c.toString(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2.setQuery(String.format("page=%d&pageSize=%d", this.page - 1, this.pageSize)));
            }
        }
        return null;
    }

    @PropertyDescription(name="NextLocation")
    private URI getNextPageLocation() throws URISyntaxException {
        if (this.hasNextPage()) {
            StringBuilder c = new StringBuilder("");
            if (this.fromRefId != null) {
                c.append(this.fromRefId.getName());
            }
            if (this.fromRefId != null && this.toRefId != null) {
                c.append("..");
            }
            if (this.toRefId != null) {
                c.append(Repository.shortenRefName((String)this.toRefId.getName()));
            }
            return BaseToCommitConverter.getCommitLocation(this.cloneLocation, c.toString(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2.setQuery(String.format("page=%d&pageSize=%d", this.page + 1, this.pageSize)));
        }
        return null;
    }

    private boolean hasNextPage() {
        return this.commits.size() > this.pageSize;
    }

    private JSONObject createJSONObjectForRef(Ref targetRef) throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject result = null;
        String name = targetRef.getName();
        if (name.startsWith("refs/heads/")) {
            result = new Branch(this.cloneLocation, this.db, targetRef).toJSON();
        } else if (name.startsWith("refs/remotes/")) {
            Remote remote = this.findRemote(name);
            String remoteBranchName = this.computeRemoteBranchName(name, remote);
            result = new RemoteBranch(this.cloneLocation, this.db, remote, remoteBranchName).toJSON();
        }
        Assert.isNotNull(result, (String)NLS.bind((String)"Unexpected target Ref: {0}", (Object)name));
        return result;
    }

    private Remote findRemote(String refName) throws URISyntaxException {
        Assert.isLegal((boolean)refName.startsWith("refs/remotes/"), (String)NLS.bind((String)"Expected Ref starting with {0} was {1}", (Object)"refs/remotes/", (Object)refName));
        IPath remoteNameCandidate = new Path(refName).removeFirstSegments(2);
        List remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.getConfig());
        int i = 1;
        while (i < remoteNameCandidate.segmentCount()) {
            for (RemoteConfig remoteConfig : remoteConfigs) {
                IPath uptoSegment = remoteNameCandidate.uptoSegment(i);
                if (!remoteConfig.getName().equals(uptoSegment.toString())) continue;
                return new Remote(this.cloneLocation, this.db, remoteConfig.getName());
            }
            ++i;
        }
        Assert.isTrue((boolean)false, (String)NLS.bind((String)"Could not find Remote for {0}", (Object)refName));
        return null;
    }

    private String computeRemoteBranchName(String targetRefName, Remote remote) {
        String prefix = "refs/remotes/" + remote.getName() + "/";
        return targetRefName.substring(prefix.length());
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        StringBuilder c = new StringBuilder();
        if (this.fromRefId != null) {
            c.append(this.fromRefId.getName());
        }
        if (this.fromRefId != null && this.toRefId != null) {
            c.append("..");
        }
        if (this.toRefId != null) {
            c.append(this.toRefId.getName());
        }
        return BaseToCommitConverter.getCommitLocation(this.cloneLocation, GitUtils.encode(c.toString()), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2);
    }

    static Map<ObjectId, JSONArray> getCommitToBranchMap(URI cloneLocation, Repository db) throws GitAPIException, JSONException {
        HashMap<ObjectId, JSONArray> commitToBranch = new HashMap<ObjectId, JSONArray>();
        Git git = new Git(db);
        List branchRefs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        for (Ref branchRef : branchRefs) {
            ObjectId commitId = branchRef.getLeaf().getObjectId();
            JSONObject branch = new JSONObject();
            branch.put("FullName", (Object)branchRef.getName());
            JSONArray branchesArray = commitToBranch.get(commitId);
            if (branchesArray != null) {
                branchesArray.put((Object)branch);
                continue;
            }
            branchesArray = new JSONArray();
            branchesArray.put((Object)branch);
            commitToBranch.put(commitId, branchesArray);
        }
        return commitToBranch;
    }
}

