/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.ServletFileStoreHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;

public class NewFileServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private ServletResourceHandler<IFileStore> fileSerializer;
    private final URI rootStoreURI = Activator.getDefault().getRootLocationURI();

    public void init() throws ServletException {
        super.init();
        this.fileSerializer = new ServletFileStoreHandler(this.rootStoreURI, this.getStatusHandler(), this.getServletContext());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path path;
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path2 = path = pathInfo == null ? Path.ROOT : new Path(pathInfo);
        if (path.segmentCount() > 0 && ".metadata".equals(path.segment(0))) {
            this.handleException(resp, (IStatus)new ServerStatus(4, 403, NLS.bind((String)"Forbidden: {0}", (Object)path), null));
            return;
        }
        IFileStore file = NewFileServlet.getFileStore((IPath)path);
        if (file == null) {
            this.handleException(resp, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"File not found: {0}", (Object)path), null));
            return;
        }
        if (this.fileSerializer.handleRequest(req, resp, file)) {
            return;
        }
        super.doGet(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public static IFileStore getFileStore(IPath path) {
        if (path.segmentCount() <= 1) {
            return null;
        }
        WebWorkspace workspace = WebWorkspace.fromId(path.segment(0));
        WebProject project = workspace.getProjectByName(path.segment(1));
        if (project == null) {
            return null;
        }
        try {
            return project.getProjectStore().getFileStore(path.removeFirstSegments(2));
        }
        catch (CoreException e) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.servlets", 1, NLS.bind((String)"An error occurred when getting file store for path {0}", (Object)path), (Throwable)e));
            return null;
        }
    }
}

