/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.task;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskNonotificationRegistry;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskDoesNotExistException;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.core.tasks.TaskOperationException;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    public static final int LONGPOLLING_WAIT_TIME = 60000;
    public static final String KEY_RUNNING_ONLY = "RunningOnly";
    ServiceTracker<ITaskService, ITaskService> taskTracker;
    TaskNonotificationRegistry notificationRegistry;

    public TaskServlet() {
        this.initTaskService();
    }

    private void initTaskService() {
        this.taskTracker = new ServiceTracker(Activator.bundleContext, ITaskService.class, null);
        this.taskTracker.open();
        this.notificationRegistry = new TaskNonotificationRegistry(this, (ITaskService)this.taskTracker.getService());
    }

    @Override
    protected void handleException(HttpServletResponse resp, String msg, Exception e) throws ServletException {
        super.handleException(resp, msg, e);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        Path path = pathInfo == null ? Path.EMPTY : new Path(pathInfo);
        ITaskService taskService = (ITaskService)this.taskTracker.getService();
        if (path.segmentCount() == 0) {
            taskService.removeCompletedTasks(TaskJobHandler.getUserId(req));
            return;
        }
        if (path.segmentCount() != 2 || !"id".equals(path.segment(0))) {
            this.handleException(resp, "Invalid request path: " + path, null, 400);
            return;
        }
        String taskId = path.segment(1);
        try {
            taskService.removeTask(TaskJobHandler.getUserId(req), taskId);
        }
        catch (TaskDoesNotExistException e) {
            this.handleException(resp, "Could not remove task that does not exist: " + e.getTaskId(), (Exception)((Object)e), 404);
            return;
        }
        catch (TaskOperationException e) {
            this.handleException(resp, e.getMessage(), (Exception)((Object)e));
            return;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path path;
        String pathInfo = req.getPathInfo();
        Path path2 = path = pathInfo == null ? Path.EMPTY : new Path(pathInfo);
        if (path.segmentCount() != 2 || !"id".equals(path.segment(0))) {
            this.handleException(resp, "Invalid request path: " + path, null, 400);
            return;
        }
        ITaskService taskService = (ITaskService)this.taskTracker.getService();
        try {
            JSONObject putData = OrionServlet.readJSONRequest(req);
            if (putData.getBoolean("Cancel")) {
                String taskId = path.segment(1);
                TaskInfo task = taskService.getTask(TaskJobHandler.getUserId(req), taskId);
                if (task == null) {
                    this.handleException(resp, (IStatus)new ServerStatus(4, 404, "Task " + taskId + " does not exist", null));
                    return;
                }
                taskService.cancelTask(task);
            }
        }
        catch (JSONException e) {
            this.handleException(resp, "Could not read request", (Exception)((Object)e));
        }
        catch (TaskOperationException e) {
            this.handleException(resp, "Task does not support canceling", (Exception)((Object)e), 400);
        }
    }

    public JSONObject getTasksList(Collection<TaskInfo> tasks, Date timestamp, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, JSONException, URISyntaxException {
        return this.getTasksList(tasks, new ArrayList<String>(), timestamp, req, resp);
    }

    public JSONObject getTasksList(Collection<TaskInfo> tasks, Collection<String> deletedTasks, Date timestamp, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, JSONException, URISyntaxException {
        JSONObject result = new JSONObject();
        JSONArray tasksList = new JSONArray();
        for (TaskInfo task : tasks) {
            JSONObject taskJson;
            if ("true".equals(req.getParameter("results"))) {
                taskJson = task.toJSON();
                if (taskJson.optString("Location", "").equals("")) {
                    taskJson.put("Location", (Object)new URI(String.valueOf(TaskServlet.getURI(req).toString()) + "/").resolve("id/" + task.getTaskId()).toString());
                }
                tasksList.put((Object)taskJson);
                continue;
            }
            taskJson = task.toLightJSON();
            if (taskJson.optString("Location", "").equals("")) {
                taskJson.put("Location", (Object)new URI(String.valueOf(TaskServlet.getURI(req).toString()) + "/").resolve("id/" + task.getTaskId()).toString());
            }
            tasksList.put((Object)taskJson);
        }
        result.put("DeletedChildren", deletedTasks);
        result.put("Children", (Object)tasksList);
        result.put("LocalTimeStamp", timestamp.getTime());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        Path path = pathInfo == null ? Path.EMPTY : new Path(pathInfo);
        ITaskService taskService = (ITaskService)this.taskTracker.getService();
        if (path.segmentCount() == 0) {
            boolean runningOnly = "true".equals(req.getParameter(KEY_RUNNING_ONLY));
            if ("true".equals(req.getParameter("Longpolling"))) {
                if (req.getParameter("LongpollingId") == null) {
                    Date modifiedFrom = null;
                    Date timestamp = new Date();
                    try {
                        modifiedFrom = new Date(Long.parseLong(req.getParameter("LocalTimeStamp")));
                    }
                    catch (Exception exception) {}
                    List tasks = taskService.getTasks(TaskJobHandler.getUserId(req), modifiedFrom, runningOnly);
                    try {
                        JSONObject result = this.getTasksList(tasks, timestamp, req, resp);
                        result.put("LongpollingId", (Object)new UniversalUniqueIdentifier().toBase64String());
                        resp.setStatus(202);
                        TaskServlet.writeJSONResponse(req, resp, result);
                        this.notificationRegistry.setLastNotification(result.getString("LongpollingId"), timestamp, TaskJobHandler.getUserId(req));
                        return;
                    }
                    catch (JSONException e) {
                        this.handleException(resp, e.getMessage(), (Exception)((Object)e));
                        return;
                    }
                    catch (URISyntaxException e) {
                        this.handleException(resp, e.getMessage(), e);
                        return;
                    }
                }
                String longpollingId = req.getParameter("LongpollingId");
                Job job = this.notificationRegistry.addListener(longpollingId, req, resp, TaskJobHandler.getUserId(req));
                final Object jobIsDone = new Object();
                JobChangeAdapter jobListener = new JobChangeAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(IJobChangeEvent event) {
                        Object object = jobIsDone;
                        synchronized (object) {
                            jobIsDone.notify();
                        }
                    }
                };
                job.addJobChangeListener((IJobChangeListener)jobListener);
                try {
                    Object object = jobIsDone;
                    synchronized (object) {
                        if (job.getState() != 0) {
                            jobIsDone.wait(60000L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
                job.removeJobChangeListener((IJobChangeListener)jobListener);
                if (job.getResult() == null) {
                    job.cancel();
                } else if (!job.getResult().isOK()) {
                    this.handleException(resp, job.getResult());
                }
                return;
            }
            Date timestamp = new Date();
            Date modifiedFrom = null;
            try {
                modifiedFrom = new Date(Long.parseLong(req.getParameter("LocalTimeStamp")));
            }
            catch (Exception exception) {}
            List tasks = taskService.getTasks(TaskJobHandler.getUserId(req), modifiedFrom, runningOnly);
            try {
                TaskServlet.writeJSONResponse(req, resp, this.getTasksList(tasks, timestamp, req, resp));
            }
            catch (JSONException e) {
                this.handleException(resp, e.getMessage(), (Exception)((Object)e));
                return;
            }
            catch (URISyntaxException e) {
                this.handleException(resp, e.getMessage(), e);
                return;
            }
            return;
        }
        if (path.segmentCount() != 2 || !"id".equals(path.segment(0))) {
            this.handleException(resp, "Invalid request path: " + path, null, 400);
            return;
        }
        if (taskService == null) {
            this.handleException(resp, "Task service is unavailable", null);
            return;
        }
        String taskId = path.segment(1);
        TaskInfo task = taskService.getTask(TaskJobHandler.getUserId(req), taskId);
        if (task == null) {
            this.handleException(resp, "Task not found: " + taskId, null, 404);
            return;
        }
        JSONObject result = task.toJSON();
        try {
            if (result.optString("Location", "").equals("")) {
                result.put("Location", (Object)TaskServlet.getURI(req).toString());
            }
        }
        catch (JSONException e) {
            this.handleException(resp, e.getMessage(), (Exception)((Object)e));
        }
        TaskServlet.writeJSONResponse(req, resp, result);
    }
}

