/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.jaspell;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.spell.SortedIterator;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.UnsortedTermFreqIteratorWrapper;
import org.apache.lucene.search.suggest.jaspell.JaspellTernarySearchTrie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaspellLookup
extends Lookup {
    JaspellTernarySearchTrie trie = new JaspellTernarySearchTrie();
    private boolean usePrefix = true;
    private int editDistance = 2;
    public static final String FILENAME = "jaspell.dat";
    private static final byte LO_KID = 1;
    private static final byte EQ_KID = 2;
    private static final byte HI_KID = 4;
    private static final byte HAS_VALUE = 8;

    @Override
    public void build(TermFreqIterator tfit) throws IOException {
        if (tfit instanceof SortedIterator) {
            tfit = new UnsortedTermFreqIteratorWrapper(tfit);
        }
        this.trie = new JaspellTernarySearchTrie();
        this.trie.setMatchAlmostDiff(this.editDistance);
        while (tfit.hasNext()) {
            String key = (String)tfit.next();
            float freq = tfit.freq();
            if (key.length() == 0) continue;
            this.trie.put(key, new Float(freq));
        }
    }

    @Override
    public boolean add(String key, Object value) {
        this.trie.put(key, value);
        return false;
    }

    @Override
    public Object get(String key) {
        return this.trie.get(key);
    }

    @Override
    public List<Lookup.LookupResult> lookup(String key, boolean onlyMorePopular, int num) {
        ArrayList<Lookup.LookupResult> res = new ArrayList<Lookup.LookupResult>();
        int count = onlyMorePopular ? num * 2 : num;
        List<String> list = this.usePrefix ? this.trie.matchPrefix(key, count) : this.trie.matchAlmost(key, count);
        if (list == null || list.size() == 0) {
            return res;
        }
        int maxCnt = Math.min(num, list.size());
        if (onlyMorePopular) {
            Lookup.LookupPriorityQueue queue = new Lookup.LookupPriorityQueue(num);
            for (String s : list) {
                float freq = ((Float)this.trie.get(s)).floatValue();
                queue.insertWithOverflow(new Lookup.LookupResult(s, freq));
            }
            for (Lookup.LookupResult lr : queue.getResults()) {
                res.add(lr);
            }
        } else {
            for (int i = 0; i < maxCnt; ++i) {
                String s = list.get(i);
                float freq = ((Float)this.trie.get(s)).floatValue();
                res.add(new Lookup.LookupResult(s, freq));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(File storeDir) throws IOException {
        File data = new File(storeDir, FILENAME);
        if (!data.exists() || !data.canRead()) {
            return false;
        }
        DataInputStream in = new DataInputStream(new FileInputStream(data));
        JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
        jaspellTernarySearchTrie.getClass();
        JaspellTernarySearchTrie.TSTNode root = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', null);
        try {
            this.readRecursively(in, root);
            this.trie.setRoot(root);
        }
        finally {
            in.close();
        }
        return true;
    }

    private void readRecursively(DataInputStream in, JaspellTernarySearchTrie.TSTNode node) throws IOException {
        JaspellTernarySearchTrie.TSTNode kid;
        node.splitchar = in.readChar();
        byte mask = in.readByte();
        if ((mask & 8) != 0) {
            node.data = new Float(in.readFloat());
        }
        if ((mask & 1) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[1] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
        if ((mask & 2) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[2] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
        if ((mask & 4) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[3] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(File storeDir) throws IOException {
        if (!(storeDir.exists() && storeDir.isDirectory() && storeDir.canWrite())) {
            return false;
        }
        JaspellTernarySearchTrie.TSTNode root = this.trie.getRoot();
        if (root == null) {
            return false;
        }
        File data = new File(storeDir, FILENAME);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(data));
        try {
            this.writeRecursively(out, root);
            out.flush();
        }
        finally {
            out.close();
        }
        return true;
    }

    private void writeRecursively(DataOutputStream out, JaspellTernarySearchTrie.TSTNode node) throws IOException {
        if (node == null) {
            return;
        }
        out.writeChar(node.splitchar);
        byte mask = 0;
        if (node.relatives[1] != null) {
            mask = (byte)(mask | 1);
        }
        if (node.relatives[2] != null) {
            mask = (byte)(mask | 2);
        }
        if (node.relatives[3] != null) {
            mask = (byte)(mask | 4);
        }
        if (node.data != null) {
            mask = (byte)(mask | 8);
        }
        out.writeByte(mask);
        if (node.data != null) {
            out.writeFloat(((Float)node.data).floatValue());
        }
        this.writeRecursively(out, node.relatives[1]);
        this.writeRecursively(out, node.relatives[2]);
        this.writeRecursively(out, node.relatives[3]);
    }
}

