/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.PackInputStream;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.storage.pack.BinaryDelta;
import org.eclipse.jgit.storage.pack.DeltaStream;
import org.eclipse.jgit.util.io.TeeInputStream;

class LargePackedDeltaObject
extends ObjectLoader {
    private static final long SIZE_UNKNOWN = -1L;
    private int type = -1;
    private long size = -1L;
    private final long objectOffset;
    private final long baseOffset;
    private final int headerLength;
    private final PackFile pack;
    private final FileObjectDatabase db;

    LargePackedDeltaObject(long objectOffset, long baseOffset, int headerLength, PackFile pack, FileObjectDatabase db) {
        this.objectOffset = objectOffset;
        this.baseOffset = baseOffset;
        this.headerLength = headerLength;
        this.pack = pack;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() {
        if (this.type == -1) {
            WindowCursor wc = new WindowCursor(this.db);
            try {
                this.type = this.pack.getObjectType(wc, this.objectOffset);
            }
            catch (IOException packGone) {
                try {
                    this.type = wc.open(this.getObjectId()).getType();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                wc.release();
            }
        }
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        if (this.size == -1L) {
            WindowCursor wc = new WindowCursor(this.db);
            try {
                byte[] b = this.pack.getDeltaHeader(wc, this.objectOffset + (long)this.headerLength);
                this.size = BinaryDelta.getResultSize(b);
            }
            catch (DataFormatException objectCorrupt) {
            }
            catch (IOException packGone) {
                try {
                    this.size = wc.open(this.getObjectId()).getSize();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                wc.release();
            }
        }
        return this.size;
    }

    public boolean isLarge() {
        return true;
    }

    public byte[] getCachedBytes() throws LargeObjectException {
        try {
            throw new LargeObjectException(this.getObjectId());
        }
        catch (IOException cannotObtainId) {
            LargeObjectException err = new LargeObjectException();
            err.initCause(cannotObtainId);
            throw err;
        }
    }

    public ObjectStream openStream() throws MissingObjectException, IOException {
        final WindowCursor wc = new WindowCursor(this.db);
        final ObjectId myId = this.getObjectId();
        ObjectLoader ldr = this.db.openObject2(wc, myId.name(), myId);
        if (ldr != null) {
            return ldr.openStream();
        }
        InputStream in = this.open(wc);
        in = new BufferedInputStream(in, 8192);
        int myType = this.getType();
        long mySize = this.getSize();
        final ObjectDirectoryInserter odi = this.db.newInserter();
        final File tmp = odi.newTempFile();
        DeflaterOutputStream dOut = odi.compress(new FileOutputStream(tmp));
        odi.writeHeader(dOut, myType, mySize);
        in = new TeeInputStream(in, dOut);
        return new ObjectStream.Filter(myType, mySize, in){

            public void close() throws IOException {
                super.close();
                odi.release();
                wc.release();
                LargePackedDeltaObject.this.db.insertUnpackedObject(tmp, myId, true);
            }
        };
    }

    private InputStream open(final WindowCursor wc) throws MissingObjectException, IOException, IncorrectObjectTypeException {
        InputStream delta;
        try {
            delta = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, wc);
        }
        catch (IOException packGone) {
            return wc.open(this.getObjectId()).openStream();
        }
        delta = new InflaterInputStream(delta);
        final ObjectLoader base = this.pack.load(wc, this.baseOffset);
        DeltaStream ds = new DeltaStream(delta){
            private long baseSize;
            {
                super(x0);
                this.baseSize = -1L;
            }

            protected InputStream openBase() throws IOException {
                InputStream in = base instanceof LargePackedDeltaObject ? ((LargePackedDeltaObject)base).open(wc) : base.openStream();
                if (this.baseSize == -1L) {
                    if (in instanceof DeltaStream) {
                        this.baseSize = ((DeltaStream)in).getSize();
                    } else if (in instanceof ObjectStream) {
                        this.baseSize = ((ObjectStream)in).getSize();
                    }
                }
                return in;
            }

            protected long getBaseSize() throws IOException {
                if (this.baseSize == -1L) {
                    this.baseSize = base.getSize();
                }
                return this.baseSize;
            }
        };
        if (this.type == -1 && !(base instanceof LargePackedDeltaObject)) {
            this.type = base.getType();
        }
        if (this.size == -1L) {
            this.size = ds.getSize();
        }
        return ds;
    }

    private ObjectId getObjectId() throws IOException {
        return this.pack.findObjectForOffset(this.objectOffset);
    }
}

