/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace.authorization;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReader;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationReaderV1
extends AuthorizationReader {
    JSONArray readAuthorizationInfo(String userId, IEclipsePreferences preferences) throws JSONException {
        JSONArray newPermissions = new JSONArray();
        this.addPermission(newPermissions, "/users/" + userId);
        WebUser user = WebUser.fromUserId(userId);
        JSONArray workspacesJSON = user.getWorkspacesJSON();
        int i = 0;
        while (i < workspacesJSON.length()) {
            JSONObject workspace = workspacesJSON.getJSONObject(i);
            String workspaceId = workspace.getString("Id");
            this.addPermission(newPermissions, "/workspace/" + workspaceId);
            this.addPermission(newPermissions, "/workspace/" + workspaceId + "/*");
            this.addPermission(newPermissions, "/file/" + workspaceId);
            this.addPermission(newPermissions, "/file/" + workspaceId + "/*");
            ++i;
        }
        return newPermissions;
    }

    private void addPermission(JSONArray permissions, String uri) throws JSONException {
        JSONObject newPermission = AuthorizationService.createUserRight(uri);
        permissions.put((Object)newPermission);
    }
}

