/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.osgi.framework.Bundle;

public class WebappResources {
    private static HashMap resourceBundleTable = new HashMap();

    public static String getString(String name, Locale locale) {
        ResourceBundle bundle = WebappResources.getBundle(locale);
        if (bundle == null) {
            return name;
        }
        try {
            return bundle.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            return name;
        }
    }

    public static String getString(String name, Locale locale, String replace0) {
        ResourceBundle bundle = WebappResources.getBundle(locale);
        if (bundle == null) {
            return name;
        }
        try {
            String stringFromPropertiesFile = bundle.getString(name);
            stringFromPropertiesFile = MessageFormat.format(stringFromPropertiesFile, replace0);
            return stringFromPropertiesFile;
        }
        catch (Exception exception) {
            return name;
        }
    }

    public static String getString(String name, Locale locale, String[] args) {
        ResourceBundle bundle = WebappResources.getBundle(locale);
        if (bundle == null) {
            return name;
        }
        try {
            String stringFromPropertiesFile = bundle.getString(name);
            stringFromPropertiesFile = MessageFormat.format(stringFromPropertiesFile, args);
            return stringFromPropertiesFile;
        }
        catch (Exception exception) {
            return name;
        }
    }

    private static ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle;
        if (locale == null) {
            locale = WebappResources.getDefaultLocale();
        }
        if ((bundle = (ResourceBundle)resourceBundleTable.get(locale)) == null) {
            StringBuffer sb = new StringBuffer();
            String language = locale.getLanguage();
            String contry = locale.getCountry();
            String variant = locale.getVariant();
            ResourceBundle bundle_l = null;
            ResourceBundle bundle_c = null;
            ResourceBundle bundle_v = null;
            if (language != null && language.length() != 0) {
                sb.append("_").append(language);
                bundle_l = WebappResources.getResourceBundle(sb.toString());
            }
            if (contry != null && contry.length() != 0) {
                sb.append("_").append(contry);
                bundle_c = WebappResources.getResourceBundle(sb.toString());
            }
            if (variant != null && variant.length() != 0) {
                sb.append("_").append(variant);
                bundle_v = WebappResources.getResourceBundle(sb.toString());
            }
            if ((bundle = bundle_v != null ? bundle_v : (bundle_c != null ? bundle_c : (bundle_l != null ? bundle_l : WebappResources.getResourceBundle("")))) != null) {
                resourceBundleTable.put(locale, bundle);
            }
        }
        return bundle;
    }

    private static ResourceBundle getResourceBundle(String key) {
        PropertyResourceBundle bundle;
        block16: {
            Bundle hostBundle = Platform.getBundle((String)HelpWebappPlugin.getDefault().getBundle().getSymbolicName());
            if (hostBundle == null) {
                return null;
            }
            URL url = hostBundle.getResource("org/eclipse/help/internal/webapp/WebappResources" + key + ".properties");
            if (url == null) {
                return null;
            }
            InputStream in = null;
            try {
                try {
                    in = url.openStream();
                    bundle = new PropertyResourceBundle(in);
                }
                catch (IOException iOException) {
                    bundle = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bundle;
    }

    private static Locale getDefaultLocale() {
        String nl = Platform.getNL();
        if (nl == null) {
            return Locale.getDefault();
        }
        StringTokenizer locales = new StringTokenizer(nl, "_");
        if (locales.countTokens() == 1) {
            return new Locale(locales.nextToken(), "");
        }
        if (locales.countTokens() == 2) {
            return new Locale(locales.nextToken(), locales.nextToken());
        }
        if (locales.countTokens() == 3) {
            return new Locale(locales.nextToken(), locales.nextToken(), locales.nextToken());
        }
        return Locale.getDefault();
    }
}

