/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.server.core.users.OrionScope;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.service.prefs.BackingStoreException;

public class PreferencesServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private IEclipsePreferences prefRoot;

    public void init() throws ServletException {
        super.init();
        this.prefRoot = new OrionScope().getNode("");
    }

    public void destroy() {
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        IEclipsePreferences node = this.getNode(req, resp, false);
        if (node == null) {
            return;
        }
        String key = req.getParameter("key");
        try {
            JSONObject result = null;
            if (key != null) {
                String value = node.get(key, null);
                if (value == null) {
                    this.handleNotFound(req, resp, 404);
                    return;
                }
                result = new JSONObject().put(key, (Object)value);
            } else {
                result = this.toJSON(req, node);
            }
            PreferencesServlet.writeJSONResponse(req, resp, result);
        }
        catch (Exception e) {
            this.handleException(resp, NLS.bind((String)"Failed to retrieve preferences for path {0}", (Object)req.getPathInfo()), e);
            return;
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IEclipsePreferences node = this.getNode(req, resp, false);
        if (node == null) {
            resp.setStatus(204);
            return;
        }
        String key = req.getParameter("key");
        try {
            if (key != null) {
                node.remove(key);
            } else {
                node.removeNode();
            }
            this.prefRoot.flush();
            resp.setStatus(204);
        }
        catch (Exception e) {
            this.handleException(resp, NLS.bind((String)"Failed to retrieve preferences for path {0}", (Object)req.getPathInfo()), e);
            return;
        }
    }

    private IEclipsePreferences getNode(HttpServletRequest req, HttpServletResponse resp, boolean create) throws ServletException {
        if (this.prefRoot == null) {
            this.handleException(resp, "Unable to obtain preference service", null);
            return null;
        }
        String pathString = req.getPathInfo();
        if (pathString == null) {
            pathString = "";
        }
        Path path = new Path(pathString);
        int segmentCount = path.segmentCount();
        String scope = path.segment(0);
        IPath nodePath = null;
        if ("user".equalsIgnoreCase(scope)) {
            String username = req.getRemoteUser();
            if (username == null) {
                resp.setStatus(403);
                return null;
            }
            nodePath = new Path("Users").append(username);
        } else if ("workspace".equalsIgnoreCase(scope) && segmentCount > 1) {
            nodePath = new Path("Workspaces");
        } else if ("project".equalsIgnoreCase(scope) && segmentCount > 1) {
            nodePath = new Path("Projects");
        } else {
            this.handleNotFound(req, resp, 405);
            return null;
        }
        if (nodePath != null) {
            String childPath = nodePath.append(path.removeFirstSegments(1)).toString();
            try {
                if (create || this.prefRoot.nodeExists(childPath)) {
                    return (IEclipsePreferences)this.prefRoot.node(childPath);
                }
            }
            catch (BackingStoreException backingStoreException) {
                String msg = NLS.bind((String)"Error retrieving preferences for path {0}", (Object)pathString);
                this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg), 500);
                return null;
            }
        }
        this.handleNotFound(req, resp, 404);
        return null;
    }

    private void handleNotFound(HttpServletRequest req, HttpServletResponse resp, int code) throws ServletException {
        String path = req.getPathInfo() == null ? "/" : req.getPathInfo();
        String msg = code == 404 ? "No preferences found for path {0}" : "Invalid preference path {0}";
        this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", NLS.bind((String)msg, (Object)path)), code);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        IEclipsePreferences node = this.getNode(req, resp, true);
        if (node == null) {
            return;
        }
        String key = req.getParameter("key");
        try {
            if (key != null) {
                node.put(key, req.getParameter("value"));
            } else {
                JSONObject newNode = new JSONObject(new JSONTokener((Reader)req.getReader()));
                node.clear();
                Iterator it = newNode.keys();
                while (it.hasNext()) {
                    key = (String)it.next();
                    node.put(key, newNode.getString(key));
                }
            }
            this.prefRoot.flush();
            resp.setStatus(204);
        }
        catch (Exception e) {
            this.handleException(resp, NLS.bind((String)"Failed to store preferences for {0}", (Object)req.getRequestURL()), e);
            return;
        }
    }

    private JSONObject toJSON(HttpServletRequest req, IEclipsePreferences node) throws JSONException, BackingStoreException {
        JSONObject result = new JSONObject();
        String[] stringArray = node.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String valueString = node.get(key, null);
            String value = null;
            if (valueString != null) {
                try {
                    value = new JSONObject(valueString);
                }
                catch (JSONException jSONException) {
                    value = valueString;
                }
            }
            result.put(key, value);
            ++n2;
        }
        return result;
    }
}

