/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.user.securestorage;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.internal.server.user.securestorage.Activator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.resources.Base64Counter;
import org.eclipse.orion.server.useradmin.EmptyAuthorization;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.WebIdeAuthorization;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.useradmin.Authorization;
import org.osgi.service.useradmin.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureStorageCredentialsService
implements IOrionCredentialsService {
    static final String ORION_SERVER_NODE = "org.eclipse.orion.server";
    static final String USERS = "users";
    static final String USER_LOGIN = "login";
    static final String USER_UID = "uid";
    static final String USER_NAME = "name";
    static final String USER_PASSWORD = "password";
    static final String USER_BLOCKED = "blocked";
    static final String USER_EMAIL = "email";
    static final String USER_EMAIL_CONFIRMATION = "email_confirmation";
    static final String USER_ROLES = "roles";
    static final String USER_ROLE_NAME = "name";
    static final String USER_PROPERTIES = "properties";
    static final String ADMIN_LOGIN_VALUE = "admin";
    static final String ADMIN_NAME_VALUE = "Administrator";
    static final String ANONYMOUS_LOGIN_VALUE = "anonymous";
    static final String ANONYMOUS_NAME_VALUE = "Anonymous";
    private static final Base64Counter userCounter = new Base64Counter();
    private ISecurePreferences storage;
    private Map<String, org.eclipse.orion.server.useradmin.Role> roles = new HashMap<String, org.eclipse.orion.server.useradmin.Role>();

    public SecureStorageCredentialsService() {
        this.initSecurePreferences();
        this.initStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextUserId() {
        Base64Counter base64Counter = userCounter;
        synchronized (base64Counter) {
            String candidate;
            do {
                candidate = userCounter.toString();
                userCounter.increment();
            } while (this.findNode(this.storage, candidate) != null);
            return candidate;
        }
    }

    private void initStorage() {
        String[] stringArray = new String[]{ADMIN_LOGIN_VALUE, "user", "quest"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            this.roles.put(role, new org.eclipse.orion.server.useradmin.Role(role, 0));
            ++n2;
        }
        String adminDefaultPassword = PreferenceHelper.getString((String)"orion.auth.admin.default.password");
        User admin = this.getUser(USER_LOGIN, ADMIN_LOGIN_VALUE);
        if (admin == null && adminDefaultPassword != null) {
            admin = this.createUser(new User(ADMIN_LOGIN_VALUE, ADMIN_LOGIN_VALUE, ADMIN_NAME_VALUE, adminDefaultPassword));
        }
        if (admin == null) {
            return;
        }
        try {
            AuthorizationService.addUserRight((String)admin.getUid(), (String)"/users");
            AuthorizationService.addUserRight((String)admin.getUid(), (String)"/users/*");
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void initSecurePreferences() {
        URL location = this.getStorageLocation();
        if (location != null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("org.eclipse.equinox.security.storage.promptUser", Boolean.FALSE);
            String password = System.getProperty("orion.storage.password", "");
            options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(password.toCharArray()));
            try {
                this.storage = SecurePreferencesFactory.open((URL)location, options);
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", "Error initializing user storage location", (Throwable)e));
            }
        } else {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.user.securestorage", "No instance location set. Storing user data in user home directory"));
        }
        if (this.storage == null) {
            this.storage = SecurePreferencesFactory.getDefault().node(ORION_SERVER_NODE);
        }
    }

    private URL getStorageLocation() {
        Collection refs;
        BundleContext context = Activator.getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            return null;
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location != null) {
                URL uRL = location.getDataArea("org.eclipse.orion.server.user.securestorage/user_store");
                return uRL;
            }
        }
        catch (IOException e) {
            LogHelper.log((Throwable)e);
        }
        finally {
            context.ungetService(ref);
        }
        return null;
    }

    public org.eclipse.orion.server.useradmin.Role createRole(String name, int type) {
        throw new UnsupportedOperationException();
    }

    public IStatus removeRole(String name) {
        return new Status(4, "org.eclipse.orion.server.user.securestorage", "Removing roles not supported");
    }

    public org.eclipse.orion.server.useradmin.Role getRole(String name) {
        return this.roles.get(name);
    }

    public org.eclipse.orion.server.useradmin.Role[] getRoles(String filter) throws InvalidSyntaxException {
        return this.roles.values().toArray(new org.eclipse.orion.server.useradmin.Role[0]);
    }

    public Collection<User> getUsers() {
        if (!this.storage.nodeExists(USERS)) {
            return null;
        }
        ISecurePreferences usersPrefs = this.storage.node(USERS);
        ArrayList<User> users = null;
        String[] stringArray = usersPrefs.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            if (users == null) {
                users = new ArrayList<User>();
            }
            ISecurePreferences userPrefs = usersPrefs.node(childName);
            try {
                User user = new User(childName, userPrefs.get(USER_LOGIN, childName), userPrefs.get("name", ""), userPrefs.get(USER_PASSWORD, null) == null ? null : "");
                user.setEmail(userPrefs.get(USER_EMAIL, ""));
                if (userPrefs.getBoolean(USER_BLOCKED, false)) {
                    user.setBlocked(true);
                }
                if (userPrefs.get(USER_EMAIL_CONFIRMATION, null) != null) {
                    user.setConfirmationId(userPrefs.get(USER_EMAIL_CONFIRMATION, null));
                }
                String[] stringArray2 = userPrefs.node(USER_PROPERTIES).keys();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String property = stringArray2[n4];
                    user.addProperty(property, userPrefs.node(USER_PROPERTIES).get(property, null));
                    ++n4;
                }
                stringArray2 = userPrefs.node(USER_ROLES).childrenNames();
                n3 = stringArray2.length;
                n4 = 0;
                while (n4 < n3) {
                    String roleName = stringArray2[n4];
                    user.addRole((Role)this.getRole(roleName));
                    ++n4;
                }
                users.add(user);
            }
            catch (StorageException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Error loading user: " + childName, (Throwable)e));
            }
            ++n2;
        }
        Collections.sort((ArrayList)users, new UserComparator());
        return users;
    }

    public User getUser(String key, String value) {
        if (key.equals(USER_LOGIN)) {
            try {
                ISecurePreferences node = this.findNodeByLoginIgnoreCase(this.storage, value);
                return this.formUser(node);
            }
            catch (StorageException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Can not get user: " + value, (Throwable)e));
            }
        } else {
            if (key.equals(USER_UID)) {
                ISecurePreferences node = this.findNode(this.storage, value);
                return this.formUser(node);
            }
            if (key.equals(USER_EMAIL)) {
                ISecurePreferences usersPref = this.storage.node(USERS);
                String[] stringArray = usersPref.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String uid = stringArray[n2];
                    ISecurePreferences node = usersPref.node(uid);
                    try {
                        String email = node.get(USER_EMAIL, null);
                        if (email != null && email.equals(value)) {
                            return this.formUser(node);
                        }
                    }
                    catch (StorageException storageException) {}
                    ++n2;
                }
            }
        }
        return null;
    }

    public Set<User> getUsersByProperty(String key, String value, boolean regExp, boolean ignoreCase) {
        HashSet<User> ret = new HashSet<User>();
        ISecurePreferences usersPref = this.storage.node(USERS);
        Pattern p = regExp ? Pattern.compile(value, 40) : null;
        String[] stringArray = usersPref.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            ISecurePreferences userNode = usersPref.node(uid);
            ISecurePreferences propsNode = userNode.node(USER_PROPERTIES);
            if (propsNode != null) {
                try {
                    String propertyValue = propsNode.get(key, null);
                    if (propertyValue != null) {
                        boolean hasMatch;
                        if (p != null) {
                            hasMatch = p.matcher(propertyValue).matches();
                        } else {
                            boolean bl = hasMatch = ignoreCase ? propertyValue.equalsIgnoreCase(value) : propertyValue.equals(value);
                        }
                        if (hasMatch) {
                            ret.add(this.formUser(userNode));
                        }
                    }
                }
                catch (StorageException storageException) {}
            }
            ++n2;
        }
        return ret;
    }

    public User formUser(ISecurePreferences node) {
        if (node == null) {
            return null;
        }
        try {
            User user = new User(node.name(), node.get(USER_LOGIN, node.name()), node.get("name", ""), node.get(USER_PASSWORD, null));
            user.setEmail(node.get(USER_EMAIL, ""));
            if (node.getBoolean(USER_BLOCKED, false)) {
                user.setBlocked(true);
            }
            if (node.get(USER_EMAIL_CONFIRMATION, null) != null) {
                user.setConfirmationId(node.get(USER_EMAIL_CONFIRMATION, null));
            }
            String[] stringArray = node.node(USER_ROLES).childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String roleName = stringArray[n2];
                user.addRole((Role)this.getRole(roleName));
                ++n2;
            }
            stringArray = node.node(USER_PROPERTIES).keys();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                user.addProperty(property, node.node(USER_PROPERTIES).get(property, null));
                ++n2;
            }
            return user;
        }
        catch (StorageException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Can not get user " + node.name(), (Throwable)e));
            return null;
        }
    }

    public User createUser(User user) {
        block3: {
            try {
                ISecurePreferences node = this.findNodeByLoginIgnoreCase(this.storage, user.getLogin());
                if (node == null) break block3;
                return null;
            }
            catch (Exception e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Can not create user: " + user.getLogin(), (Throwable)e));
                return null;
            }
        }
        String uid = user.getUid() == null ? this.nextUserId() : user.getUid();
        return this.internalCreateOrUpdateUser(this.storage.node("users/" + uid), user);
    }

    private ISecurePreferences findNodeByLoginIgnoreCase(ISecurePreferences storage, String login) throws StorageException {
        if (login == null) {
            return null;
        }
        ISecurePreferences usersPref = storage.node(USERS);
        String[] childrenNames = usersPref.childrenNames();
        int i = 0;
        while (i < childrenNames.length) {
            if (usersPref.node(childrenNames[i]).get(USER_LOGIN, null) == null) {
                usersPref.node(childrenNames[i]).put(USER_LOGIN, usersPref.node(childrenNames[i]).name(), false);
                if (login.equalsIgnoreCase(usersPref.node(childrenNames[i]).name())) {
                    return usersPref.node(childrenNames[i]);
                }
            } else if (login.equalsIgnoreCase(usersPref.node(childrenNames[i]).get(USER_LOGIN, null))) {
                return usersPref.node(childrenNames[i]);
            }
            ++i;
        }
        return null;
    }

    private ISecurePreferences findNode(ISecurePreferences storage, String uid) {
        if (uid == null) {
            return null;
        }
        ISecurePreferences usersPref = storage.node(USERS);
        String[] childrenNames = usersPref.childrenNames();
        int i = 0;
        while (i < childrenNames.length) {
            if (uid.equals(usersPref.node(childrenNames[i]).name())) {
                return usersPref.node(childrenNames[i]);
            }
            ++i;
        }
        return null;
    }

    public IStatus updateUser(String uid, User user) {
        ISecurePreferences node = this.findNode(this.storage, uid);
        if (node == null) {
            return new ServerStatus(4, 404, "User not found: " + uid, null);
        }
        try {
            ISecurePreferences nodeByLogin = this.findNodeByLoginIgnoreCase(this.storage, user.getLogin());
            if (nodeByLogin != null && !node.name().equals(nodeByLogin.name())) {
                Status status = new Status(4, "org.eclipse.orion.server.user.securestorage", "User already exists " + user.getLogin());
                LogHelper.log((IStatus)status);
                return status;
            }
            this.internalCreateOrUpdateUser(node, user);
            return new Status(0, "org.eclipse.orion.server.user.securestorage", "User updated " + user.getLogin());
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Can not update user: " + user.getLogin(), (Throwable)e);
            LogHelper.log((IStatus)status);
            return status;
        }
    }

    private User internalCreateOrUpdateUser(ISecurePreferences userPrefs, User user) throws StorageException, IOException {
        if (user.getLogin() != null) {
            userPrefs.put(USER_LOGIN, user.getLogin(), false);
        }
        if (user.getName() != null) {
            userPrefs.put("name", user.getName(), false);
        }
        if (user.getPassword() != null) {
            userPrefs.put(USER_PASSWORD, user.getPassword(), true);
        }
        if (user.getBlocked()) {
            userPrefs.put(USER_BLOCKED, String.valueOf(user.getBlocked()), false);
        } else {
            userPrefs.remove(USER_BLOCKED);
        }
        if (user.getEmail() != null) {
            if (user.getEmail().length() > 0 && !user.getEmail().equals(userPrefs.get(USER_EMAIL, null))) {
                user.setConfirmationId();
            }
            userPrefs.put(USER_EMAIL, user.getEmail(), false);
        }
        if (user.getConfirmationId() == null) {
            userPrefs.remove(USER_EMAIL_CONFIRMATION);
        } else {
            userPrefs.put(USER_EMAIL_CONFIRMATION, user.getConfirmationId(), false);
        }
        ISecurePreferences rolesPrefs = userPrefs.node(USER_ROLES);
        String[] stringArray = rolesPrefs.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String roleName = stringArray[n2];
            rolesPrefs.node(roleName).removeNode();
            ++n2;
        }
        for (Role role : user.getRoles()) {
            rolesPrefs.node(((org.eclipse.orion.server.useradmin.Role)role).getName());
        }
        ISecurePreferences propsNode = userPrefs.node(USER_PROPERTIES);
        propsNode.clear();
        Enumeration keys = user.getProperties().keys();
        while (keys.hasMoreElements()) {
            String property = (String)keys.nextElement();
            propsNode.put(property, (String)user.getProperty(property), false);
        }
        userPrefs.flush();
        return this.formUser(userPrefs);
    }

    public boolean deleteUser(User user) {
        if (user == null) {
            return false;
        }
        ISecurePreferences node = this.findNode(this.storage, user.getUid());
        if (node == null) {
            return false;
        }
        node.clear();
        node.removeNode();
        try {
            node.flush();
            this.storage.flush();
            return true;
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Cannot delete user: " + user.getLogin(), (Throwable)e));
            return false;
        }
    }

    public Authorization getAuthorization(User user) {
        if (user instanceof User) {
            return new WebIdeAuthorization(user);
        }
        return new EmptyAuthorization();
    }

    public boolean canCreateUsers() {
        return true;
    }

    public String getStoreName() {
        return "Orion";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UserComparator
    implements Comparator<User> {
        @Override
        public int compare(User u1, User u2) {
            return u1.getLogin().toLowerCase().compareTo(u2.getLogin().toLowerCase());
        }
    }
}

