/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.WebProjectResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.internal.server.servlets.workspace.WebUserResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.internal.server.servlets.workspace.WorkspaceResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONObject;

public class WorkspaceServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private ServletResourceHandler<WebWorkspace> workspaceResourceHandler = new WorkspaceResourceHandler(this.getStatusHandler());
    private ServletResourceHandler<WebProject> projectResourceHandler = new WebProjectResourceHandler();

    private boolean checkUser(String userId, HttpServletResponse response) throws ServletException {
        if (userId == null) {
            this.handleException(response, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "User name not specified"), 403);
            return false;
        }
        return true;
    }

    protected synchronized void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebProject project;
        WebWorkspace workspace;
        this.traceRequest(req);
        String pathString = req.getPathInfo();
        if (pathString == null || pathString.equals("/")) {
            this.doGetWorkspaces(req, resp);
            return;
        }
        Path path = new Path(pathString);
        if (path.segmentCount() == 1 ? this.workspaceResourceHandler.handleRequest(req, resp, workspace = WebWorkspace.fromId(path.segment(0))) : path.segmentCount() == 3 && this.projectResourceHandler.handleRequest(req, resp, project = WebProject.fromId(path.segment(2)))) {
            return;
        }
        super.doGet(req, resp);
    }

    protected synchronized void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebWorkspace workspace;
        this.traceRequest(req);
        String pathString = req.getPathInfo();
        Path path = new Path(pathString == null ? "" : pathString);
        if (path.segmentCount() > 0 && this.workspaceResourceHandler.handleRequest(req, resp, workspace = WebWorkspace.fromId(path.segment(0)))) {
            return;
        }
        super.doDelete(req, resp);
    }

    private boolean doGetWorkspaces(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String userName = this.getUserId(req);
        if (!this.checkUser(userName, resp)) {
            return true;
        }
        try {
            WebUser user = WebUser.fromUserId(userName);
            WorkspaceServlet.writeJSONResponse(req, resp, WebUserResourceHandler.toJSON(user, ServletResourceHandler.getURI(req)));
        }
        catch (Exception e) {
            this.handleException(resp, "An error occurred while obtaining workspace data", e);
        }
        return true;
    }

    protected synchronized void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebWorkspace workspace;
        this.traceRequest(req);
        String pathString = req.getPathInfo();
        if (pathString == null || pathString.equals("/")) {
            this.doCreateWorkspace(req, resp);
            return;
        }
        Path path = new Path(pathString);
        if (path.segmentCount() == 1 && this.workspaceResourceHandler.handleRequest(req, resp, workspace = WebWorkspace.fromId(path.segment(0)))) {
            return;
        }
        super.doPost(req, resp);
    }

    private void doCreateWorkspace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String userId = this.getUserId(req);
        if (!this.checkUser(userId, resp)) {
            return;
        }
        String workspaceName = req.getHeader("Slug");
        if (workspaceName == null) {
            this.handleException(resp, "Workspace name not specified", null, 400);
            return;
        }
        try {
            WebUser user = WebUser.fromUserId(userId);
            WebWorkspace workspace = user.createWorkspace(workspaceName);
            JSONObject result = WorkspaceResourceHandler.toJSON(workspace, ServletResourceHandler.getURI(req));
            WorkspaceServlet.writeJSONResponse(req, resp, result);
            String resultLocation = result.optString("Location");
            resp.setHeader("Location", resultLocation);
            AuthorizationService.addUserRight(req.getRemoteUser(), URI.create(resultLocation).getPath());
            AuthorizationService.addUserRight(req.getRemoteUser(), String.valueOf(URI.create(resultLocation).getPath()) + "/*");
            String filePath = "/file/" + workspace.getId();
            AuthorizationService.addUserRight(req.getRemoteUser(), filePath);
            AuthorizationService.addUserRight(req.getRemoteUser(), String.valueOf(filePath) + "/*");
        }
        catch (CoreException e) {
            this.handleException(resp, e.getStatus());
            return;
        }
    }

    protected synchronized void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebWorkspace workspace;
        Path path;
        this.traceRequest(req);
        String pathString = req.getPathInfo();
        if (pathString != null && (path = new Path(pathString)).segmentCount() == 1 && this.workspaceResourceHandler.handleRequest(req, resp, workspace = WebWorkspace.fromId(path.segment(0)))) {
            return;
        }
        super.doPut(req, resp);
    }

    private String getUserId(HttpServletRequest req) {
        return req.getRemoteUser();
    }
}

